# `plover.i18n` -- Internationalization

```{py:module} plover.i18n
```

This module provides helpers for translating strings throughout the Plover UI,
based on the [`gettext`](https://docs.python.org/3/library/gettext.html) library.
See {doc}`../i18n` for more information on implementing internationalization.

````{class} Translator(package: str, resource_dir: str = 'messages', lang: str = None)
A helper class for translating strings in the UI.

An instance of this class is available as {data}`plover._`.

Translators can also be called directly; `_(...)` is synonymous with
`_.gettext(...)`.

```{attribute} lang
:type: str

The ISO 639 code for the language of this translator. Setting this causes
the translator to load translation catalogs for the specified language, falling
back on other languages if possible.
```

```{method} gettext(message: str) -> str
Returns the translated version of the given message.
See the documentation for [`gettext.gettext`](https://docs.python.org/3/library/gettext.html#gettext.gettext) for more information.
```

```{method} ngettext(singular: str, plural: str, n: int) -> str
A version of {meth}`gettext` that takes plural forms into account.
See the documentation for [`gettext.ngettext`](https://docs.python.org/3/library/gettext.html#gettext.ngettext) for more information.
```

```{method} _(message: str) -> str
Marks a string for translation without translating it.
```
````

```{function} get_language() -> str
Returns the ISO 639 code for the language that the user interface should use.

Plover's interface language can be set with environment variables, or derived
from the system default locale. If the `LANGUAGE` environment variable is
defined, this is automatically considered the interface language; if not,
`LC_ALL`, `LC_MESSAGES` and `LANG` are also checked on Linux and BSD platforms.
Otherwise, the system default locale is used, defaulting to English (`en`).

For testing purposes during development, using the `LANGUAGE` environment
variable is recommended.
```
