<?php

class BasicTest extends \PHPUnit\Framework\TestCase
{
    public function testLineEcho(): void
    {
        $figlet = new Text_Figlet();
        $error = $figlet->LoadFont('/usr/share/php/data/Text_Figlet/fonts/makisupa.flf');
        $this->assertTrue($error);
        $this->assertSame(
            implode(
                "\n",
                [
                    ' ######*                                                                 ##*  ',
                    ' #######*                                                                ##*  ',
                    ' ###*####*                                                               ##*  ',
                    ' ##*  *###   #######    #####*    #######    *###*    ##* *##            ##*  ',
                    ' ##*   *##   #######*   ######*   #######   *#####*   ### *##            ##*  ',
                    ' ##*   *##   ##*****    ##**###   ***##**   ###*###   ###**##            ##*  ',
                    ' ##*   *##   ##*        ##* *##     *##     ##* *##   ####*##            ##*  ',
                    ' ##*   *##   ######     #######     *##     ##* *##   ####*##            ##*  ',
                    ' ##*   *##   ######     ######*     *##     ##***##   #######            ##*  ',
                    ' ##*   *##   ##****     ##**###     *##     #######   ##*####            ##*  ',
                    ' ##*  *###   ##*        ##* *##     *##     #######   ##*####                 ',
                    ' ###*####*   ##*****    ##**###   ***##**   ##* *##   ##**###            **   ',
                    ' #######*    #######*   ######*   #######   ##* *##   ##* ###            ##*  ',
                    ' ######*     #######    #####*    #######   ##* *##   ##* *##            ##*  ',
                    '                                                                              ',
                    '        ',
                ]
            ),
            $figlet->LineEcho("Debian !")
        );
    }
}
