#! /usr/bin/env python

import openturns as ot
import math as m

ot.TESTPREAMBLE()


# Instantiate one distribution object
dim = 1
meanPoint = ot.Point(dim, 1.0)
meanPoint[0] = 0.5
sigma = ot.Point(dim, 1.0)
sigma[0] = 2.0
R = ot.CorrelationMatrix(dim)

distribution1 = ot.Normal(meanPoint, sigma, R)

# Instantiate another distribution object
meanPoint[0] = -1.5
sigma[0] = 4.0

distribution2 = ot.Normal(meanPoint, sigma, R)

# Test for sampling
size = 2000
nBars = 20
sample1 = distribution1.getSample(size)
sample2 = distribution2.getSample(size)

# Construct histograms
epsilon = 0.1
min1 = sample1.getMin()[0]
max1 = sample1.getMax()[0] + epsilon
min2 = sample2.getMin()[0]
max2 = sample2.getMax()[0] + epsilon
tmp = ot.Point(2)
tmp[0] = (max1 - min1) / nBars
data1 = ot.Sample(nBars, tmp)
tmp[0] = (max2 - min2) / nBars
data2 = ot.Sample(nBars, tmp)

for i in range(size):
    index = int(m.floor((sample1[i, 0] - min1) / (max1 - min1) * nBars))
    data1[index, 1] += 1
    index = int(m.floor((sample2[i, 0] - min2) / (max2 - min2) * nBars))
    data2[index, 1] += 1

# Create an empty graph
myGraph = ot.Graph("Some barplots", "y", "frequency", True, "topleft")

# Create the first barplot
myBarPlot1 = ot.BarPlot(data1, min1, "blue", "shaded", "dashed", "histogram1")

# Then, draw it
myGraph.add(myBarPlot1)

# Check that the correct files have been generated by computing their
# checksum

# Create the second barplot
myBarPlot2 = ot.BarPlot(data2, min2, "red", "solid", "solid", "histogram2")

# Add it to the graph and draw everything
myGraph.add(myBarPlot2)
