const tests = [
  [-0x10000000000000001n, -2n, 0x20000000000000002n],
  [-0x10000000000000000n, -2n, 0x20000000000000000n],
  [-0xffffffffffffffffn, -2n, 0x1fffffffffffffffen],
  [-0xfffffffffffffffen, -2n, 0x1fffffffffffffffcn],
  [-0x8000000000000001n, -2n, 0x10000000000000002n],
  [-0x8000000000000000n, -2n, 0x10000000000000000n],
  [-0x7fffffffffffffffn, -2n, 0xfffffffffffffffen],
  [-0x7ffffffffffffffen, -2n, 0xfffffffffffffffcn],
  [-0x100000001n, -2n, 0x200000002n],
  [-0x100000000n, -2n, 0x200000000n],
  [-0xffffffffn, -2n, 0x1fffffffen],
  [-0xfffffffen, -2n, 0x1fffffffcn],
  [-0x80000001n, -2n, 0x100000002n],
  [-0x80000000n, -2n, 0x100000000n],
  [-0x7fffffffn, -2n, 0xfffffffen],
  [-0x7ffffffen, -2n, 0xfffffffcn],
  [-0x10001n, -2n, 0x20002n],
  [-0x10000n, -2n, 0x20000n],
  [-0xffffn, -2n, 0x1fffen],
  [-0xfffen, -2n, 0x1fffcn],
  [-0x8001n, -2n, 0x10002n],
  [-0x8000n, -2n, 0x10000n],
  [-0x7fffn, -2n, 0xfffen],
  [-0x7ffen, -2n, 0xfffcn],
  [-2n, -2n, 4n],
  [-1n, -2n, 2n],
  [0n, -2n, 0n],
  [1n, -2n, -2n],
  [2n, -2n, -4n],
  [0x7ffen, -2n, -0xfffcn],
  [0x7fffn, -2n, -0xfffen],
  [0x8000n, -2n, -0x10000n],
  [0x8001n, -2n, -0x10002n],
  [0xfffen, -2n, -0x1fffcn],
  [0xffffn, -2n, -0x1fffen],
  [0x10000n, -2n, -0x20000n],
  [0x10001n, -2n, -0x20002n],
  [0x7ffffffen, -2n, -0xfffffffcn],
  [0x7fffffffn, -2n, -0xfffffffen],
  [0x80000000n, -2n, -0x100000000n],
  [0x80000001n, -2n, -0x100000002n],
  [0xfffffffen, -2n, -0x1fffffffcn],
  [0xffffffffn, -2n, -0x1fffffffen],
  [0x100000000n, -2n, -0x200000000n],
  [0x100000001n, -2n, -0x200000002n],
  [0x7ffffffffffffffen, -2n, -0xfffffffffffffffcn],
  [0x7fffffffffffffffn, -2n, -0xfffffffffffffffen],
  [0x8000000000000000n, -2n, -0x10000000000000000n],
  [0x8000000000000001n, -2n, -0x10000000000000002n],
  [0xfffffffffffffffen, -2n, -0x1fffffffffffffffcn],
  [0xffffffffffffffffn, -2n, -0x1fffffffffffffffen],
  [0x10000000000000000n, -2n, -0x20000000000000000n],
  [0x10000000000000001n, -2n, -0x20000000000000002n],
  [-0x10000000000000001n, -1n, 0x10000000000000001n],
  [-0x10000000000000000n, -1n, 0x10000000000000000n],
  [-0xffffffffffffffffn, -1n, 0xffffffffffffffffn],
  [-0xfffffffffffffffen, -1n, 0xfffffffffffffffen],
  [-0x8000000000000001n, -1n, 0x8000000000000001n],
  [-0x8000000000000000n, -1n, 0x8000000000000000n],
  [-0x7fffffffffffffffn, -1n, 0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, -1n, 0x7ffffffffffffffen],
  [-0x100000001n, -1n, 0x100000001n],
  [-0x100000000n, -1n, 0x100000000n],
  [-0xffffffffn, -1n, 0xffffffffn],
  [-0xfffffffen, -1n, 0xfffffffen],
  [-0x80000001n, -1n, 0x80000001n],
  [-0x80000000n, -1n, 0x80000000n],
  [-0x7fffffffn, -1n, 0x7fffffffn],
  [-0x7ffffffen, -1n, 0x7ffffffen],
  [-0x10001n, -1n, 0x10001n],
  [-0x10000n, -1n, 0x10000n],
  [-0xffffn, -1n, 0xffffn],
  [-0xfffen, -1n, 0xfffen],
  [-0x8001n, -1n, 0x8001n],
  [-0x8000n, -1n, 0x8000n],
  [-0x7fffn, -1n, 0x7fffn],
  [-0x7ffen, -1n, 0x7ffen],
  [-1n, -1n, 1n],
  [0n, -1n, 0n],
  [1n, -1n, -1n],
  [2n, -1n, -2n],
  [0x7ffen, -1n, -0x7ffen],
  [0x7fffn, -1n, -0x7fffn],
  [0x8000n, -1n, -0x8000n],
  [0x8001n, -1n, -0x8001n],
  [0xfffen, -1n, -0xfffen],
  [0xffffn, -1n, -0xffffn],
  [0x10000n, -1n, -0x10000n],
  [0x10001n, -1n, -0x10001n],
  [0x7ffffffen, -1n, -0x7ffffffen],
  [0x7fffffffn, -1n, -0x7fffffffn],
  [0x80000000n, -1n, -0x80000000n],
  [0x80000001n, -1n, -0x80000001n],
  [0xfffffffen, -1n, -0xfffffffen],
  [0xffffffffn, -1n, -0xffffffffn],
  [0x100000000n, -1n, -0x100000000n],
  [0x100000001n, -1n, -0x100000001n],
  [0x7ffffffffffffffen, -1n, -0x7ffffffffffffffen],
  [0x7fffffffffffffffn, -1n, -0x7fffffffffffffffn],
  [0x8000000000000000n, -1n, -0x8000000000000000n],
  [0x8000000000000001n, -1n, -0x8000000000000001n],
  [0xfffffffffffffffen, -1n, -0xfffffffffffffffen],
  [0xffffffffffffffffn, -1n, -0xffffffffffffffffn],
  [0x10000000000000000n, -1n, -0x10000000000000000n],
  [0x10000000000000001n, -1n, -0x10000000000000001n],
  [-0x10000000000000001n, 0n, 0n],
  [-0x10000000000000000n, 0n, 0n],
  [-0xffffffffffffffffn, 0n, 0n],
  [-0xfffffffffffffffen, 0n, 0n],
  [-0x8000000000000001n, 0n, 0n],
  [-0x8000000000000000n, 0n, 0n],
  [-0x7fffffffffffffffn, 0n, 0n],
  [-0x7ffffffffffffffen, 0n, 0n],
  [-0x100000001n, 0n, 0n],
  [-0x100000000n, 0n, 0n],
  [-0xffffffffn, 0n, 0n],
  [-0xfffffffen, 0n, 0n],
  [-0x80000001n, 0n, 0n],
  [-0x80000000n, 0n, 0n],
  [-0x7fffffffn, 0n, 0n],
  [-0x7ffffffen, 0n, 0n],
  [-0x10001n, 0n, 0n],
  [-0x10000n, 0n, 0n],
  [-0xffffn, 0n, 0n],
  [-0xfffen, 0n, 0n],
  [-0x8001n, 0n, 0n],
  [-0x8000n, 0n, 0n],
  [-0x7fffn, 0n, 0n],
  [-0x7ffen, 0n, 0n],
  [0n, 0n, 0n],
  [1n, 0n, 0n],
  [2n, 0n, 0n],
  [0x7ffen, 0n, 0n],
  [0x7fffn, 0n, 0n],
  [0x8000n, 0n, 0n],
  [0x8001n, 0n, 0n],
  [0xfffen, 0n, 0n],
  [0xffffn, 0n, 0n],
  [0x10000n, 0n, 0n],
  [0x10001n, 0n, 0n],
  [0x7ffffffen, 0n, 0n],
  [0x7fffffffn, 0n, 0n],
  [0x80000000n, 0n, 0n],
  [0x80000001n, 0n, 0n],
  [0xfffffffen, 0n, 0n],
  [0xffffffffn, 0n, 0n],
  [0x100000000n, 0n, 0n],
  [0x100000001n, 0n, 0n],
  [0x7ffffffffffffffen, 0n, 0n],
  [0x7fffffffffffffffn, 0n, 0n],
  [0x8000000000000000n, 0n, 0n],
  [0x8000000000000001n, 0n, 0n],
  [0xfffffffffffffffen, 0n, 0n],
  [0xffffffffffffffffn, 0n, 0n],
  [0x10000000000000000n, 0n, 0n],
  [0x10000000000000001n, 0n, 0n],
  [-0x10000000000000001n, 1n, -0x10000000000000001n],
  [-0x10000000000000000n, 1n, -0x10000000000000000n],
  [-0xffffffffffffffffn, 1n, -0xffffffffffffffffn],
  [-0xfffffffffffffffen, 1n, -0xfffffffffffffffen],
  [-0x8000000000000001n, 1n, -0x8000000000000001n],
  [-0x8000000000000000n, 1n, -0x8000000000000000n],
  [-0x7fffffffffffffffn, 1n, -0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, 1n, -0x7ffffffffffffffen],
  [-0x100000001n, 1n, -0x100000001n],
  [-0x100000000n, 1n, -0x100000000n],
  [-0xffffffffn, 1n, -0xffffffffn],
  [-0xfffffffen, 1n, -0xfffffffen],
  [-0x80000001n, 1n, -0x80000001n],
  [-0x80000000n, 1n, -0x80000000n],
  [-0x7fffffffn, 1n, -0x7fffffffn],
  [-0x7ffffffen, 1n, -0x7ffffffen],
  [-0x10001n, 1n, -0x10001n],
  [-0x10000n, 1n, -0x10000n],
  [-0xffffn, 1n, -0xffffn],
  [-0xfffen, 1n, -0xfffen],
  [-0x8001n, 1n, -0x8001n],
  [-0x8000n, 1n, -0x8000n],
  [-0x7fffn, 1n, -0x7fffn],
  [-0x7ffen, 1n, -0x7ffen],
  [1n, 1n, 1n],
  [2n, 1n, 2n],
  [0x7ffen, 1n, 0x7ffen],
  [0x7fffn, 1n, 0x7fffn],
  [0x8000n, 1n, 0x8000n],
  [0x8001n, 1n, 0x8001n],
  [0xfffen, 1n, 0xfffen],
  [0xffffn, 1n, 0xffffn],
  [0x10000n, 1n, 0x10000n],
  [0x10001n, 1n, 0x10001n],
  [0x7ffffffen, 1n, 0x7ffffffen],
  [0x7fffffffn, 1n, 0x7fffffffn],
  [0x80000000n, 1n, 0x80000000n],
  [0x80000001n, 1n, 0x80000001n],
  [0xfffffffen, 1n, 0xfffffffen],
  [0xffffffffn, 1n, 0xffffffffn],
  [0x100000000n, 1n, 0x100000000n],
  [0x100000001n, 1n, 0x100000001n],
  [0x7ffffffffffffffen, 1n, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 1n, 0x7fffffffffffffffn],
  [0x8000000000000000n, 1n, 0x8000000000000000n],
  [0x8000000000000001n, 1n, 0x8000000000000001n],
  [0xfffffffffffffffen, 1n, 0xfffffffffffffffen],
  [0xffffffffffffffffn, 1n, 0xffffffffffffffffn],
  [0x10000000000000000n, 1n, 0x10000000000000000n],
  [0x10000000000000001n, 1n, 0x10000000000000001n],
  [-0x10000000000000001n, 2n, -0x20000000000000002n],
  [-0x10000000000000000n, 2n, -0x20000000000000000n],
  [-0xffffffffffffffffn, 2n, -0x1fffffffffffffffen],
  [-0xfffffffffffffffen, 2n, -0x1fffffffffffffffcn],
  [-0x8000000000000001n, 2n, -0x10000000000000002n],
  [-0x8000000000000000n, 2n, -0x10000000000000000n],
  [-0x7fffffffffffffffn, 2n, -0xfffffffffffffffen],
  [-0x7ffffffffffffffen, 2n, -0xfffffffffffffffcn],
  [-0x100000001n, 2n, -0x200000002n],
  [-0x100000000n, 2n, -0x200000000n],
  [-0xffffffffn, 2n, -0x1fffffffen],
  [-0xfffffffen, 2n, -0x1fffffffcn],
  [-0x80000001n, 2n, -0x100000002n],
  [-0x80000000n, 2n, -0x100000000n],
  [-0x7fffffffn, 2n, -0xfffffffen],
  [-0x7ffffffen, 2n, -0xfffffffcn],
  [-0x10001n, 2n, -0x20002n],
  [-0x10000n, 2n, -0x20000n],
  [-0xffffn, 2n, -0x1fffen],
  [-0xfffen, 2n, -0x1fffcn],
  [-0x8001n, 2n, -0x10002n],
  [-0x8000n, 2n, -0x10000n],
  [-0x7fffn, 2n, -0xfffen],
  [-0x7ffen, 2n, -0xfffcn],
  [2n, 2n, 4n],
  [0x7ffen, 2n, 0xfffcn],
  [0x7fffn, 2n, 0xfffen],
  [0x8000n, 2n, 0x10000n],
  [0x8001n, 2n, 0x10002n],
  [0xfffen, 2n, 0x1fffcn],
  [0xffffn, 2n, 0x1fffen],
  [0x10000n, 2n, 0x20000n],
  [0x10001n, 2n, 0x20002n],
  [0x7ffffffen, 2n, 0xfffffffcn],
  [0x7fffffffn, 2n, 0xfffffffen],
  [0x80000000n, 2n, 0x100000000n],
  [0x80000001n, 2n, 0x100000002n],
  [0xfffffffen, 2n, 0x1fffffffcn],
  [0xffffffffn, 2n, 0x1fffffffen],
  [0x100000000n, 2n, 0x200000000n],
  [0x100000001n, 2n, 0x200000002n],
  [0x7ffffffffffffffen, 2n, 0xfffffffffffffffcn],
  [0x7fffffffffffffffn, 2n, 0xfffffffffffffffen],
  [0x8000000000000000n, 2n, 0x10000000000000000n],
  [0x8000000000000001n, 2n, 0x10000000000000002n],
  [0xfffffffffffffffen, 2n, 0x1fffffffffffffffcn],
  [0xffffffffffffffffn, 2n, 0x1fffffffffffffffen],
  [0x10000000000000000n, 2n, 0x20000000000000000n],
  [0x10000000000000001n, 2n, 0x20000000000000002n],
  [-0x10000000000000001n, 0x7ffen, -0x7ffe0000000000007ffen],
  [-0x10000000000000000n, 0x7ffen, -0x7ffe0000000000000000n],
  [-0xffffffffffffffffn, 0x7ffen, -0x7ffdffffffffffff8002n],
  [-0xfffffffffffffffen, 0x7ffen, -0x7ffdffffffffffff0004n],
  [-0x8000000000000001n, 0x7ffen, -0x3fff0000000000007ffen],
  [-0x8000000000000000n, 0x7ffen, -0x3fff0000000000000000n],
  [-0x7fffffffffffffffn, 0x7ffen, -0x3ffeffffffffffff8002n],
  [-0x7ffffffffffffffen, 0x7ffen, -0x3ffeffffffffffff0004n],
  [-0x100000001n, 0x7ffen, -0x7ffe00007ffen],
  [-0x100000000n, 0x7ffen, -0x7ffe00000000n],
  [-0xffffffffn, 0x7ffen, -0x7ffdffff8002n],
  [-0xfffffffen, 0x7ffen, -0x7ffdffff0004n],
  [-0x80000001n, 0x7ffen, -0x3fff00007ffen],
  [-0x80000000n, 0x7ffen, -0x3fff00000000n],
  [-0x7fffffffn, 0x7ffen, -0x3ffeffff8002n],
  [-0x7ffffffen, 0x7ffen, -0x3ffeffff0004n],
  [-0x10001n, 0x7ffen, -0x7ffe7ffen],
  [-0x10000n, 0x7ffen, -0x7ffe0000n],
  [-0xffffn, 0x7ffen, -0x7ffd8002n],
  [-0xfffen, 0x7ffen, -0x7ffd0004n],
  [-0x8001n, 0x7ffen, -0x3fff7ffen],
  [-0x8000n, 0x7ffen, -0x3fff0000n],
  [-0x7fffn, 0x7ffen, -0x3ffe8002n],
  [-0x7ffen, 0x7ffen, -0x3ffe0004n],
  [0x7ffen, 0x7ffen, 0x3ffe0004n],
  [0x7fffn, 0x7ffen, 0x3ffe8002n],
  [0x8000n, 0x7ffen, 0x3fff0000n],
  [0x8001n, 0x7ffen, 0x3fff7ffen],
  [0xfffen, 0x7ffen, 0x7ffd0004n],
  [0xffffn, 0x7ffen, 0x7ffd8002n],
  [0x10000n, 0x7ffen, 0x7ffe0000n],
  [0x10001n, 0x7ffen, 0x7ffe7ffen],
  [0x7ffffffen, 0x7ffen, 0x3ffeffff0004n],
  [0x7fffffffn, 0x7ffen, 0x3ffeffff8002n],
  [0x80000000n, 0x7ffen, 0x3fff00000000n],
  [0x80000001n, 0x7ffen, 0x3fff00007ffen],
  [0xfffffffen, 0x7ffen, 0x7ffdffff0004n],
  [0xffffffffn, 0x7ffen, 0x7ffdffff8002n],
  [0x100000000n, 0x7ffen, 0x7ffe00000000n],
  [0x100000001n, 0x7ffen, 0x7ffe00007ffen],
  [0x7ffffffffffffffen, 0x7ffen, 0x3ffeffffffffffff0004n],
  [0x7fffffffffffffffn, 0x7ffen, 0x3ffeffffffffffff8002n],
  [0x8000000000000000n, 0x7ffen, 0x3fff0000000000000000n],
  [0x8000000000000001n, 0x7ffen, 0x3fff0000000000007ffen],
  [0xfffffffffffffffen, 0x7ffen, 0x7ffdffffffffffff0004n],
  [0xffffffffffffffffn, 0x7ffen, 0x7ffdffffffffffff8002n],
  [0x10000000000000000n, 0x7ffen, 0x7ffe0000000000000000n],
  [0x10000000000000001n, 0x7ffen, 0x7ffe0000000000007ffen],
  [-0x10000000000000001n, 0x7fffn, -0x7fff0000000000007fffn],
  [-0x10000000000000000n, 0x7fffn, -0x7fff0000000000000000n],
  [-0xffffffffffffffffn, 0x7fffn, -0x7ffeffffffffffff8001n],
  [-0xfffffffffffffffen, 0x7fffn, -0x7ffeffffffffffff0002n],
  [-0x8000000000000001n, 0x7fffn, -0x3fff8000000000007fffn],
  [-0x8000000000000000n, 0x7fffn, -0x3fff8000000000000000n],
  [-0x7fffffffffffffffn, 0x7fffn, -0x3fff7fffffffffff8001n],
  [-0x7ffffffffffffffen, 0x7fffn, -0x3fff7fffffffffff0002n],
  [-0x100000001n, 0x7fffn, -0x7fff00007fffn],
  [-0x100000000n, 0x7fffn, -0x7fff00000000n],
  [-0xffffffffn, 0x7fffn, -0x7ffeffff8001n],
  [-0xfffffffen, 0x7fffn, -0x7ffeffff0002n],
  [-0x80000001n, 0x7fffn, -0x3fff80007fffn],
  [-0x80000000n, 0x7fffn, -0x3fff80000000n],
  [-0x7fffffffn, 0x7fffn, -0x3fff7fff8001n],
  [-0x7ffffffen, 0x7fffn, -0x3fff7fff0002n],
  [-0x10001n, 0x7fffn, -0x7fff7fffn],
  [-0x10000n, 0x7fffn, -0x7fff0000n],
  [-0xffffn, 0x7fffn, -0x7ffe8001n],
  [-0xfffen, 0x7fffn, -0x7ffe0002n],
  [-0x8001n, 0x7fffn, -0x3fffffffn],
  [-0x8000n, 0x7fffn, -0x3fff8000n],
  [-0x7fffn, 0x7fffn, -0x3fff0001n],
  [-0x7ffen, 0x7fffn, -0x3ffe8002n],
  [0x7fffn, 0x7fffn, 0x3fff0001n],
  [0x8000n, 0x7fffn, 0x3fff8000n],
  [0x8001n, 0x7fffn, 0x3fffffffn],
  [0xfffen, 0x7fffn, 0x7ffe0002n],
  [0xffffn, 0x7fffn, 0x7ffe8001n],
  [0x10000n, 0x7fffn, 0x7fff0000n],
  [0x10001n, 0x7fffn, 0x7fff7fffn],
  [0x7ffffffen, 0x7fffn, 0x3fff7fff0002n],
  [0x7fffffffn, 0x7fffn, 0x3fff7fff8001n],
  [0x80000000n, 0x7fffn, 0x3fff80000000n],
  [0x80000001n, 0x7fffn, 0x3fff80007fffn],
  [0xfffffffen, 0x7fffn, 0x7ffeffff0002n],
  [0xffffffffn, 0x7fffn, 0x7ffeffff8001n],
  [0x100000000n, 0x7fffn, 0x7fff00000000n],
  [0x100000001n, 0x7fffn, 0x7fff00007fffn],
  [0x7ffffffffffffffen, 0x7fffn, 0x3fff7fffffffffff0002n],
  [0x7fffffffffffffffn, 0x7fffn, 0x3fff7fffffffffff8001n],
  [0x8000000000000000n, 0x7fffn, 0x3fff8000000000000000n],
  [0x8000000000000001n, 0x7fffn, 0x3fff8000000000007fffn],
  [0xfffffffffffffffen, 0x7fffn, 0x7ffeffffffffffff0002n],
  [0xffffffffffffffffn, 0x7fffn, 0x7ffeffffffffffff8001n],
  [0x10000000000000000n, 0x7fffn, 0x7fff0000000000000000n],
  [0x10000000000000001n, 0x7fffn, 0x7fff0000000000007fffn],
  [-0x10000000000000001n, 0x8000n, -0x80000000000000008000n],
  [-0x10000000000000000n, 0x8000n, -0x80000000000000000000n],
  [-0xffffffffffffffffn, 0x8000n, -0x7fffffffffffffff8000n],
  [-0xfffffffffffffffen, 0x8000n, -0x7fffffffffffffff0000n],
  [-0x8000000000000001n, 0x8000n, -0x40000000000000008000n],
  [-0x8000000000000000n, 0x8000n, -0x40000000000000000000n],
  [-0x7fffffffffffffffn, 0x8000n, -0x3fffffffffffffff8000n],
  [-0x7ffffffffffffffen, 0x8000n, -0x3fffffffffffffff0000n],
  [-0x100000001n, 0x8000n, -0x800000008000n],
  [-0x100000000n, 0x8000n, -0x800000000000n],
  [-0xffffffffn, 0x8000n, -0x7fffffff8000n],
  [-0xfffffffen, 0x8000n, -0x7fffffff0000n],
  [-0x80000001n, 0x8000n, -0x400000008000n],
  [-0x80000000n, 0x8000n, -0x400000000000n],
  [-0x7fffffffn, 0x8000n, -0x3fffffff8000n],
  [-0x7ffffffen, 0x8000n, -0x3fffffff0000n],
  [-0x10001n, 0x8000n, -0x80008000n],
  [-0x10000n, 0x8000n, -0x80000000n],
  [-0xffffn, 0x8000n, -0x7fff8000n],
  [-0xfffen, 0x8000n, -0x7fff0000n],
  [-0x8001n, 0x8000n, -0x40008000n],
  [-0x8000n, 0x8000n, -0x40000000n],
  [-0x7fffn, 0x8000n, -0x3fff8000n],
  [-0x7ffen, 0x8000n, -0x3fff0000n],
  [0x8000n, 0x8000n, 0x40000000n],
  [0x8001n, 0x8000n, 0x40008000n],
  [0xfffen, 0x8000n, 0x7fff0000n],
  [0xffffn, 0x8000n, 0x7fff8000n],
  [0x10000n, 0x8000n, 0x80000000n],
  [0x10001n, 0x8000n, 0x80008000n],
  [0x7ffffffen, 0x8000n, 0x3fffffff0000n],
  [0x7fffffffn, 0x8000n, 0x3fffffff8000n],
  [0x80000000n, 0x8000n, 0x400000000000n],
  [0x80000001n, 0x8000n, 0x400000008000n],
  [0xfffffffen, 0x8000n, 0x7fffffff0000n],
  [0xffffffffn, 0x8000n, 0x7fffffff8000n],
  [0x100000000n, 0x8000n, 0x800000000000n],
  [0x100000001n, 0x8000n, 0x800000008000n],
  [0x7ffffffffffffffen, 0x8000n, 0x3fffffffffffffff0000n],
  [0x7fffffffffffffffn, 0x8000n, 0x3fffffffffffffff8000n],
  [0x8000000000000000n, 0x8000n, 0x40000000000000000000n],
  [0x8000000000000001n, 0x8000n, 0x40000000000000008000n],
  [0xfffffffffffffffen, 0x8000n, 0x7fffffffffffffff0000n],
  [0xffffffffffffffffn, 0x8000n, 0x7fffffffffffffff8000n],
  [0x10000000000000000n, 0x8000n, 0x80000000000000000000n],
  [0x10000000000000001n, 0x8000n, 0x80000000000000008000n],
  [-0x10000000000000001n, 0x8001n, -0x80010000000000008001n],
  [-0x10000000000000000n, 0x8001n, -0x80010000000000000000n],
  [-0xffffffffffffffffn, 0x8001n, -0x8000ffffffffffff7fffn],
  [-0xfffffffffffffffen, 0x8001n, -0x8000fffffffffffefffen],
  [-0x8000000000000001n, 0x8001n, -0x40008000000000008001n],
  [-0x8000000000000000n, 0x8001n, -0x40008000000000000000n],
  [-0x7fffffffffffffffn, 0x8001n, -0x40007fffffffffff7fffn],
  [-0x7ffffffffffffffen, 0x8001n, -0x40007ffffffffffefffen],
  [-0x100000001n, 0x8001n, -0x800100008001n],
  [-0x100000000n, 0x8001n, -0x800100000000n],
  [-0xffffffffn, 0x8001n, -0x8000ffff7fffn],
  [-0xfffffffen, 0x8001n, -0x8000fffefffen],
  [-0x80000001n, 0x8001n, -0x400080008001n],
  [-0x80000000n, 0x8001n, -0x400080000000n],
  [-0x7fffffffn, 0x8001n, -0x40007fff7fffn],
  [-0x7ffffffen, 0x8001n, -0x40007ffefffen],
  [-0x10001n, 0x8001n, -0x80018001n],
  [-0x10000n, 0x8001n, -0x80010000n],
  [-0xffffn, 0x8001n, -0x80007fffn],
  [-0xfffen, 0x8001n, -0x7ffffffen],
  [-0x8001n, 0x8001n, -0x40010001n],
  [-0x8000n, 0x8001n, -0x40008000n],
  [-0x7fffn, 0x8001n, -0x3fffffffn],
  [-0x7ffen, 0x8001n, -0x3fff7ffen],
  [0x8001n, 0x8001n, 0x40010001n],
  [0xfffen, 0x8001n, 0x7ffffffen],
  [0xffffn, 0x8001n, 0x80007fffn],
  [0x10000n, 0x8001n, 0x80010000n],
  [0x10001n, 0x8001n, 0x80018001n],
  [0x7ffffffen, 0x8001n, 0x40007ffefffen],
  [0x7fffffffn, 0x8001n, 0x40007fff7fffn],
  [0x80000000n, 0x8001n, 0x400080000000n],
  [0x80000001n, 0x8001n, 0x400080008001n],
  [0xfffffffen, 0x8001n, 0x8000fffefffen],
  [0xffffffffn, 0x8001n, 0x8000ffff7fffn],
  [0x100000000n, 0x8001n, 0x800100000000n],
  [0x100000001n, 0x8001n, 0x800100008001n],
  [0x7ffffffffffffffen, 0x8001n, 0x40007ffffffffffefffen],
  [0x7fffffffffffffffn, 0x8001n, 0x40007fffffffffff7fffn],
  [0x8000000000000000n, 0x8001n, 0x40008000000000000000n],
  [0x8000000000000001n, 0x8001n, 0x40008000000000008001n],
  [0xfffffffffffffffen, 0x8001n, 0x8000fffffffffffefffen],
  [0xffffffffffffffffn, 0x8001n, 0x8000ffffffffffff7fffn],
  [0x10000000000000000n, 0x8001n, 0x80010000000000000000n],
  [0x10000000000000001n, 0x8001n, 0x80010000000000008001n],
  [-0x10000000000000001n, -0x8001n, 0x80010000000000008001n],
  [-0x10000000000000000n, -0x8001n, 0x80010000000000000000n],
  [-0xffffffffffffffffn, -0x8001n, 0x8000ffffffffffff7fffn],
  [-0xfffffffffffffffen, -0x8001n, 0x8000fffffffffffefffen],
  [-0x8000000000000001n, -0x8001n, 0x40008000000000008001n],
  [-0x8000000000000000n, -0x8001n, 0x40008000000000000000n],
  [-0x7fffffffffffffffn, -0x8001n, 0x40007fffffffffff7fffn],
  [-0x7ffffffffffffffen, -0x8001n, 0x40007ffffffffffefffen],
  [-0x100000001n, -0x8001n, 0x800100008001n],
  [-0x100000000n, -0x8001n, 0x800100000000n],
  [-0xffffffffn, -0x8001n, 0x8000ffff7fffn],
  [-0xfffffffen, -0x8001n, 0x8000fffefffen],
  [-0x80000001n, -0x8001n, 0x400080008001n],
  [-0x80000000n, -0x8001n, 0x400080000000n],
  [-0x7fffffffn, -0x8001n, 0x40007fff7fffn],
  [-0x7ffffffen, -0x8001n, 0x40007ffefffen],
  [-0x10001n, -0x8001n, 0x80018001n],
  [-0x10000n, -0x8001n, 0x80010000n],
  [-0xffffn, -0x8001n, 0x80007fffn],
  [-0xfffen, -0x8001n, 0x7ffffffen],
  [-0x8001n, -0x8001n, 0x40010001n],
  [-0x8000n, -0x8001n, 0x40008000n],
  [-0x7fffn, -0x8001n, 0x3fffffffn],
  [-0x7ffen, -0x8001n, 0x3fff7ffen],
  [0xfffen, -0x8001n, -0x7ffffffen],
  [0xffffn, -0x8001n, -0x80007fffn],
  [0x10000n, -0x8001n, -0x80010000n],
  [0x10001n, -0x8001n, -0x80018001n],
  [0x7ffffffen, -0x8001n, -0x40007ffefffen],
  [0x7fffffffn, -0x8001n, -0x40007fff7fffn],
  [0x80000000n, -0x8001n, -0x400080000000n],
  [0x80000001n, -0x8001n, -0x400080008001n],
  [0xfffffffen, -0x8001n, -0x8000fffefffen],
  [0xffffffffn, -0x8001n, -0x8000ffff7fffn],
  [0x100000000n, -0x8001n, -0x800100000000n],
  [0x100000001n, -0x8001n, -0x800100008001n],
  [0x7ffffffffffffffen, -0x8001n, -0x40007ffffffffffefffen],
  [0x7fffffffffffffffn, -0x8001n, -0x40007fffffffffff7fffn],
  [0x8000000000000000n, -0x8001n, -0x40008000000000000000n],
  [0x8000000000000001n, -0x8001n, -0x40008000000000008001n],
  [0xfffffffffffffffen, -0x8001n, -0x8000fffffffffffefffen],
  [0xffffffffffffffffn, -0x8001n, -0x8000ffffffffffff7fffn],
  [0x10000000000000000n, -0x8001n, -0x80010000000000000000n],
  [0x10000000000000001n, -0x8001n, -0x80010000000000008001n],
  [-0x10000000000000001n, -0x8000n, 0x80000000000000008000n],
  [-0x10000000000000000n, -0x8000n, 0x80000000000000000000n],
  [-0xffffffffffffffffn, -0x8000n, 0x7fffffffffffffff8000n],
  [-0xfffffffffffffffen, -0x8000n, 0x7fffffffffffffff0000n],
  [-0x8000000000000001n, -0x8000n, 0x40000000000000008000n],
  [-0x8000000000000000n, -0x8000n, 0x40000000000000000000n],
  [-0x7fffffffffffffffn, -0x8000n, 0x3fffffffffffffff8000n],
  [-0x7ffffffffffffffen, -0x8000n, 0x3fffffffffffffff0000n],
  [-0x100000001n, -0x8000n, 0x800000008000n],
  [-0x100000000n, -0x8000n, 0x800000000000n],
  [-0xffffffffn, -0x8000n, 0x7fffffff8000n],
  [-0xfffffffen, -0x8000n, 0x7fffffff0000n],
  [-0x80000001n, -0x8000n, 0x400000008000n],
  [-0x80000000n, -0x8000n, 0x400000000000n],
  [-0x7fffffffn, -0x8000n, 0x3fffffff8000n],
  [-0x7ffffffen, -0x8000n, 0x3fffffff0000n],
  [-0x10001n, -0x8000n, 0x80008000n],
  [-0x10000n, -0x8000n, 0x80000000n],
  [-0xffffn, -0x8000n, 0x7fff8000n],
  [-0xfffen, -0x8000n, 0x7fff0000n],
  [-0x8000n, -0x8000n, 0x40000000n],
  [-0x7fffn, -0x8000n, 0x3fff8000n],
  [-0x7ffen, -0x8000n, 0x3fff0000n],
  [0xfffen, -0x8000n, -0x7fff0000n],
  [0xffffn, -0x8000n, -0x7fff8000n],
  [0x10000n, -0x8000n, -0x80000000n],
  [0x10001n, -0x8000n, -0x80008000n],
  [0x7ffffffen, -0x8000n, -0x3fffffff0000n],
  [0x7fffffffn, -0x8000n, -0x3fffffff8000n],
  [0x80000000n, -0x8000n, -0x400000000000n],
  [0x80000001n, -0x8000n, -0x400000008000n],
  [0xfffffffen, -0x8000n, -0x7fffffff0000n],
  [0xffffffffn, -0x8000n, -0x7fffffff8000n],
  [0x100000000n, -0x8000n, -0x800000000000n],
  [0x100000001n, -0x8000n, -0x800000008000n],
  [0x7ffffffffffffffen, -0x8000n, -0x3fffffffffffffff0000n],
  [0x7fffffffffffffffn, -0x8000n, -0x3fffffffffffffff8000n],
  [0x8000000000000000n, -0x8000n, -0x40000000000000000000n],
  [0x8000000000000001n, -0x8000n, -0x40000000000000008000n],
  [0xfffffffffffffffen, -0x8000n, -0x7fffffffffffffff0000n],
  [0xffffffffffffffffn, -0x8000n, -0x7fffffffffffffff8000n],
  [0x10000000000000000n, -0x8000n, -0x80000000000000000000n],
  [0x10000000000000001n, -0x8000n, -0x80000000000000008000n],
  [-0x10000000000000001n, -0x7fffn, 0x7fff0000000000007fffn],
  [-0x10000000000000000n, -0x7fffn, 0x7fff0000000000000000n],
  [-0xffffffffffffffffn, -0x7fffn, 0x7ffeffffffffffff8001n],
  [-0xfffffffffffffffen, -0x7fffn, 0x7ffeffffffffffff0002n],
  [-0x8000000000000001n, -0x7fffn, 0x3fff8000000000007fffn],
  [-0x8000000000000000n, -0x7fffn, 0x3fff8000000000000000n],
  [-0x7fffffffffffffffn, -0x7fffn, 0x3fff7fffffffffff8001n],
  [-0x7ffffffffffffffen, -0x7fffn, 0x3fff7fffffffffff0002n],
  [-0x100000001n, -0x7fffn, 0x7fff00007fffn],
  [-0x100000000n, -0x7fffn, 0x7fff00000000n],
  [-0xffffffffn, -0x7fffn, 0x7ffeffff8001n],
  [-0xfffffffen, -0x7fffn, 0x7ffeffff0002n],
  [-0x80000001n, -0x7fffn, 0x3fff80007fffn],
  [-0x80000000n, -0x7fffn, 0x3fff80000000n],
  [-0x7fffffffn, -0x7fffn, 0x3fff7fff8001n],
  [-0x7ffffffen, -0x7fffn, 0x3fff7fff0002n],
  [-0x10001n, -0x7fffn, 0x7fff7fffn],
  [-0x10000n, -0x7fffn, 0x7fff0000n],
  [-0xffffn, -0x7fffn, 0x7ffe8001n],
  [-0xfffen, -0x7fffn, 0x7ffe0002n],
  [-0x7fffn, -0x7fffn, 0x3fff0001n],
  [-0x7ffen, -0x7fffn, 0x3ffe8002n],
  [0xfffen, -0x7fffn, -0x7ffe0002n],
  [0xffffn, -0x7fffn, -0x7ffe8001n],
  [0x10000n, -0x7fffn, -0x7fff0000n],
  [0x10001n, -0x7fffn, -0x7fff7fffn],
  [0x7ffffffen, -0x7fffn, -0x3fff7fff0002n],
  [0x7fffffffn, -0x7fffn, -0x3fff7fff8001n],
  [0x80000000n, -0x7fffn, -0x3fff80000000n],
  [0x80000001n, -0x7fffn, -0x3fff80007fffn],
  [0xfffffffen, -0x7fffn, -0x7ffeffff0002n],
  [0xffffffffn, -0x7fffn, -0x7ffeffff8001n],
  [0x100000000n, -0x7fffn, -0x7fff00000000n],
  [0x100000001n, -0x7fffn, -0x7fff00007fffn],
  [0x7ffffffffffffffen, -0x7fffn, -0x3fff7fffffffffff0002n],
  [0x7fffffffffffffffn, -0x7fffn, -0x3fff7fffffffffff8001n],
  [0x8000000000000000n, -0x7fffn, -0x3fff8000000000000000n],
  [0x8000000000000001n, -0x7fffn, -0x3fff8000000000007fffn],
  [0xfffffffffffffffen, -0x7fffn, -0x7ffeffffffffffff0002n],
  [0xffffffffffffffffn, -0x7fffn, -0x7ffeffffffffffff8001n],
  [0x10000000000000000n, -0x7fffn, -0x7fff0000000000000000n],
  [0x10000000000000001n, -0x7fffn, -0x7fff0000000000007fffn],
  [-0x10000000000000001n, -0x7ffen, 0x7ffe0000000000007ffen],
  [-0x10000000000000000n, -0x7ffen, 0x7ffe0000000000000000n],
  [-0xffffffffffffffffn, -0x7ffen, 0x7ffdffffffffffff8002n],
  [-0xfffffffffffffffen, -0x7ffen, 0x7ffdffffffffffff0004n],
  [-0x8000000000000001n, -0x7ffen, 0x3fff0000000000007ffen],
  [-0x8000000000000000n, -0x7ffen, 0x3fff0000000000000000n],
  [-0x7fffffffffffffffn, -0x7ffen, 0x3ffeffffffffffff8002n],
  [-0x7ffffffffffffffen, -0x7ffen, 0x3ffeffffffffffff0004n],
  [-0x100000001n, -0x7ffen, 0x7ffe00007ffen],
  [-0x100000000n, -0x7ffen, 0x7ffe00000000n],
  [-0xffffffffn, -0x7ffen, 0x7ffdffff8002n],
  [-0xfffffffen, -0x7ffen, 0x7ffdffff0004n],
  [-0x80000001n, -0x7ffen, 0x3fff00007ffen],
  [-0x80000000n, -0x7ffen, 0x3fff00000000n],
  [-0x7fffffffn, -0x7ffen, 0x3ffeffff8002n],
  [-0x7ffffffen, -0x7ffen, 0x3ffeffff0004n],
  [-0x10001n, -0x7ffen, 0x7ffe7ffen],
  [-0x10000n, -0x7ffen, 0x7ffe0000n],
  [-0xffffn, -0x7ffen, 0x7ffd8002n],
  [-0xfffen, -0x7ffen, 0x7ffd0004n],
  [-0x7ffen, -0x7ffen, 0x3ffe0004n],
  [0xfffen, -0x7ffen, -0x7ffd0004n],
  [0xffffn, -0x7ffen, -0x7ffd8002n],
  [0x10000n, -0x7ffen, -0x7ffe0000n],
  [0x10001n, -0x7ffen, -0x7ffe7ffen],
  [0x7ffffffen, -0x7ffen, -0x3ffeffff0004n],
  [0x7fffffffn, -0x7ffen, -0x3ffeffff8002n],
  [0x80000000n, -0x7ffen, -0x3fff00000000n],
  [0x80000001n, -0x7ffen, -0x3fff00007ffen],
  [0xfffffffen, -0x7ffen, -0x7ffdffff0004n],
  [0xffffffffn, -0x7ffen, -0x7ffdffff8002n],
  [0x100000000n, -0x7ffen, -0x7ffe00000000n],
  [0x100000001n, -0x7ffen, -0x7ffe00007ffen],
  [0x7ffffffffffffffen, -0x7ffen, -0x3ffeffffffffffff0004n],
  [0x7fffffffffffffffn, -0x7ffen, -0x3ffeffffffffffff8002n],
  [0x8000000000000000n, -0x7ffen, -0x3fff0000000000000000n],
  [0x8000000000000001n, -0x7ffen, -0x3fff0000000000007ffen],
  [0xfffffffffffffffen, -0x7ffen, -0x7ffdffffffffffff0004n],
  [0xffffffffffffffffn, -0x7ffen, -0x7ffdffffffffffff8002n],
  [0x10000000000000000n, -0x7ffen, -0x7ffe0000000000000000n],
  [0x10000000000000001n, -0x7ffen, -0x7ffe0000000000007ffen],
  [-0x10000000000000001n, 0xfffen, -0xfffe000000000000fffen],
  [-0x10000000000000000n, 0xfffen, -0xfffe0000000000000000n],
  [-0xffffffffffffffffn, 0xfffen, -0xfffdffffffffffff0002n],
  [-0xfffffffffffffffen, 0xfffen, -0xfffdfffffffffffe0004n],
  [-0x8000000000000001n, 0xfffen, -0x7fff000000000000fffen],
  [-0x8000000000000000n, 0xfffen, -0x7fff0000000000000000n],
  [-0x7fffffffffffffffn, 0xfffen, -0x7ffeffffffffffff0002n],
  [-0x7ffffffffffffffen, 0xfffen, -0x7ffefffffffffffe0004n],
  [-0x100000001n, 0xfffen, -0xfffe0000fffen],
  [-0x100000000n, 0xfffen, -0xfffe00000000n],
  [-0xffffffffn, 0xfffen, -0xfffdffff0002n],
  [-0xfffffffen, 0xfffen, -0xfffdfffe0004n],
  [-0x80000001n, 0xfffen, -0x7fff0000fffen],
  [-0x80000000n, 0xfffen, -0x7fff00000000n],
  [-0x7fffffffn, 0xfffen, -0x7ffeffff0002n],
  [-0x7ffffffen, 0xfffen, -0x7ffefffe0004n],
  [-0x10001n, 0xfffen, -0xfffefffen],
  [-0x10000n, 0xfffen, -0xfffe0000n],
  [-0xffffn, 0xfffen, -0xfffd0002n],
  [-0xfffen, 0xfffen, -0xfffc0004n],
  [0xfffen, 0xfffen, 0xfffc0004n],
  [0xffffn, 0xfffen, 0xfffd0002n],
  [0x10000n, 0xfffen, 0xfffe0000n],
  [0x10001n, 0xfffen, 0xfffefffen],
  [0x7ffffffen, 0xfffen, 0x7ffefffe0004n],
  [0x7fffffffn, 0xfffen, 0x7ffeffff0002n],
  [0x80000000n, 0xfffen, 0x7fff00000000n],
  [0x80000001n, 0xfffen, 0x7fff0000fffen],
  [0xfffffffen, 0xfffen, 0xfffdfffe0004n],
  [0xffffffffn, 0xfffen, 0xfffdffff0002n],
  [0x100000000n, 0xfffen, 0xfffe00000000n],
  [0x100000001n, 0xfffen, 0xfffe0000fffen],
  [0x7ffffffffffffffen, 0xfffen, 0x7ffefffffffffffe0004n],
  [0x7fffffffffffffffn, 0xfffen, 0x7ffeffffffffffff0002n],
  [0x8000000000000000n, 0xfffen, 0x7fff0000000000000000n],
  [0x8000000000000001n, 0xfffen, 0x7fff000000000000fffen],
  [0xfffffffffffffffen, 0xfffen, 0xfffdfffffffffffe0004n],
  [0xffffffffffffffffn, 0xfffen, 0xfffdffffffffffff0002n],
  [0x10000000000000000n, 0xfffen, 0xfffe0000000000000000n],
  [0x10000000000000001n, 0xfffen, 0xfffe000000000000fffen],
  [-0x10000000000000001n, 0xffffn, -0xffff000000000000ffffn],
  [-0x10000000000000000n, 0xffffn, -0xffff0000000000000000n],
  [-0xffffffffffffffffn, 0xffffn, -0xfffeffffffffffff0001n],
  [-0xfffffffffffffffen, 0xffffn, -0xfffefffffffffffe0002n],
  [-0x8000000000000001n, 0xffffn, -0x7fff800000000000ffffn],
  [-0x8000000000000000n, 0xffffn, -0x7fff8000000000000000n],
  [-0x7fffffffffffffffn, 0xffffn, -0x7fff7fffffffffff0001n],
  [-0x7ffffffffffffffen, 0xffffn, -0x7fff7ffffffffffe0002n],
  [-0x100000001n, 0xffffn, -0xffff0000ffffn],
  [-0x100000000n, 0xffffn, -0xffff00000000n],
  [-0xffffffffn, 0xffffn, -0xfffeffff0001n],
  [-0xfffffffen, 0xffffn, -0xfffefffe0002n],
  [-0x80000001n, 0xffffn, -0x7fff8000ffffn],
  [-0x80000000n, 0xffffn, -0x7fff80000000n],
  [-0x7fffffffn, 0xffffn, -0x7fff7fff0001n],
  [-0x7ffffffen, 0xffffn, -0x7fff7ffe0002n],
  [-0x10001n, 0xffffn, -0xffffffffn],
  [-0x10000n, 0xffffn, -0xffff0000n],
  [-0xffffn, 0xffffn, -0xfffe0001n],
  [-0xfffen, 0xffffn, -0xfffd0002n],
  [0xffffn, 0xffffn, 0xfffe0001n],
  [0x10000n, 0xffffn, 0xffff0000n],
  [0x10001n, 0xffffn, 0xffffffffn],
  [0x7ffffffen, 0xffffn, 0x7fff7ffe0002n],
  [0x7fffffffn, 0xffffn, 0x7fff7fff0001n],
  [0x80000000n, 0xffffn, 0x7fff80000000n],
  [0x80000001n, 0xffffn, 0x7fff8000ffffn],
  [0xfffffffen, 0xffffn, 0xfffefffe0002n],
  [0xffffffffn, 0xffffn, 0xfffeffff0001n],
  [0x100000000n, 0xffffn, 0xffff00000000n],
  [0x100000001n, 0xffffn, 0xffff0000ffffn],
  [0x7ffffffffffffffen, 0xffffn, 0x7fff7ffffffffffe0002n],
  [0x7fffffffffffffffn, 0xffffn, 0x7fff7fffffffffff0001n],
  [0x8000000000000000n, 0xffffn, 0x7fff8000000000000000n],
  [0x8000000000000001n, 0xffffn, 0x7fff800000000000ffffn],
  [0xfffffffffffffffen, 0xffffn, 0xfffefffffffffffe0002n],
  [0xffffffffffffffffn, 0xffffn, 0xfffeffffffffffff0001n],
  [0x10000000000000000n, 0xffffn, 0xffff0000000000000000n],
  [0x10000000000000001n, 0xffffn, 0xffff000000000000ffffn],
  [-0x10000000000000001n, 0x10000n, -0x100000000000000010000n],
  [-0x10000000000000000n, 0x10000n, -0x100000000000000000000n],
  [-0xffffffffffffffffn, 0x10000n, -0xffffffffffffffff0000n],
  [-0xfffffffffffffffen, 0x10000n, -0xfffffffffffffffe0000n],
  [-0x8000000000000001n, 0x10000n, -0x80000000000000010000n],
  [-0x8000000000000000n, 0x10000n, -0x80000000000000000000n],
  [-0x7fffffffffffffffn, 0x10000n, -0x7fffffffffffffff0000n],
  [-0x7ffffffffffffffen, 0x10000n, -0x7ffffffffffffffe0000n],
  [-0x100000001n, 0x10000n, -0x1000000010000n],
  [-0x100000000n, 0x10000n, -0x1000000000000n],
  [-0xffffffffn, 0x10000n, -0xffffffff0000n],
  [-0xfffffffen, 0x10000n, -0xfffffffe0000n],
  [-0x80000001n, 0x10000n, -0x800000010000n],
  [-0x80000000n, 0x10000n, -0x800000000000n],
  [-0x7fffffffn, 0x10000n, -0x7fffffff0000n],
  [-0x7ffffffen, 0x10000n, -0x7ffffffe0000n],
  [-0x10001n, 0x10000n, -0x100010000n],
  [-0x10000n, 0x10000n, -0x100000000n],
  [-0xffffn, 0x10000n, -0xffff0000n],
  [-0xfffen, 0x10000n, -0xfffe0000n],
  [0x10000n, 0x10000n, 0x100000000n],
  [0x10001n, 0x10000n, 0x100010000n],
  [0x7ffffffen, 0x10000n, 0x7ffffffe0000n],
  [0x7fffffffn, 0x10000n, 0x7fffffff0000n],
  [0x80000000n, 0x10000n, 0x800000000000n],
  [0x80000001n, 0x10000n, 0x800000010000n],
  [0xfffffffen, 0x10000n, 0xfffffffe0000n],
  [0xffffffffn, 0x10000n, 0xffffffff0000n],
  [0x100000000n, 0x10000n, 0x1000000000000n],
  [0x100000001n, 0x10000n, 0x1000000010000n],
  [0x7ffffffffffffffen, 0x10000n, 0x7ffffffffffffffe0000n],
  [0x7fffffffffffffffn, 0x10000n, 0x7fffffffffffffff0000n],
  [0x8000000000000000n, 0x10000n, 0x80000000000000000000n],
  [0x8000000000000001n, 0x10000n, 0x80000000000000010000n],
  [0xfffffffffffffffen, 0x10000n, 0xfffffffffffffffe0000n],
  [0xffffffffffffffffn, 0x10000n, 0xffffffffffffffff0000n],
  [0x10000000000000000n, 0x10000n, 0x100000000000000000000n],
  [0x10000000000000001n, 0x10000n, 0x100000000000000010000n],
  [-0x10000000000000001n, 0x10001n, -0x100010000000000010001n],
  [-0x10000000000000000n, 0x10001n, -0x100010000000000000000n],
  [-0xffffffffffffffffn, 0x10001n, -0x10000fffffffffffeffffn],
  [-0xfffffffffffffffen, 0x10001n, -0x10000fffffffffffdfffen],
  [-0x8000000000000001n, 0x10001n, -0x80008000000000010001n],
  [-0x8000000000000000n, 0x10001n, -0x80008000000000000000n],
  [-0x7fffffffffffffffn, 0x10001n, -0x80007ffffffffffeffffn],
  [-0x7ffffffffffffffen, 0x10001n, -0x80007ffffffffffdfffen],
  [-0x100000001n, 0x10001n, -0x1000100010001n],
  [-0x100000000n, 0x10001n, -0x1000100000000n],
  [-0xffffffffn, 0x10001n, -0x10000fffeffffn],
  [-0xfffffffen, 0x10001n, -0x10000fffdfffen],
  [-0x80000001n, 0x10001n, -0x800080010001n],
  [-0x80000000n, 0x10001n, -0x800080000000n],
  [-0x7fffffffn, 0x10001n, -0x80007ffeffffn],
  [-0x7ffffffen, 0x10001n, -0x80007ffdfffen],
  [-0x10001n, 0x10001n, -0x100020001n],
  [-0x10000n, 0x10001n, -0x100010000n],
  [-0xffffn, 0x10001n, -0xffffffffn],
  [-0xfffen, 0x10001n, -0xfffefffen],
  [0x10001n, 0x10001n, 0x100020001n],
  [0x7ffffffen, 0x10001n, 0x80007ffdfffen],
  [0x7fffffffn, 0x10001n, 0x80007ffeffffn],
  [0x80000000n, 0x10001n, 0x800080000000n],
  [0x80000001n, 0x10001n, 0x800080010001n],
  [0xfffffffen, 0x10001n, 0x10000fffdfffen],
  [0xffffffffn, 0x10001n, 0x10000fffeffffn],
  [0x100000000n, 0x10001n, 0x1000100000000n],
  [0x100000001n, 0x10001n, 0x1000100010001n],
  [0x7ffffffffffffffen, 0x10001n, 0x80007ffffffffffdfffen],
  [0x7fffffffffffffffn, 0x10001n, 0x80007ffffffffffeffffn],
  [0x8000000000000000n, 0x10001n, 0x80008000000000000000n],
  [0x8000000000000001n, 0x10001n, 0x80008000000000010001n],
  [0xfffffffffffffffen, 0x10001n, 0x10000fffffffffffdfffen],
  [0xffffffffffffffffn, 0x10001n, 0x10000fffffffffffeffffn],
  [0x10000000000000000n, 0x10001n, 0x100010000000000000000n],
  [0x10000000000000001n, 0x10001n, 0x100010000000000010001n],
  [-0x10000000000000001n, -0x10001n, 0x100010000000000010001n],
  [-0x10000000000000000n, -0x10001n, 0x100010000000000000000n],
  [-0xffffffffffffffffn, -0x10001n, 0x10000fffffffffffeffffn],
  [-0xfffffffffffffffen, -0x10001n, 0x10000fffffffffffdfffen],
  [-0x8000000000000001n, -0x10001n, 0x80008000000000010001n],
  [-0x8000000000000000n, -0x10001n, 0x80008000000000000000n],
  [-0x7fffffffffffffffn, -0x10001n, 0x80007ffffffffffeffffn],
  [-0x7ffffffffffffffen, -0x10001n, 0x80007ffffffffffdfffen],
  [-0x100000001n, -0x10001n, 0x1000100010001n],
  [-0x100000000n, -0x10001n, 0x1000100000000n],
  [-0xffffffffn, -0x10001n, 0x10000fffeffffn],
  [-0xfffffffen, -0x10001n, 0x10000fffdfffen],
  [-0x80000001n, -0x10001n, 0x800080010001n],
  [-0x80000000n, -0x10001n, 0x800080000000n],
  [-0x7fffffffn, -0x10001n, 0x80007ffeffffn],
  [-0x7ffffffen, -0x10001n, 0x80007ffdfffen],
  [-0x10001n, -0x10001n, 0x100020001n],
  [-0x10000n, -0x10001n, 0x100010000n],
  [-0xffffn, -0x10001n, 0xffffffffn],
  [-0xfffen, -0x10001n, 0xfffefffen],
  [0x7ffffffen, -0x10001n, -0x80007ffdfffen],
  [0x7fffffffn, -0x10001n, -0x80007ffeffffn],
  [0x80000000n, -0x10001n, -0x800080000000n],
  [0x80000001n, -0x10001n, -0x800080010001n],
  [0xfffffffen, -0x10001n, -0x10000fffdfffen],
  [0xffffffffn, -0x10001n, -0x10000fffeffffn],
  [0x100000000n, -0x10001n, -0x1000100000000n],
  [0x100000001n, -0x10001n, -0x1000100010001n],
  [0x7ffffffffffffffen, -0x10001n, -0x80007ffffffffffdfffen],
  [0x7fffffffffffffffn, -0x10001n, -0x80007ffffffffffeffffn],
  [0x8000000000000000n, -0x10001n, -0x80008000000000000000n],
  [0x8000000000000001n, -0x10001n, -0x80008000000000010001n],
  [0xfffffffffffffffen, -0x10001n, -0x10000fffffffffffdfffen],
  [0xffffffffffffffffn, -0x10001n, -0x10000fffffffffffeffffn],
  [0x10000000000000000n, -0x10001n, -0x100010000000000000000n],
  [0x10000000000000001n, -0x10001n, -0x100010000000000010001n],
  [-0x10000000000000001n, -0x10000n, 0x100000000000000010000n],
  [-0x10000000000000000n, -0x10000n, 0x100000000000000000000n],
  [-0xffffffffffffffffn, -0x10000n, 0xffffffffffffffff0000n],
  [-0xfffffffffffffffen, -0x10000n, 0xfffffffffffffffe0000n],
  [-0x8000000000000001n, -0x10000n, 0x80000000000000010000n],
  [-0x8000000000000000n, -0x10000n, 0x80000000000000000000n],
  [-0x7fffffffffffffffn, -0x10000n, 0x7fffffffffffffff0000n],
  [-0x7ffffffffffffffen, -0x10000n, 0x7ffffffffffffffe0000n],
  [-0x100000001n, -0x10000n, 0x1000000010000n],
  [-0x100000000n, -0x10000n, 0x1000000000000n],
  [-0xffffffffn, -0x10000n, 0xffffffff0000n],
  [-0xfffffffen, -0x10000n, 0xfffffffe0000n],
  [-0x80000001n, -0x10000n, 0x800000010000n],
  [-0x80000000n, -0x10000n, 0x800000000000n],
  [-0x7fffffffn, -0x10000n, 0x7fffffff0000n],
  [-0x7ffffffen, -0x10000n, 0x7ffffffe0000n],
  [-0x10000n, -0x10000n, 0x100000000n],
  [-0xffffn, -0x10000n, 0xffff0000n],
  [-0xfffen, -0x10000n, 0xfffe0000n],
  [0x7ffffffen, -0x10000n, -0x7ffffffe0000n],
  [0x7fffffffn, -0x10000n, -0x7fffffff0000n],
  [0x80000000n, -0x10000n, -0x800000000000n],
  [0x80000001n, -0x10000n, -0x800000010000n],
  [0xfffffffen, -0x10000n, -0xfffffffe0000n],
  [0xffffffffn, -0x10000n, -0xffffffff0000n],
  [0x100000000n, -0x10000n, -0x1000000000000n],
  [0x100000001n, -0x10000n, -0x1000000010000n],
  [0x7ffffffffffffffen, -0x10000n, -0x7ffffffffffffffe0000n],
  [0x7fffffffffffffffn, -0x10000n, -0x7fffffffffffffff0000n],
  [0x8000000000000000n, -0x10000n, -0x80000000000000000000n],
  [0x8000000000000001n, -0x10000n, -0x80000000000000010000n],
  [0xfffffffffffffffen, -0x10000n, -0xfffffffffffffffe0000n],
  [0xffffffffffffffffn, -0x10000n, -0xffffffffffffffff0000n],
  [0x10000000000000000n, -0x10000n, -0x100000000000000000000n],
  [0x10000000000000001n, -0x10000n, -0x100000000000000010000n],
  [-0x10000000000000001n, -0xffffn, 0xffff000000000000ffffn],
  [-0x10000000000000000n, -0xffffn, 0xffff0000000000000000n],
  [-0xffffffffffffffffn, -0xffffn, 0xfffeffffffffffff0001n],
  [-0xfffffffffffffffen, -0xffffn, 0xfffefffffffffffe0002n],
  [-0x8000000000000001n, -0xffffn, 0x7fff800000000000ffffn],
  [-0x8000000000000000n, -0xffffn, 0x7fff8000000000000000n],
  [-0x7fffffffffffffffn, -0xffffn, 0x7fff7fffffffffff0001n],
  [-0x7ffffffffffffffen, -0xffffn, 0x7fff7ffffffffffe0002n],
  [-0x100000001n, -0xffffn, 0xffff0000ffffn],
  [-0x100000000n, -0xffffn, 0xffff00000000n],
  [-0xffffffffn, -0xffffn, 0xfffeffff0001n],
  [-0xfffffffen, -0xffffn, 0xfffefffe0002n],
  [-0x80000001n, -0xffffn, 0x7fff8000ffffn],
  [-0x80000000n, -0xffffn, 0x7fff80000000n],
  [-0x7fffffffn, -0xffffn, 0x7fff7fff0001n],
  [-0x7ffffffen, -0xffffn, 0x7fff7ffe0002n],
  [-0xffffn, -0xffffn, 0xfffe0001n],
  [-0xfffen, -0xffffn, 0xfffd0002n],
  [0x7ffffffen, -0xffffn, -0x7fff7ffe0002n],
  [0x7fffffffn, -0xffffn, -0x7fff7fff0001n],
  [0x80000000n, -0xffffn, -0x7fff80000000n],
  [0x80000001n, -0xffffn, -0x7fff8000ffffn],
  [0xfffffffen, -0xffffn, -0xfffefffe0002n],
  [0xffffffffn, -0xffffn, -0xfffeffff0001n],
  [0x100000000n, -0xffffn, -0xffff00000000n],
  [0x100000001n, -0xffffn, -0xffff0000ffffn],
  [0x7ffffffffffffffen, -0xffffn, -0x7fff7ffffffffffe0002n],
  [0x7fffffffffffffffn, -0xffffn, -0x7fff7fffffffffff0001n],
  [0x8000000000000000n, -0xffffn, -0x7fff8000000000000000n],
  [0x8000000000000001n, -0xffffn, -0x7fff800000000000ffffn],
  [0xfffffffffffffffen, -0xffffn, -0xfffefffffffffffe0002n],
  [0xffffffffffffffffn, -0xffffn, -0xfffeffffffffffff0001n],
  [0x10000000000000000n, -0xffffn, -0xffff0000000000000000n],
  [0x10000000000000001n, -0xffffn, -0xffff000000000000ffffn],
  [-0x10000000000000001n, -0xfffen, 0xfffe000000000000fffen],
  [-0x10000000000000000n, -0xfffen, 0xfffe0000000000000000n],
  [-0xffffffffffffffffn, -0xfffen, 0xfffdffffffffffff0002n],
  [-0xfffffffffffffffen, -0xfffen, 0xfffdfffffffffffe0004n],
  [-0x8000000000000001n, -0xfffen, 0x7fff000000000000fffen],
  [-0x8000000000000000n, -0xfffen, 0x7fff0000000000000000n],
  [-0x7fffffffffffffffn, -0xfffen, 0x7ffeffffffffffff0002n],
  [-0x7ffffffffffffffen, -0xfffen, 0x7ffefffffffffffe0004n],
  [-0x100000001n, -0xfffen, 0xfffe0000fffen],
  [-0x100000000n, -0xfffen, 0xfffe00000000n],
  [-0xffffffffn, -0xfffen, 0xfffdffff0002n],
  [-0xfffffffen, -0xfffen, 0xfffdfffe0004n],
  [-0x80000001n, -0xfffen, 0x7fff0000fffen],
  [-0x80000000n, -0xfffen, 0x7fff00000000n],
  [-0x7fffffffn, -0xfffen, 0x7ffeffff0002n],
  [-0x7ffffffen, -0xfffen, 0x7ffefffe0004n],
  [-0xfffen, -0xfffen, 0xfffc0004n],
  [0x7ffffffen, -0xfffen, -0x7ffefffe0004n],
  [0x7fffffffn, -0xfffen, -0x7ffeffff0002n],
  [0x80000000n, -0xfffen, -0x7fff00000000n],
  [0x80000001n, -0xfffen, -0x7fff0000fffen],
  [0xfffffffen, -0xfffen, -0xfffdfffe0004n],
  [0xffffffffn, -0xfffen, -0xfffdffff0002n],
  [0x100000000n, -0xfffen, -0xfffe00000000n],
  [0x100000001n, -0xfffen, -0xfffe0000fffen],
  [0x7ffffffffffffffen, -0xfffen, -0x7ffefffffffffffe0004n],
  [0x7fffffffffffffffn, -0xfffen, -0x7ffeffffffffffff0002n],
  [0x8000000000000000n, -0xfffen, -0x7fff0000000000000000n],
  [0x8000000000000001n, -0xfffen, -0x7fff000000000000fffen],
  [0xfffffffffffffffen, -0xfffen, -0xfffdfffffffffffe0004n],
  [0xffffffffffffffffn, -0xfffen, -0xfffdffffffffffff0002n],
  [0x10000000000000000n, -0xfffen, -0xfffe0000000000000000n],
  [0x10000000000000001n, -0xfffen, -0xfffe000000000000fffen],
  [-0x10000000000000001n, 0x7ffffffen, -0x7ffffffe000000007ffffffen],
  [-0x10000000000000000n, 0x7ffffffen, -0x7ffffffe0000000000000000n],
  [-0xffffffffffffffffn, 0x7ffffffen, -0x7ffffffdffffffff80000002n],
  [-0xfffffffffffffffen, 0x7ffffffen, -0x7ffffffdffffffff00000004n],
  [-0x8000000000000001n, 0x7ffffffen, -0x3fffffff000000007ffffffen],
  [-0x8000000000000000n, 0x7ffffffen, -0x3fffffff0000000000000000n],
  [-0x7fffffffffffffffn, 0x7ffffffen, -0x3ffffffeffffffff80000002n],
  [-0x7ffffffffffffffen, 0x7ffffffen, -0x3ffffffeffffffff00000004n],
  [-0x100000001n, 0x7ffffffen, -0x7ffffffe7ffffffen],
  [-0x100000000n, 0x7ffffffen, -0x7ffffffe00000000n],
  [-0xffffffffn, 0x7ffffffen, -0x7ffffffd80000002n],
  [-0xfffffffen, 0x7ffffffen, -0x7ffffffd00000004n],
  [-0x80000001n, 0x7ffffffen, -0x3fffffff7ffffffen],
  [-0x80000000n, 0x7ffffffen, -0x3fffffff00000000n],
  [-0x7fffffffn, 0x7ffffffen, -0x3ffffffe80000002n],
  [-0x7ffffffen, 0x7ffffffen, -0x3ffffffe00000004n],
  [0x7ffffffen, 0x7ffffffen, 0x3ffffffe00000004n],
  [0x7fffffffn, 0x7ffffffen, 0x3ffffffe80000002n],
  [0x80000000n, 0x7ffffffen, 0x3fffffff00000000n],
  [0x80000001n, 0x7ffffffen, 0x3fffffff7ffffffen],
  [0xfffffffen, 0x7ffffffen, 0x7ffffffd00000004n],
  [0xffffffffn, 0x7ffffffen, 0x7ffffffd80000002n],
  [0x100000000n, 0x7ffffffen, 0x7ffffffe00000000n],
  [0x100000001n, 0x7ffffffen, 0x7ffffffe7ffffffen],
  [0x7ffffffffffffffen, 0x7ffffffen, 0x3ffffffeffffffff00000004n],
  [0x7fffffffffffffffn, 0x7ffffffen, 0x3ffffffeffffffff80000002n],
  [0x8000000000000000n, 0x7ffffffen, 0x3fffffff0000000000000000n],
  [0x8000000000000001n, 0x7ffffffen, 0x3fffffff000000007ffffffen],
  [0xfffffffffffffffen, 0x7ffffffen, 0x7ffffffdffffffff00000004n],
  [0xffffffffffffffffn, 0x7ffffffen, 0x7ffffffdffffffff80000002n],
  [0x10000000000000000n, 0x7ffffffen, 0x7ffffffe0000000000000000n],
  [0x10000000000000001n, 0x7ffffffen, 0x7ffffffe000000007ffffffen],
  [-0x10000000000000001n, 0x7fffffffn, -0x7fffffff000000007fffffffn],
  [-0x10000000000000000n, 0x7fffffffn, -0x7fffffff0000000000000000n],
  [-0xffffffffffffffffn, 0x7fffffffn, -0x7ffffffeffffffff80000001n],
  [-0xfffffffffffffffen, 0x7fffffffn, -0x7ffffffeffffffff00000002n],
  [-0x8000000000000001n, 0x7fffffffn, -0x3fffffff800000007fffffffn],
  [-0x8000000000000000n, 0x7fffffffn, -0x3fffffff8000000000000000n],
  [-0x7fffffffffffffffn, 0x7fffffffn, -0x3fffffff7fffffff80000001n],
  [-0x7ffffffffffffffen, 0x7fffffffn, -0x3fffffff7fffffff00000002n],
  [-0x100000001n, 0x7fffffffn, -0x7fffffff7fffffffn],
  [-0x100000000n, 0x7fffffffn, -0x7fffffff00000000n],
  [-0xffffffffn, 0x7fffffffn, -0x7ffffffe80000001n],
  [-0xfffffffen, 0x7fffffffn, -0x7ffffffe00000002n],
  [-0x80000001n, 0x7fffffffn, -0x3fffffffffffffffn],
  [-0x80000000n, 0x7fffffffn, -0x3fffffff80000000n],
  [-0x7fffffffn, 0x7fffffffn, -0x3fffffff00000001n],
  [-0x7ffffffen, 0x7fffffffn, -0x3ffffffe80000002n],
  [0x7fffffffn, 0x7fffffffn, 0x3fffffff00000001n],
  [0x80000000n, 0x7fffffffn, 0x3fffffff80000000n],
  [0x80000001n, 0x7fffffffn, 0x3fffffffffffffffn],
  [0xfffffffen, 0x7fffffffn, 0x7ffffffe00000002n],
  [0xffffffffn, 0x7fffffffn, 0x7ffffffe80000001n],
  [0x100000000n, 0x7fffffffn, 0x7fffffff00000000n],
  [0x100000001n, 0x7fffffffn, 0x7fffffff7fffffffn],
  [0x7ffffffffffffffen, 0x7fffffffn, 0x3fffffff7fffffff00000002n],
  [0x7fffffffffffffffn, 0x7fffffffn, 0x3fffffff7fffffff80000001n],
  [0x8000000000000000n, 0x7fffffffn, 0x3fffffff8000000000000000n],
  [0x8000000000000001n, 0x7fffffffn, 0x3fffffff800000007fffffffn],
  [0xfffffffffffffffen, 0x7fffffffn, 0x7ffffffeffffffff00000002n],
  [0xffffffffffffffffn, 0x7fffffffn, 0x7ffffffeffffffff80000001n],
  [0x10000000000000000n, 0x7fffffffn, 0x7fffffff0000000000000000n],
  [0x10000000000000001n, 0x7fffffffn, 0x7fffffff000000007fffffffn],
  [-0x10000000000000001n, 0x80000000n, -0x800000000000000080000000n],
  [-0x10000000000000000n, 0x80000000n, -0x800000000000000000000000n],
  [-0xffffffffffffffffn, 0x80000000n, -0x7fffffffffffffff80000000n],
  [-0xfffffffffffffffen, 0x80000000n, -0x7fffffffffffffff00000000n],
  [-0x8000000000000001n, 0x80000000n, -0x400000000000000080000000n],
  [-0x8000000000000000n, 0x80000000n, -0x400000000000000000000000n],
  [-0x7fffffffffffffffn, 0x80000000n, -0x3fffffffffffffff80000000n],
  [-0x7ffffffffffffffen, 0x80000000n, -0x3fffffffffffffff00000000n],
  [-0x100000001n, 0x80000000n, -0x8000000080000000n],
  [-0x100000000n, 0x80000000n, -0x8000000000000000n],
  [-0xffffffffn, 0x80000000n, -0x7fffffff80000000n],
  [-0xfffffffen, 0x80000000n, -0x7fffffff00000000n],
  [-0x80000001n, 0x80000000n, -0x4000000080000000n],
  [-0x80000000n, 0x80000000n, -0x4000000000000000n],
  [-0x7fffffffn, 0x80000000n, -0x3fffffff80000000n],
  [-0x7ffffffen, 0x80000000n, -0x3fffffff00000000n],
  [0x80000000n, 0x80000000n, 0x4000000000000000n],
  [0x80000001n, 0x80000000n, 0x4000000080000000n],
  [0xfffffffen, 0x80000000n, 0x7fffffff00000000n],
  [0xffffffffn, 0x80000000n, 0x7fffffff80000000n],
  [0x100000000n, 0x80000000n, 0x8000000000000000n],
  [0x100000001n, 0x80000000n, 0x8000000080000000n],
  [0x7ffffffffffffffen, 0x80000000n, 0x3fffffffffffffff00000000n],
  [0x7fffffffffffffffn, 0x80000000n, 0x3fffffffffffffff80000000n],
  [0x8000000000000000n, 0x80000000n, 0x400000000000000000000000n],
  [0x8000000000000001n, 0x80000000n, 0x400000000000000080000000n],
  [0xfffffffffffffffen, 0x80000000n, 0x7fffffffffffffff00000000n],
  [0xffffffffffffffffn, 0x80000000n, 0x7fffffffffffffff80000000n],
  [0x10000000000000000n, 0x80000000n, 0x800000000000000000000000n],
  [0x10000000000000001n, 0x80000000n, 0x800000000000000080000000n],
  [-0x10000000000000001n, 0x80000001n, -0x800000010000000080000001n],
  [-0x10000000000000000n, 0x80000001n, -0x800000010000000000000000n],
  [-0xffffffffffffffffn, 0x80000001n, -0x80000000ffffffff7fffffffn],
  [-0xfffffffffffffffen, 0x80000001n, -0x80000000fffffffefffffffen],
  [-0x8000000000000001n, 0x80000001n, -0x400000008000000080000001n],
  [-0x8000000000000000n, 0x80000001n, -0x400000008000000000000000n],
  [-0x7fffffffffffffffn, 0x80000001n, -0x400000007fffffff7fffffffn],
  [-0x7ffffffffffffffen, 0x80000001n, -0x400000007ffffffefffffffen],
  [-0x100000001n, 0x80000001n, -0x8000000180000001n],
  [-0x100000000n, 0x80000001n, -0x8000000100000000n],
  [-0xffffffffn, 0x80000001n, -0x800000007fffffffn],
  [-0xfffffffen, 0x80000001n, -0x7ffffffffffffffen],
  [-0x80000001n, 0x80000001n, -0x4000000100000001n],
  [-0x80000000n, 0x80000001n, -0x4000000080000000n],
  [-0x7fffffffn, 0x80000001n, -0x3fffffffffffffffn],
  [-0x7ffffffen, 0x80000001n, -0x3fffffff7ffffffen],
  [0x80000001n, 0x80000001n, 0x4000000100000001n],
  [0xfffffffen, 0x80000001n, 0x7ffffffffffffffen],
  [0xffffffffn, 0x80000001n, 0x800000007fffffffn],
  [0x100000000n, 0x80000001n, 0x8000000100000000n],
  [0x100000001n, 0x80000001n, 0x8000000180000001n],
  [0x7ffffffffffffffen, 0x80000001n, 0x400000007ffffffefffffffen],
  [0x7fffffffffffffffn, 0x80000001n, 0x400000007fffffff7fffffffn],
  [0x8000000000000000n, 0x80000001n, 0x400000008000000000000000n],
  [0x8000000000000001n, 0x80000001n, 0x400000008000000080000001n],
  [0xfffffffffffffffen, 0x80000001n, 0x80000000fffffffefffffffen],
  [0xffffffffffffffffn, 0x80000001n, 0x80000000ffffffff7fffffffn],
  [0x10000000000000000n, 0x80000001n, 0x800000010000000000000000n],
  [0x10000000000000001n, 0x80000001n, 0x800000010000000080000001n],
  [-0x10000000000000001n, -0x80000001n, 0x800000010000000080000001n],
  [-0x10000000000000000n, -0x80000001n, 0x800000010000000000000000n],
  [-0xffffffffffffffffn, -0x80000001n, 0x80000000ffffffff7fffffffn],
  [-0xfffffffffffffffen, -0x80000001n, 0x80000000fffffffefffffffen],
  [-0x8000000000000001n, -0x80000001n, 0x400000008000000080000001n],
  [-0x8000000000000000n, -0x80000001n, 0x400000008000000000000000n],
  [-0x7fffffffffffffffn, -0x80000001n, 0x400000007fffffff7fffffffn],
  [-0x7ffffffffffffffen, -0x80000001n, 0x400000007ffffffefffffffen],
  [-0x100000001n, -0x80000001n, 0x8000000180000001n],
  [-0x100000000n, -0x80000001n, 0x8000000100000000n],
  [-0xffffffffn, -0x80000001n, 0x800000007fffffffn],
  [-0xfffffffen, -0x80000001n, 0x7ffffffffffffffen],
  [-0x80000001n, -0x80000001n, 0x4000000100000001n],
  [-0x80000000n, -0x80000001n, 0x4000000080000000n],
  [-0x7fffffffn, -0x80000001n, 0x3fffffffffffffffn],
  [-0x7ffffffen, -0x80000001n, 0x3fffffff7ffffffen],
  [0xfffffffen, -0x80000001n, -0x7ffffffffffffffen],
  [0xffffffffn, -0x80000001n, -0x800000007fffffffn],
  [0x100000000n, -0x80000001n, -0x8000000100000000n],
  [0x100000001n, -0x80000001n, -0x8000000180000001n],
  [0x7ffffffffffffffen, -0x80000001n, -0x400000007ffffffefffffffen],
  [0x7fffffffffffffffn, -0x80000001n, -0x400000007fffffff7fffffffn],
  [0x8000000000000000n, -0x80000001n, -0x400000008000000000000000n],
  [0x8000000000000001n, -0x80000001n, -0x400000008000000080000001n],
  [0xfffffffffffffffen, -0x80000001n, -0x80000000fffffffefffffffen],
  [0xffffffffffffffffn, -0x80000001n, -0x80000000ffffffff7fffffffn],
  [0x10000000000000000n, -0x80000001n, -0x800000010000000000000000n],
  [0x10000000000000001n, -0x80000001n, -0x800000010000000080000001n],
  [-0x10000000000000001n, -0x80000000n, 0x800000000000000080000000n],
  [-0x10000000000000000n, -0x80000000n, 0x800000000000000000000000n],
  [-0xffffffffffffffffn, -0x80000000n, 0x7fffffffffffffff80000000n],
  [-0xfffffffffffffffen, -0x80000000n, 0x7fffffffffffffff00000000n],
  [-0x8000000000000001n, -0x80000000n, 0x400000000000000080000000n],
  [-0x8000000000000000n, -0x80000000n, 0x400000000000000000000000n],
  [-0x7fffffffffffffffn, -0x80000000n, 0x3fffffffffffffff80000000n],
  [-0x7ffffffffffffffen, -0x80000000n, 0x3fffffffffffffff00000000n],
  [-0x100000001n, -0x80000000n, 0x8000000080000000n],
  [-0x100000000n, -0x80000000n, 0x8000000000000000n],
  [-0xffffffffn, -0x80000000n, 0x7fffffff80000000n],
  [-0xfffffffen, -0x80000000n, 0x7fffffff00000000n],
  [-0x80000000n, -0x80000000n, 0x4000000000000000n],
  [-0x7fffffffn, -0x80000000n, 0x3fffffff80000000n],
  [-0x7ffffffen, -0x80000000n, 0x3fffffff00000000n],
  [0xfffffffen, -0x80000000n, -0x7fffffff00000000n],
  [0xffffffffn, -0x80000000n, -0x7fffffff80000000n],
  [0x100000000n, -0x80000000n, -0x8000000000000000n],
  [0x100000001n, -0x80000000n, -0x8000000080000000n],
  [0x7ffffffffffffffen, -0x80000000n, -0x3fffffffffffffff00000000n],
  [0x7fffffffffffffffn, -0x80000000n, -0x3fffffffffffffff80000000n],
  [0x8000000000000000n, -0x80000000n, -0x400000000000000000000000n],
  [0x8000000000000001n, -0x80000000n, -0x400000000000000080000000n],
  [0xfffffffffffffffen, -0x80000000n, -0x7fffffffffffffff00000000n],
  [0xffffffffffffffffn, -0x80000000n, -0x7fffffffffffffff80000000n],
  [0x10000000000000000n, -0x80000000n, -0x800000000000000000000000n],
  [0x10000000000000001n, -0x80000000n, -0x800000000000000080000000n],
  [-0x10000000000000001n, -0x7fffffffn, 0x7fffffff000000007fffffffn],
  [-0x10000000000000000n, -0x7fffffffn, 0x7fffffff0000000000000000n],
  [-0xffffffffffffffffn, -0x7fffffffn, 0x7ffffffeffffffff80000001n],
  [-0xfffffffffffffffen, -0x7fffffffn, 0x7ffffffeffffffff00000002n],
  [-0x8000000000000001n, -0x7fffffffn, 0x3fffffff800000007fffffffn],
  [-0x8000000000000000n, -0x7fffffffn, 0x3fffffff8000000000000000n],
  [-0x7fffffffffffffffn, -0x7fffffffn, 0x3fffffff7fffffff80000001n],
  [-0x7ffffffffffffffen, -0x7fffffffn, 0x3fffffff7fffffff00000002n],
  [-0x100000001n, -0x7fffffffn, 0x7fffffff7fffffffn],
  [-0x100000000n, -0x7fffffffn, 0x7fffffff00000000n],
  [-0xffffffffn, -0x7fffffffn, 0x7ffffffe80000001n],
  [-0xfffffffen, -0x7fffffffn, 0x7ffffffe00000002n],
  [-0x7fffffffn, -0x7fffffffn, 0x3fffffff00000001n],
  [-0x7ffffffen, -0x7fffffffn, 0x3ffffffe80000002n],
  [0xfffffffen, -0x7fffffffn, -0x7ffffffe00000002n],
  [0xffffffffn, -0x7fffffffn, -0x7ffffffe80000001n],
  [0x100000000n, -0x7fffffffn, -0x7fffffff00000000n],
  [0x100000001n, -0x7fffffffn, -0x7fffffff7fffffffn],
  [0x7ffffffffffffffen, -0x7fffffffn, -0x3fffffff7fffffff00000002n],
  [0x7fffffffffffffffn, -0x7fffffffn, -0x3fffffff7fffffff80000001n],
  [0x8000000000000000n, -0x7fffffffn, -0x3fffffff8000000000000000n],
  [0x8000000000000001n, -0x7fffffffn, -0x3fffffff800000007fffffffn],
  [0xfffffffffffffffen, -0x7fffffffn, -0x7ffffffeffffffff00000002n],
  [0xffffffffffffffffn, -0x7fffffffn, -0x7ffffffeffffffff80000001n],
  [0x10000000000000000n, -0x7fffffffn, -0x7fffffff0000000000000000n],
  [0x10000000000000001n, -0x7fffffffn, -0x7fffffff000000007fffffffn],
  [-0x10000000000000001n, -0x7ffffffen, 0x7ffffffe000000007ffffffen],
  [-0x10000000000000000n, -0x7ffffffen, 0x7ffffffe0000000000000000n],
  [-0xffffffffffffffffn, -0x7ffffffen, 0x7ffffffdffffffff80000002n],
  [-0xfffffffffffffffen, -0x7ffffffen, 0x7ffffffdffffffff00000004n],
  [-0x8000000000000001n, -0x7ffffffen, 0x3fffffff000000007ffffffen],
  [-0x8000000000000000n, -0x7ffffffen, 0x3fffffff0000000000000000n],
  [-0x7fffffffffffffffn, -0x7ffffffen, 0x3ffffffeffffffff80000002n],
  [-0x7ffffffffffffffen, -0x7ffffffen, 0x3ffffffeffffffff00000004n],
  [-0x100000001n, -0x7ffffffen, 0x7ffffffe7ffffffen],
  [-0x100000000n, -0x7ffffffen, 0x7ffffffe00000000n],
  [-0xffffffffn, -0x7ffffffen, 0x7ffffffd80000002n],
  [-0xfffffffen, -0x7ffffffen, 0x7ffffffd00000004n],
  [-0x7ffffffen, -0x7ffffffen, 0x3ffffffe00000004n],
  [0xfffffffen, -0x7ffffffen, -0x7ffffffd00000004n],
  [0xffffffffn, -0x7ffffffen, -0x7ffffffd80000002n],
  [0x100000000n, -0x7ffffffen, -0x7ffffffe00000000n],
  [0x100000001n, -0x7ffffffen, -0x7ffffffe7ffffffen],
  [0x7ffffffffffffffen, -0x7ffffffen, -0x3ffffffeffffffff00000004n],
  [0x7fffffffffffffffn, -0x7ffffffen, -0x3ffffffeffffffff80000002n],
  [0x8000000000000000n, -0x7ffffffen, -0x3fffffff0000000000000000n],
  [0x8000000000000001n, -0x7ffffffen, -0x3fffffff000000007ffffffen],
  [0xfffffffffffffffen, -0x7ffffffen, -0x7ffffffdffffffff00000004n],
  [0xffffffffffffffffn, -0x7ffffffen, -0x7ffffffdffffffff80000002n],
  [0x10000000000000000n, -0x7ffffffen, -0x7ffffffe0000000000000000n],
  [0x10000000000000001n, -0x7ffffffen, -0x7ffffffe000000007ffffffen],
  [-0x10000000000000001n, 0xfffffffen, -0xfffffffe00000000fffffffen],
  [-0x10000000000000000n, 0xfffffffen, -0xfffffffe0000000000000000n],
  [-0xffffffffffffffffn, 0xfffffffen, -0xfffffffdffffffff00000002n],
  [-0xfffffffffffffffen, 0xfffffffen, -0xfffffffdfffffffe00000004n],
  [-0x8000000000000001n, 0xfffffffen, -0x7fffffff00000000fffffffen],
  [-0x8000000000000000n, 0xfffffffen, -0x7fffffff0000000000000000n],
  [-0x7fffffffffffffffn, 0xfffffffen, -0x7ffffffeffffffff00000002n],
  [-0x7ffffffffffffffen, 0xfffffffen, -0x7ffffffefffffffe00000004n],
  [-0x100000001n, 0xfffffffen, -0xfffffffefffffffen],
  [-0x100000000n, 0xfffffffen, -0xfffffffe00000000n],
  [-0xffffffffn, 0xfffffffen, -0xfffffffd00000002n],
  [-0xfffffffen, 0xfffffffen, -0xfffffffc00000004n],
  [0xfffffffen, 0xfffffffen, 0xfffffffc00000004n],
  [0xffffffffn, 0xfffffffen, 0xfffffffd00000002n],
  [0x100000000n, 0xfffffffen, 0xfffffffe00000000n],
  [0x100000001n, 0xfffffffen, 0xfffffffefffffffen],
  [0x7ffffffffffffffen, 0xfffffffen, 0x7ffffffefffffffe00000004n],
  [0x7fffffffffffffffn, 0xfffffffen, 0x7ffffffeffffffff00000002n],
  [0x8000000000000000n, 0xfffffffen, 0x7fffffff0000000000000000n],
  [0x8000000000000001n, 0xfffffffen, 0x7fffffff00000000fffffffen],
  [0xfffffffffffffffen, 0xfffffffen, 0xfffffffdfffffffe00000004n],
  [0xffffffffffffffffn, 0xfffffffen, 0xfffffffdffffffff00000002n],
  [0x10000000000000000n, 0xfffffffen, 0xfffffffe0000000000000000n],
  [0x10000000000000001n, 0xfffffffen, 0xfffffffe00000000fffffffen],
  [-0x10000000000000001n, 0xffffffffn, -0xffffffff00000000ffffffffn],
  [-0x10000000000000000n, 0xffffffffn, -0xffffffff0000000000000000n],
  [-0xffffffffffffffffn, 0xffffffffn, -0xfffffffeffffffff00000001n],
  [-0xfffffffffffffffen, 0xffffffffn, -0xfffffffefffffffe00000002n],
  [-0x8000000000000001n, 0xffffffffn, -0x7fffffff80000000ffffffffn],
  [-0x8000000000000000n, 0xffffffffn, -0x7fffffff8000000000000000n],
  [-0x7fffffffffffffffn, 0xffffffffn, -0x7fffffff7fffffff00000001n],
  [-0x7ffffffffffffffen, 0xffffffffn, -0x7fffffff7ffffffe00000002n],
  [-0x100000001n, 0xffffffffn, -0xffffffffffffffffn],
  [-0x100000000n, 0xffffffffn, -0xffffffff00000000n],
  [-0xffffffffn, 0xffffffffn, -0xfffffffe00000001n],
  [-0xfffffffen, 0xffffffffn, -0xfffffffd00000002n],
  [0xffffffffn, 0xffffffffn, 0xfffffffe00000001n],
  [0x100000000n, 0xffffffffn, 0xffffffff00000000n],
  [0x100000001n, 0xffffffffn, 0xffffffffffffffffn],
  [0x7ffffffffffffffen, 0xffffffffn, 0x7fffffff7ffffffe00000002n],
  [0x7fffffffffffffffn, 0xffffffffn, 0x7fffffff7fffffff00000001n],
  [0x8000000000000000n, 0xffffffffn, 0x7fffffff8000000000000000n],
  [0x8000000000000001n, 0xffffffffn, 0x7fffffff80000000ffffffffn],
  [0xfffffffffffffffen, 0xffffffffn, 0xfffffffefffffffe00000002n],
  [0xffffffffffffffffn, 0xffffffffn, 0xfffffffeffffffff00000001n],
  [0x10000000000000000n, 0xffffffffn, 0xffffffff0000000000000000n],
  [0x10000000000000001n, 0xffffffffn, 0xffffffff00000000ffffffffn],
  [-0x10000000000000001n, 0x100000000n, -0x1000000000000000100000000n],
  [-0x10000000000000000n, 0x100000000n, -0x1000000000000000000000000n],
  [-0xffffffffffffffffn, 0x100000000n, -0xffffffffffffffff00000000n],
  [-0xfffffffffffffffen, 0x100000000n, -0xfffffffffffffffe00000000n],
  [-0x8000000000000001n, 0x100000000n, -0x800000000000000100000000n],
  [-0x8000000000000000n, 0x100000000n, -0x800000000000000000000000n],
  [-0x7fffffffffffffffn, 0x100000000n, -0x7fffffffffffffff00000000n],
  [-0x7ffffffffffffffen, 0x100000000n, -0x7ffffffffffffffe00000000n],
  [-0x100000001n, 0x100000000n, -0x10000000100000000n],
  [-0x100000000n, 0x100000000n, -0x10000000000000000n],
  [-0xffffffffn, 0x100000000n, -0xffffffff00000000n],
  [-0xfffffffen, 0x100000000n, -0xfffffffe00000000n],
  [0x100000000n, 0x100000000n, 0x10000000000000000n],
  [0x100000001n, 0x100000000n, 0x10000000100000000n],
  [0x7ffffffffffffffen, 0x100000000n, 0x7ffffffffffffffe00000000n],
  [0x7fffffffffffffffn, 0x100000000n, 0x7fffffffffffffff00000000n],
  [0x8000000000000000n, 0x100000000n, 0x800000000000000000000000n],
  [0x8000000000000001n, 0x100000000n, 0x800000000000000100000000n],
  [0xfffffffffffffffen, 0x100000000n, 0xfffffffffffffffe00000000n],
  [0xffffffffffffffffn, 0x100000000n, 0xffffffffffffffff00000000n],
  [0x10000000000000000n, 0x100000000n, 0x1000000000000000000000000n],
  [0x10000000000000001n, 0x100000000n, 0x1000000000000000100000000n],
  [-0x10000000000000001n, 0x100000001n, -0x1000000010000000100000001n],
  [-0x10000000000000000n, 0x100000001n, -0x1000000010000000000000000n],
  [-0xffffffffffffffffn, 0x100000001n, -0x100000000fffffffeffffffffn],
  [-0xfffffffffffffffen, 0x100000001n, -0x100000000fffffffdfffffffen],
  [-0x8000000000000001n, 0x100000001n, -0x800000008000000100000001n],
  [-0x8000000000000000n, 0x100000001n, -0x800000008000000000000000n],
  [-0x7fffffffffffffffn, 0x100000001n, -0x800000007ffffffeffffffffn],
  [-0x7ffffffffffffffen, 0x100000001n, -0x800000007ffffffdfffffffen],
  [-0x100000001n, 0x100000001n, -0x10000000200000001n],
  [-0x100000000n, 0x100000001n, -0x10000000100000000n],
  [-0xffffffffn, 0x100000001n, -0xffffffffffffffffn],
  [-0xfffffffen, 0x100000001n, -0xfffffffefffffffen],
  [0x100000001n, 0x100000001n, 0x10000000200000001n],
  [0x7ffffffffffffffen, 0x100000001n, 0x800000007ffffffdfffffffen],
  [0x7fffffffffffffffn, 0x100000001n, 0x800000007ffffffeffffffffn],
  [0x8000000000000000n, 0x100000001n, 0x800000008000000000000000n],
  [0x8000000000000001n, 0x100000001n, 0x800000008000000100000001n],
  [0xfffffffffffffffen, 0x100000001n, 0x100000000fffffffdfffffffen],
  [0xffffffffffffffffn, 0x100000001n, 0x100000000fffffffeffffffffn],
  [0x10000000000000000n, 0x100000001n, 0x1000000010000000000000000n],
  [0x10000000000000001n, 0x100000001n, 0x1000000010000000100000001n],
  [-0x10000000000000001n, -0x100000001n, 0x1000000010000000100000001n],
  [-0x10000000000000000n, -0x100000001n, 0x1000000010000000000000000n],
  [-0xffffffffffffffffn, -0x100000001n, 0x100000000fffffffeffffffffn],
  [-0xfffffffffffffffen, -0x100000001n, 0x100000000fffffffdfffffffen],
  [-0x8000000000000001n, -0x100000001n, 0x800000008000000100000001n],
  [-0x8000000000000000n, -0x100000001n, 0x800000008000000000000000n],
  [-0x7fffffffffffffffn, -0x100000001n, 0x800000007ffffffeffffffffn],
  [-0x7ffffffffffffffen, -0x100000001n, 0x800000007ffffffdfffffffen],
  [-0x100000001n, -0x100000001n, 0x10000000200000001n],
  [-0x100000000n, -0x100000001n, 0x10000000100000000n],
  [-0xffffffffn, -0x100000001n, 0xffffffffffffffffn],
  [-0xfffffffen, -0x100000001n, 0xfffffffefffffffen],
  [0x7ffffffffffffffen, -0x100000001n, -0x800000007ffffffdfffffffen],
  [0x7fffffffffffffffn, -0x100000001n, -0x800000007ffffffeffffffffn],
  [0x8000000000000000n, -0x100000001n, -0x800000008000000000000000n],
  [0x8000000000000001n, -0x100000001n, -0x800000008000000100000001n],
  [0xfffffffffffffffen, -0x100000001n, -0x100000000fffffffdfffffffen],
  [0xffffffffffffffffn, -0x100000001n, -0x100000000fffffffeffffffffn],
  [0x10000000000000000n, -0x100000001n, -0x1000000010000000000000000n],
  [0x10000000000000001n, -0x100000001n, -0x1000000010000000100000001n],
  [-0x10000000000000001n, -0x100000000n, 0x1000000000000000100000000n],
  [-0x10000000000000000n, -0x100000000n, 0x1000000000000000000000000n],
  [-0xffffffffffffffffn, -0x100000000n, 0xffffffffffffffff00000000n],
  [-0xfffffffffffffffen, -0x100000000n, 0xfffffffffffffffe00000000n],
  [-0x8000000000000001n, -0x100000000n, 0x800000000000000100000000n],
  [-0x8000000000000000n, -0x100000000n, 0x800000000000000000000000n],
  [-0x7fffffffffffffffn, -0x100000000n, 0x7fffffffffffffff00000000n],
  [-0x7ffffffffffffffen, -0x100000000n, 0x7ffffffffffffffe00000000n],
  [-0x100000000n, -0x100000000n, 0x10000000000000000n],
  [-0xffffffffn, -0x100000000n, 0xffffffff00000000n],
  [-0xfffffffen, -0x100000000n, 0xfffffffe00000000n],
  [0x7ffffffffffffffen, -0x100000000n, -0x7ffffffffffffffe00000000n],
  [0x7fffffffffffffffn, -0x100000000n, -0x7fffffffffffffff00000000n],
  [0x8000000000000000n, -0x100000000n, -0x800000000000000000000000n],
  [0x8000000000000001n, -0x100000000n, -0x800000000000000100000000n],
  [0xfffffffffffffffen, -0x100000000n, -0xfffffffffffffffe00000000n],
  [0xffffffffffffffffn, -0x100000000n, -0xffffffffffffffff00000000n],
  [0x10000000000000000n, -0x100000000n, -0x1000000000000000000000000n],
  [0x10000000000000001n, -0x100000000n, -0x1000000000000000100000000n],
  [-0x10000000000000001n, -0xffffffffn, 0xffffffff00000000ffffffffn],
  [-0x10000000000000000n, -0xffffffffn, 0xffffffff0000000000000000n],
  [-0xffffffffffffffffn, -0xffffffffn, 0xfffffffeffffffff00000001n],
  [-0xfffffffffffffffen, -0xffffffffn, 0xfffffffefffffffe00000002n],
  [-0x8000000000000001n, -0xffffffffn, 0x7fffffff80000000ffffffffn],
  [-0x8000000000000000n, -0xffffffffn, 0x7fffffff8000000000000000n],
  [-0x7fffffffffffffffn, -0xffffffffn, 0x7fffffff7fffffff00000001n],
  [-0x7ffffffffffffffen, -0xffffffffn, 0x7fffffff7ffffffe00000002n],
  [-0xffffffffn, -0xffffffffn, 0xfffffffe00000001n],
  [-0xfffffffen, -0xffffffffn, 0xfffffffd00000002n],
  [0x7ffffffffffffffen, -0xffffffffn, -0x7fffffff7ffffffe00000002n],
  [0x7fffffffffffffffn, -0xffffffffn, -0x7fffffff7fffffff00000001n],
  [0x8000000000000000n, -0xffffffffn, -0x7fffffff8000000000000000n],
  [0x8000000000000001n, -0xffffffffn, -0x7fffffff80000000ffffffffn],
  [0xfffffffffffffffen, -0xffffffffn, -0xfffffffefffffffe00000002n],
  [0xffffffffffffffffn, -0xffffffffn, -0xfffffffeffffffff00000001n],
  [0x10000000000000000n, -0xffffffffn, -0xffffffff0000000000000000n],
  [0x10000000000000001n, -0xffffffffn, -0xffffffff00000000ffffffffn],
  [-0x10000000000000001n, -0xfffffffen, 0xfffffffe00000000fffffffen],
  [-0x10000000000000000n, -0xfffffffen, 0xfffffffe0000000000000000n],
  [-0xffffffffffffffffn, -0xfffffffen, 0xfffffffdffffffff00000002n],
  [-0xfffffffffffffffen, -0xfffffffen, 0xfffffffdfffffffe00000004n],
  [-0x8000000000000001n, -0xfffffffen, 0x7fffffff00000000fffffffen],
  [-0x8000000000000000n, -0xfffffffen, 0x7fffffff0000000000000000n],
  [-0x7fffffffffffffffn, -0xfffffffen, 0x7ffffffeffffffff00000002n],
  [-0x7ffffffffffffffen, -0xfffffffen, 0x7ffffffefffffffe00000004n],
  [-0xfffffffen, -0xfffffffen, 0xfffffffc00000004n],
  [0x7ffffffffffffffen, -0xfffffffen, -0x7ffffffefffffffe00000004n],
  [0x7fffffffffffffffn, -0xfffffffen, -0x7ffffffeffffffff00000002n],
  [0x8000000000000000n, -0xfffffffen, -0x7fffffff0000000000000000n],
  [0x8000000000000001n, -0xfffffffen, -0x7fffffff00000000fffffffen],
  [0xfffffffffffffffen, -0xfffffffen, -0xfffffffdfffffffe00000004n],
  [0xffffffffffffffffn, -0xfffffffen, -0xfffffffdffffffff00000002n],
  [0x10000000000000000n, -0xfffffffen, -0xfffffffe0000000000000000n],
  [0x10000000000000001n, -0xfffffffen, -0xfffffffe00000000fffffffen],
  [-0x10000000000000001n, 0x7ffffffffffffffen, -0x7ffffffffffffffe7ffffffffffffffen],
  [-0x10000000000000000n, 0x7ffffffffffffffen, -0x7ffffffffffffffe0000000000000000n],
  [-0xffffffffffffffffn, 0x7ffffffffffffffen, -0x7ffffffffffffffd8000000000000002n],
  [-0xfffffffffffffffen, 0x7ffffffffffffffen, -0x7ffffffffffffffd0000000000000004n],
  [-0x8000000000000001n, 0x7ffffffffffffffen, -0x3fffffffffffffff7ffffffffffffffen],
  [-0x8000000000000000n, 0x7ffffffffffffffen, -0x3fffffffffffffff0000000000000000n],
  [-0x7fffffffffffffffn, 0x7ffffffffffffffen, -0x3ffffffffffffffe8000000000000002n],
  [-0x7ffffffffffffffen, 0x7ffffffffffffffen, -0x3ffffffffffffffe0000000000000004n],
  [0x7ffffffffffffffen, 0x7ffffffffffffffen, 0x3ffffffffffffffe0000000000000004n],
  [0x7fffffffffffffffn, 0x7ffffffffffffffen, 0x3ffffffffffffffe8000000000000002n],
  [0x8000000000000000n, 0x7ffffffffffffffen, 0x3fffffffffffffff0000000000000000n],
  [0x8000000000000001n, 0x7ffffffffffffffen, 0x3fffffffffffffff7ffffffffffffffen],
  [0xfffffffffffffffen, 0x7ffffffffffffffen, 0x7ffffffffffffffd0000000000000004n],
  [0xffffffffffffffffn, 0x7ffffffffffffffen, 0x7ffffffffffffffd8000000000000002n],
  [0x10000000000000000n, 0x7ffffffffffffffen, 0x7ffffffffffffffe0000000000000000n],
  [0x10000000000000001n, 0x7ffffffffffffffen, 0x7ffffffffffffffe7ffffffffffffffen],
  [-0x10000000000000001n, 0x7fffffffffffffffn, -0x7fffffffffffffff7fffffffffffffffn],
  [-0x10000000000000000n, 0x7fffffffffffffffn, -0x7fffffffffffffff0000000000000000n],
  [-0xffffffffffffffffn, 0x7fffffffffffffffn, -0x7ffffffffffffffe8000000000000001n],
  [-0xfffffffffffffffen, 0x7fffffffffffffffn, -0x7ffffffffffffffe0000000000000002n],
  [-0x8000000000000001n, 0x7fffffffffffffffn, -0x3fffffffffffffffffffffffffffffffn],
  [-0x8000000000000000n, 0x7fffffffffffffffn, -0x3fffffffffffffff8000000000000000n],
  [-0x7fffffffffffffffn, 0x7fffffffffffffffn, -0x3fffffffffffffff0000000000000001n],
  [-0x7ffffffffffffffen, 0x7fffffffffffffffn, -0x3ffffffffffffffe8000000000000002n],
  [0x7fffffffffffffffn, 0x7fffffffffffffffn, 0x3fffffffffffffff0000000000000001n],
  [0x8000000000000000n, 0x7fffffffffffffffn, 0x3fffffffffffffff8000000000000000n],
  [0x8000000000000001n, 0x7fffffffffffffffn, 0x3fffffffffffffffffffffffffffffffn],
  [0xfffffffffffffffen, 0x7fffffffffffffffn, 0x7ffffffffffffffe0000000000000002n],
  [0xffffffffffffffffn, 0x7fffffffffffffffn, 0x7ffffffffffffffe8000000000000001n],
  [0x10000000000000000n, 0x7fffffffffffffffn, 0x7fffffffffffffff0000000000000000n],
  [0x10000000000000001n, 0x7fffffffffffffffn, 0x7fffffffffffffff7fffffffffffffffn],
  [-0x10000000000000001n, 0x8000000000000000n, -0x80000000000000008000000000000000n],
  [-0x10000000000000000n, 0x8000000000000000n, -0x80000000000000000000000000000000n],
  [-0xffffffffffffffffn, 0x8000000000000000n, -0x7fffffffffffffff8000000000000000n],
  [-0xfffffffffffffffen, 0x8000000000000000n, -0x7fffffffffffffff0000000000000000n],
  [-0x8000000000000001n, 0x8000000000000000n, -0x40000000000000008000000000000000n],
  [-0x8000000000000000n, 0x8000000000000000n, -0x40000000000000000000000000000000n],
  [-0x7fffffffffffffffn, 0x8000000000000000n, -0x3fffffffffffffff8000000000000000n],
  [-0x7ffffffffffffffen, 0x8000000000000000n, -0x3fffffffffffffff0000000000000000n],
  [0x8000000000000000n, 0x8000000000000000n, 0x40000000000000000000000000000000n],
  [0x8000000000000001n, 0x8000000000000000n, 0x40000000000000008000000000000000n],
  [0xfffffffffffffffen, 0x8000000000000000n, 0x7fffffffffffffff0000000000000000n],
  [0xffffffffffffffffn, 0x8000000000000000n, 0x7fffffffffffffff8000000000000000n],
  [0x10000000000000000n, 0x8000000000000000n, 0x80000000000000000000000000000000n],
  [0x10000000000000001n, 0x8000000000000000n, 0x80000000000000008000000000000000n],
  [-0x10000000000000001n, 0x8000000000000001n, -0x80000000000000018000000000000001n],
  [-0x10000000000000000n, 0x8000000000000001n, -0x80000000000000010000000000000000n],
  [-0xffffffffffffffffn, 0x8000000000000001n, -0x80000000000000007fffffffffffffffn],
  [-0xfffffffffffffffen, 0x8000000000000001n, -0x7ffffffffffffffffffffffffffffffen],
  [-0x8000000000000001n, 0x8000000000000001n, -0x40000000000000010000000000000001n],
  [-0x8000000000000000n, 0x8000000000000001n, -0x40000000000000008000000000000000n],
  [-0x7fffffffffffffffn, 0x8000000000000001n, -0x3fffffffffffffffffffffffffffffffn],
  [-0x7ffffffffffffffen, 0x8000000000000001n, -0x3fffffffffffffff7ffffffffffffffen],
  [0x8000000000000001n, 0x8000000000000001n, 0x40000000000000010000000000000001n],
  [0xfffffffffffffffen, 0x8000000000000001n, 0x7ffffffffffffffffffffffffffffffen],
  [0xffffffffffffffffn, 0x8000000000000001n, 0x80000000000000007fffffffffffffffn],
  [0x10000000000000000n, 0x8000000000000001n, 0x80000000000000010000000000000000n],
  [0x10000000000000001n, 0x8000000000000001n, 0x80000000000000018000000000000001n],
  [-0x10000000000000001n, -0x8000000000000001n, 0x80000000000000018000000000000001n],
  [-0x10000000000000000n, -0x8000000000000001n, 0x80000000000000010000000000000000n],
  [-0xffffffffffffffffn, -0x8000000000000001n, 0x80000000000000007fffffffffffffffn],
  [-0xfffffffffffffffen, -0x8000000000000001n, 0x7ffffffffffffffffffffffffffffffen],
  [-0x8000000000000001n, -0x8000000000000001n, 0x40000000000000010000000000000001n],
  [-0x8000000000000000n, -0x8000000000000001n, 0x40000000000000008000000000000000n],
  [-0x7fffffffffffffffn, -0x8000000000000001n, 0x3fffffffffffffffffffffffffffffffn],
  [-0x7ffffffffffffffen, -0x8000000000000001n, 0x3fffffffffffffff7ffffffffffffffen],
  [0xfffffffffffffffen, -0x8000000000000001n, -0x7ffffffffffffffffffffffffffffffen],
  [0xffffffffffffffffn, -0x8000000000000001n, -0x80000000000000007fffffffffffffffn],
  [0x10000000000000000n, -0x8000000000000001n, -0x80000000000000010000000000000000n],
  [0x10000000000000001n, -0x8000000000000001n, -0x80000000000000018000000000000001n],
  [-0x10000000000000001n, -0x8000000000000000n, 0x80000000000000008000000000000000n],
  [-0x10000000000000000n, -0x8000000000000000n, 0x80000000000000000000000000000000n],
  [-0xffffffffffffffffn, -0x8000000000000000n, 0x7fffffffffffffff8000000000000000n],
  [-0xfffffffffffffffen, -0x8000000000000000n, 0x7fffffffffffffff0000000000000000n],
  [-0x8000000000000000n, -0x8000000000000000n, 0x40000000000000000000000000000000n],
  [-0x7fffffffffffffffn, -0x8000000000000000n, 0x3fffffffffffffff8000000000000000n],
  [-0x7ffffffffffffffen, -0x8000000000000000n, 0x3fffffffffffffff0000000000000000n],
  [0xfffffffffffffffen, -0x8000000000000000n, -0x7fffffffffffffff0000000000000000n],
  [0xffffffffffffffffn, -0x8000000000000000n, -0x7fffffffffffffff8000000000000000n],
  [0x10000000000000000n, -0x8000000000000000n, -0x80000000000000000000000000000000n],
  [0x10000000000000001n, -0x8000000000000000n, -0x80000000000000008000000000000000n],
  [-0x10000000000000001n, -0x7fffffffffffffffn, 0x7fffffffffffffff7fffffffffffffffn],
  [-0x10000000000000000n, -0x7fffffffffffffffn, 0x7fffffffffffffff0000000000000000n],
  [-0xffffffffffffffffn, -0x7fffffffffffffffn, 0x7ffffffffffffffe8000000000000001n],
  [-0xfffffffffffffffen, -0x7fffffffffffffffn, 0x7ffffffffffffffe0000000000000002n],
  [-0x7fffffffffffffffn, -0x7fffffffffffffffn, 0x3fffffffffffffff0000000000000001n],
  [-0x7ffffffffffffffen, -0x7fffffffffffffffn, 0x3ffffffffffffffe8000000000000002n],
  [0xfffffffffffffffen, -0x7fffffffffffffffn, -0x7ffffffffffffffe0000000000000002n],
  [0xffffffffffffffffn, -0x7fffffffffffffffn, -0x7ffffffffffffffe8000000000000001n],
  [0x10000000000000000n, -0x7fffffffffffffffn, -0x7fffffffffffffff0000000000000000n],
  [0x10000000000000001n, -0x7fffffffffffffffn, -0x7fffffffffffffff7fffffffffffffffn],
  [-0x10000000000000001n, -0x7ffffffffffffffen, 0x7ffffffffffffffe7ffffffffffffffen],
  [-0x10000000000000000n, -0x7ffffffffffffffen, 0x7ffffffffffffffe0000000000000000n],
  [-0xffffffffffffffffn, -0x7ffffffffffffffen, 0x7ffffffffffffffd8000000000000002n],
  [-0xfffffffffffffffen, -0x7ffffffffffffffen, 0x7ffffffffffffffd0000000000000004n],
  [-0x7ffffffffffffffen, -0x7ffffffffffffffen, 0x3ffffffffffffffe0000000000000004n],
  [0xfffffffffffffffen, -0x7ffffffffffffffen, -0x7ffffffffffffffd0000000000000004n],
  [0xffffffffffffffffn, -0x7ffffffffffffffen, -0x7ffffffffffffffd8000000000000002n],
  [0x10000000000000000n, -0x7ffffffffffffffen, -0x7ffffffffffffffe0000000000000000n],
  [0x10000000000000001n, -0x7ffffffffffffffen, -0x7ffffffffffffffe7ffffffffffffffen],
  [-0x10000000000000001n, 0xfffffffffffffffen, -0xfffffffffffffffefffffffffffffffen],
  [-0x10000000000000000n, 0xfffffffffffffffen, -0xfffffffffffffffe0000000000000000n],
  [-0xffffffffffffffffn, 0xfffffffffffffffen, -0xfffffffffffffffd0000000000000002n],
  [-0xfffffffffffffffen, 0xfffffffffffffffen, -0xfffffffffffffffc0000000000000004n],
  [0xfffffffffffffffen, 0xfffffffffffffffen, 0xfffffffffffffffc0000000000000004n],
  [0xffffffffffffffffn, 0xfffffffffffffffen, 0xfffffffffffffffd0000000000000002n],
  [0x10000000000000000n, 0xfffffffffffffffen, 0xfffffffffffffffe0000000000000000n],
  [0x10000000000000001n, 0xfffffffffffffffen, 0xfffffffffffffffefffffffffffffffen],
  [-0x10000000000000001n, 0xffffffffffffffffn, -0xffffffffffffffffffffffffffffffffn],
  [-0x10000000000000000n, 0xffffffffffffffffn, -0xffffffffffffffff0000000000000000n],
  [-0xffffffffffffffffn, 0xffffffffffffffffn, -0xfffffffffffffffe0000000000000001n],
  [-0xfffffffffffffffen, 0xffffffffffffffffn, -0xfffffffffffffffd0000000000000002n],
  [0xffffffffffffffffn, 0xffffffffffffffffn, 0xfffffffffffffffe0000000000000001n],
  [0x10000000000000000n, 0xffffffffffffffffn, 0xffffffffffffffff0000000000000000n],
  [0x10000000000000001n, 0xffffffffffffffffn, 0xffffffffffffffffffffffffffffffffn],
  [-0x10000000000000001n, 0x10000000000000000n, -0x100000000000000010000000000000000n],
  [-0x10000000000000000n, 0x10000000000000000n, -0x100000000000000000000000000000000n],
  [-0xffffffffffffffffn, 0x10000000000000000n, -0xffffffffffffffff0000000000000000n],
  [-0xfffffffffffffffen, 0x10000000000000000n, -0xfffffffffffffffe0000000000000000n],
  [0x10000000000000000n, 0x10000000000000000n, 0x100000000000000000000000000000000n],
  [0x10000000000000001n, 0x10000000000000000n, 0x100000000000000010000000000000000n],
  [-0x10000000000000001n, 0x10000000000000001n, -0x100000000000000020000000000000001n],
  [-0x10000000000000000n, 0x10000000000000001n, -0x100000000000000010000000000000000n],
  [-0xffffffffffffffffn, 0x10000000000000001n, -0xffffffffffffffffffffffffffffffffn],
  [-0xfffffffffffffffen, 0x10000000000000001n, -0xfffffffffffffffefffffffffffffffen],
  [0x10000000000000001n, 0x10000000000000001n, 0x100000000000000020000000000000001n],
  [-0x10000000000000001n, -0x10000000000000001n, 0x100000000000000020000000000000001n],
  [-0x10000000000000000n, -0x10000000000000001n, 0x100000000000000010000000000000000n],
  [-0xffffffffffffffffn, -0x10000000000000001n, 0xffffffffffffffffffffffffffffffffn],
  [-0xfffffffffffffffen, -0x10000000000000001n, 0xfffffffffffffffefffffffffffffffen],
  [-0x10000000000000000n, -0x10000000000000000n, 0x100000000000000000000000000000000n],
  [-0xffffffffffffffffn, -0x10000000000000000n, 0xffffffffffffffff0000000000000000n],
  [-0xfffffffffffffffen, -0x10000000000000000n, 0xfffffffffffffffe0000000000000000n],
  [-0xffffffffffffffffn, -0xffffffffffffffffn, 0xfffffffffffffffe0000000000000001n],
  [-0xfffffffffffffffen, -0xffffffffffffffffn, 0xfffffffffffffffd0000000000000002n],
  [-0xfffffffffffffffen, -0xfffffffffffffffen, 0xfffffffffffffffc0000000000000004n],
];

// Cases not covered above.
tests.push(
  // Int32 overflow:
  //
  //   Math.floor(2 ** (Math.log2(2147483648) / 2))
  // = Math.floor(2 ** 15.5)
  // = 46340
  //
  //   Math.ceil(2 ** (Math.log2(2147483648) / 2))
  // = Math.ceil(2 ** 15.5)
  // = 46341
  [46340n, 46340n, 2147395600n],
  [46341n, 46341n, 2147488281n],
  [46340n, -46340n, -2147395600n],
  [46341n, -46341n, -2147488281n],
  [-46340n, -46340n, 2147395600n],
  [-46341n, -46341n, 2147488281n],

  // Int64 overflow
  [3037000499n, 3037000499n, 9223372030926249001n],
  [3037000500n, 3037000500n, 9223372037000250000n],
  [3037000499n, -3037000499n, -9223372030926249001n],
  [3037000500n, -3037000500n, -9223372037000250000n],
  [-3037000499n, -3037000499n, 9223372030926249001n],
  [-3037000500n, -3037000500n, 9223372037000250000n],
);

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];

    assertEq(lhs * rhs, expected);
    assertEq(rhs * lhs, expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
