// generated by ../../../../tools/tube_transfer.py
// tube: 6DJ8
// plate current function: triode
// mu: 28
// kx: 1.3
// kg1: 330
// kg2: 0
// kp: 320
// kvb: 300
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_6DJ8[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	137.512728867083,137.39922326360644,137.2856902513437,137.17212984000545,137.058542039243,
	136.9449268586483,136.8312843077541,136.71761439603364,136.60391713290124,136.49019252771203,
	136.37644058976187,136.2626613282878,136.14885475246754,136.03502087142013,135.92115969420547,
	135.8072712298247,135.6933554872199,135.57941247527458,135.4654422028133,135.351444678602,
	135.2374199113479,135.1233679096995,135.00928868224682,134.8951822375211,134.78104858399522,
	134.6668877300835,134.55269968414177,134.4384844544675,134.3242420492996,134.20997247681888,
	134.09567574514756,133.98135186234975,133.86700083643132,133.75262267533975,133.63821738696453,
	133.5237849791368,133.4093254596298,133.29483883615848,133.1803251163798,133.06578430789278,
	132.95121641823837,132.8366214548995,132.72199942530128,132.6073503368108,132.49267419673737,
	132.3779710123324,132.26324079078944,132.14848353924435,132.03369926477518,131.9188879744022,
	131.80404967508792,131.68918437373736,131.57429207719773,131.45937279225862,131.34442652565198,
	131.22945328405225,131.11445307407627,130.99942590228332,130.88437177517525,130.76929069919626,
	130.65418268073321,130.53904772611537,130.42388584161483,130.308697033446,130.19348130776598,
	130.07823867067472,129.9629691282145,129.8476726863704,129.73234935107024,129.6169991281845,
	129.50162202352635,129.3862180428518,129.27078719185954,129.1553294761911,129.03984490143063,
	128.92433347310538,128.80879519668514,128.6932300775828,128.57763812115383,128.46201933269674,
	128.34637371745293,128.23070128060655,128.11500202728487,127.99927596255796,127.8835230914387,
	127.76774341888324,127.65193694979033,127.53610368900186,127.42024364130275,127.30435681142082,
	127.18844320402681,127.07250282373468,126.95653567510129,126.84054176262646,126.72452109075303,
	126.60847366386704,126.49239948629747,126.37629856231634,126.26017089613877,126.14401649192291,
	126.02783535376999,125.91162748572437,125.79539289177339,125.67913157584755,125.5628435418204,
	125.44652879350862,125.33018733467199,125.2138191690133,125.09742430017853,124.9810027317568,
	124.86455446728023,124.74807951022407,124.63157786400669,124.51504953198966,124.39849451747747,
	124.28191282371787,124.16530445390168,124.04866941116275,123.93200769857819,123.81531931916804,
	123.69860427589556,123.58186257166705,123.46509420933192,123.3482991916827,123.23147752145492,
	123.11462920132738,122.99775423392165,122.88085262180272,122.7639243674784,122.64696947339962,
	122.52998794196043,122.41297977549793,122.29594497629218,122.17888354656638,122.06179548848662,
	121.94468080416218,121.82753949564523,121.71037156493091,121.59317701395757,121.47595584460629,
	121.3587080587013,121.24143365800971,121.1241326442416,121.00680501905003,120.88945078403094,
	120.77206994072321,120.65466249060867,120.53722843511201,120.4197677756008,120.30228051338554,
	120.18476664971948,120.06722618579882,119.94965912276251,119.83206546169237,119.71444520361301,
	119.5967983494918,119.47912490023892,119.36142485670732,119.24369821969258,119.12594498993316,
	119.00816516811008,118.89035875484716,118.77252575071077,118.6546661562101,118.53677997179679,
	118.41886719786527,118.30092783475243,118.1829618827378,118.06496934204344,117.94695021283403,
	117.82890449521663,117.71083218924089,117.59273329489899,117.4746078121254,117.35645574079713,
	117.23827708073365,117.12007183169676,117.00183999339056,116.88358156546157,116.76529654749868,
	116.64698493903293,116.52864673953783,116.41028194842903,116.2918905650643,116.17347258874385,
	116.05502801870982,115.93655685414667,115.81805909418094,115.6995347378813,115.58098378425835,
	115.46240623226497,115.34380208079585,115.22517132868768,115.10651397471939,114.98783001761146,
	114.86911945602654,114.75038228856904,114.63161851378538,114.51282813016356,114.3940111361336,
	114.27516753006716,114.15629731027764,114.03740047502022,113.91847702249167,113.7995269508305,
	113.68055025811677,113.56154694237206,113.44251700155966,113.3234604335843,113.20437723629217,
	113.08526740747094,112.96613094484974,112.84696784609903,112.7277781088307,112.60856173059794,
	112.4893187088952,112.37004904115821,112.25075272476401,112.13142975703069,112.01208013521757,
	111.89270385652515,111.77330091809489,111.6538713170095,111.5344150502925,111.41493211490851,
	111.29542250776308,111.17588622570274,111.05632326551476,110.93673362392737,110.81711729760957,
	110.6974742831711,110.57780457716252,110.45810817607504,110.33838507634054,110.21863527433142,
	110.09885876636085,109.97905554868245,109.85922561749035,109.7393689689192,109.61948559904401,
	109.49957550388032,109.3796386793839,109.25967512145091,109.13968482591781,109.01966778856126,
	108.89962400509813,108.77955347118554,108.65945618242066,108.53933213434075,108.41918132242321,
	108.29900374208538,108.17879938868454,108.05856825751805,107.938310343823,107.81802564277648,
	107.69771414949527,107.57737585903608,107.45701076639523,107.33661886650886,107.21620015425255,
	107.09575462444177,106.97528227183142,106.85478309111592,106.73425707692937,106.6137042238451,
	106.49312452637602,106.37251797897441,106.25188457603177,106.13122431187908,106.01053718078646,
	105.88982317696328,105.76908229455809,105.64831452765863,105.52751987029173,105.40669831642326,
	105.28584985995815,105.16497449474022,105.04407221455241,104.92314301311643,104.80218688409288,
	104.68120382108128,104.56019381761982,104.43915686718553,104.31809296319413,104.19700209900002,
	104.07588426789616,103.95473946311427,103.83356767782446,103.71236890513548,103.59114313809455,
	103.46989036968728,103.34861059283777,103.22730380040844,103.10596998520002,102.9846091399517,
	102.86322125734065,102.74180632998255,102.62036435043113,102.49889531117832,102.37739920465413,
	102.2558760232267,102.13432575920223,102.01274840482488,101.8911439522768,101.76951239367817,
	101.647853721087,101.52616792649927,101.4044550018487,101.28271493900692,101.16094772978332,
	101.039153365925,100.91733183911687,100.79548314098146,100.67360726307902,100.55170419690738,
	100.42977393390203,100.307816465436,100.18583178281988,100.06381987730181,99.94178074006737,
	99.81971436223961,99.69762073487908,99.57549984898374,99.45335169548886,99.33117626526716,
	99.2089735491287,99.08674353782084,98.96448622202821,98.84220159237277,98.71988963941371,
	98.5975503536475,98.47518372550776,98.35278974536537,98.23036840352837,98.10791969024197,
	97.98544359568848,97.86294010998746,97.74040922319547,97.61785092530627,97.49526520625062,
	97.37265205589651,97.25001146404884,97.12734342044963,97.00464791477802,96.88192493665012,
	96.75917447561906,96.63639652117512,96.51359106274548,96.39075808969442,96.26789759132323,
	96.1450095568702,96.0220939755107,95.89915083635701,95.77618012845856,95.65318184080178,
	95.53015596231005,95.40710248184389,95.28402138820083,95.16091267011541,95.03777631625935,
	94.91461231524137,94.79142065560725,94.66820132583997,94.54495431435957,94.42167960952322,
	94.29837719962534,94.17504707289741,94.0516892175082,93.92830362156363,93.80489027310696,
	93.68144916011869,93.55798027051661,93.43448359215586,93.31095911282898,93.18740682026592,
	93.06382670213401,92.94021874603817,92.8165829395207,92.69291927006162,92.56922772507846,
	92.44550829192643,92.32176095789846,92.19798571022525,92.0741825360753,91.95035142255497,
	91.8264923567085,91.70260532551816,91.57869031590431,91.45474731472537,91.3307763087779,
	91.20677728479681,91.08275022945524,90.9586951293648,90.83461197107547,90.7105007410759,
	90.58636142579331,90.46219401159367,90.33799848478169,90.21377483160117,90.0895230382347,
	89.96524309080407,89.84093497537025,89.71659867793348,89.59223418443351,89.46784148074948,
	89.34342055270025,89.21897138604437,89.09449396648031,88.96998827964651,88.84545431112157,
	88.72089204642428,88.59630147101382,88.47168257028994,88.34703532959307,88.22235973420437,
	88.09765576934603,87.97292342018139,87.84816267181499,87.72337350929284,87.59855591760255,
	87.47370988167353,87.34883538637715,87.22393241652686,87.09900095687841,86.97404099213018,
	86.84905250692313,86.72403548584114,86.59898991341122,86.47391577410366,86.34881305233233,
	86.22368173245472,86.0985217987724,85.97333323553109,85.84811602692092,85.72287015707676,
	85.59759561007823,85.47229236995031,85.34696042066324,85.22159974613305,85.09621033022167,
	84.97079215673726,84.8453452094345,84.71986947201488,84.59436492812691,84.46883156136653,
	84.34326935527741,84.21767829335121,84.09205835902787,83.96640953569606,83.84073180669337,
	83.71502515530676,83.5892895647729,83.46352501827845,83.33773149896052,83.21190898990696,
	83.08605747415679,82.96017693470056,82.83426735448079,82.70832871639232,82.58236100328277,
	82.45636419795295,82.3303382831572,82.20428324160403,82.07819905595638,81.95208570883214,
	81.82594318280461,81.69977146040311,81.57357052411317,81.44734035637732,81.32108093959545,
	81.19479225612534,81.06847428828328,80.94212701834435,80.81575042854338,80.6893445010751,
	80.56290921809497,80.43644456171967,80.30995051402768,80.18342705705994,80.0568741728204,
	79.93029184327673,79.80368005036088,79.67703877596982,79.55036800196609,79.42366771017859,
	79.29693788240323,79.17017850040361,79.04338954591185,78.91657100062922,78.78972284622681,
	78.66284506434651,78.5359376366017,78.40900054457789,78.2820337698338,78.15503729390194,
	78.02801109828965,77.90095516447981,77.77386947393173,77.64675400808211,77.51960874834596,
	77.3924336761174,77.26522877277074,77.1379940196613,77.01072939812654,76.88343488948694,
	76.75611047504711,76.62875613609664,76.50137185391151,76.3739576097547,76.24651338487776,
	76.11903916052145,75.99153491791735,75.86400063828863,75.73643630285146,75.60884189281614,
	75.48121738938832,75.35356277377025,75.22587802716205,75.0981631307631,74.97041806577307,
	74.84264281339377,74.71483735482998,74.5870016712912,74.45913574399295,74.33123955415819,
	74.20331308301897,74.07535631181764,73.94736922180867,73.81935179426011,73.69130401045507,
	73.5632258516935,73.43511729929378,73.30697833459443,73.17880893895583,73.05060909376184,
	72.92237878042171,72.79411798037202,72.66582667507822,72.53750484603674,72.40915247477685,
	72.28076954286259,72.15235603189481,72.02391192351321,71.89543719939829,71.76693184127366,
	71.63839583090804,71.50982915011748,71.38123178076755,71.25260370477582,71.12394490411391,
	70.99525536081003,70.86653505695129,70.73778397468621,70.60900209622723,70.4801894038532,
	70.35134587991205,70.22247150682337,70.0935662670812,69.96463014325661,69.83566311800078,
	69.7066651740475,69.57763629421645,69.44857646141597,69.31948565864604,69.1903638690015,
	69.06121107567515,68.93202726196091,68.80281241125718,68.67356650707013,68.54428953301706,
	68.41498147282991,68.28564231035885,68.15627202957576,68.026870614578,67.89743804959214,
	67.76797431897776,67.63847940723144,67.5089532989905,67.37939597903743,67.24980743230365,
	67.120187643874,66.9905365989909,66.86085428305879,66.73114068164864,66.60139578050247,
	66.47161956553803,66.34181202285355,66.2119731387327,66.0821028996493,65.95220129227265,
	65.82226830347253,65.69230392032456,65.56230813011544,65.43228092034859,65.30222227874961,
	65.17213219327215,65.04201065210363,64.9118576436712,64.78167315664788,64.6514571799588,
	64.52120970278737,64.39093071458198,64.2606202050625,64.13027816422698,63.99990458235868,
	63.869499450033025,63.73906275812481,63.608594497815645,63.47809466060133,63.34756323829962,
	63.217000223058044,63.086405607361975,62.955779384042714,62.8251215462859,62.694432087640145,
	62.56371100202571,62.4329582837434,62.30217392748382,62.171357928336576,62.040510281799996,
	61.90963098379078,61.778720030654,61.64777741917335,61.51680314658157,61.385797210571205,
	61.254759609305424,61.123690341429295,60.99258940608121,60.86145680290455,60.73029253205979,
	60.599096594236585,60.467868990666496,60.33660972313575,60.20531879399839,60.073996206189754,
	59.94264196324028,59.81125606928967,59.6798385291012,59.548389348076654,59.416908532271464,
	59.28539608841023,59.153852023902616,59.0222763468597,58.89066906611064,58.75903019121981,
	58.62735973250438,58.49565770105222,58.36392410874038,58.23215896825398,58.10036229310565,
	57.968534097655215,57.836674397130274,57.7047832076469,57.57286054623123,57.44090643084139,
	57.308920880389884,57.176903914766996,57.04485555486435,56.912775822599244,56.780664740939784,
	56.648522333930416,56.51634862671828,56.384143645580316,56.25190741795094,56.119639972450564,
	55.98734133891493,55.85501154842508,55.72265063333826,55.590258627319685,55.45783556537507,
	55.32538148388409,55.19289642063488,55.060380414859274,54.927833507269234,54.795255740094156,
	54.66264715711928,54.53000780372514,54.39733772692821,54.26463697542257,54.13190559962292,
	53.99914365170863,53.86635118566924,53.733528257351175,53.60067492450576,53.4677912468387,
	53.334877286061015,53.20193310594142,53.068958772360205,52.93595435336473,52.80291991922661,
	52.669855542500564,52.53676129808489,52.4036372632839,52.270483517872194,52.13730014416074,
	52.004087227065185,51.870844854175864,51.73757311583033,51.604272105187746,51.470941918305826,
	51.3375826542199,51.20419441502454,51.07077730595761,50.93733143548707,50.80385691540018,
	50.67035386089577,50.53682239067921,50.403262627060386,50.269674696054736,50.136058727487466,
	50.00241485510106,49.86874321666612,49.735043954095836,49.6013172135639,49.46756314562635,
	49.33378190534722,49.19997365242816,49.06613855134228,48.932276771472296,48.79838848725301,
	48.66447387831859,48.53053312965431,48.39656643175358,48.26257398077965,48.128555978733,
	47.994512633623835,47.860444159650385,47.72635077738305,47.592232713954516,47.45809020325601,
	47.32392348614034,47.18973281063117,47.055518432139685,46.92128061368788,46.78701962613978,
	46.65273574843982,46.518429267859545,46.38410048025226,46.249749690316165,46.11537721186633,
	45.980983368115716,45.84656849196552,45.712132926305216,45.57767702432268,45.443201149824624,
	45.3087056775678,45.17419099360118,45.03965749561979,44.905105593330184,44.77053570882831,
	44.63594827699001,44.50134374587456,44.3667225771418,44.23208524648327,44.09743224406769,
	43.96276407500144,43.82808125980452,43.69338433490235,43.55867385313404,43.423950384277745,
	43.28921451559346,43.154466852384,43.019708018574754,42.88493865731249,42.75015943158445,
	42.61537102485775,42.48057414173998,42.345769508661824,42.210957874582135,42.0761400117162,
	41.94131671628815,41.80648880930779,41.671657137373096,41.53682257349872,41.401986017971645,
	41.2671483992343,41.132310674796514,40.997473832176624,40.86263888987283,40.72780689836563,
	40.59297894115194,40.45815613581217,40.323339635110706,40.18853062813089,40.053730341445366,
	39.91894004032264,39.78416102997069,39.64939465681852,39.51464230983726,39.37990542189811,
	39.2451854711762,39.110483982590736,38.97580252929003,38.84114273417886,38.70650627149007,
	38.57189486840039,38.43731030669196,38.30275442445981,38.168229117865955,38.03373634294105,
	37.89927811743365,37.76485652270802,37.63047370569062,37.49613188086572,37.361833332320394,
	37.22758041583905,37.093375561047374,36.95922127360596,36.82512013745314,36.691074817096776,
	36.5570880599546,36.42316269874233,36.289301653908765,36.15550793611709,36.0217846487706,
	35.88813499058206,35.75456225818453,35.621069848781964,35.487661262837186,35.354340106794915,
	35.22111009583689,35.08797505666587,34.954938930315265,34.82200577498006,34.68917976886532,
	34.55646521304702,34.42386653434036,34.29138828817003,34.159035161435966,34.02681197536846,
	33.894723688365204,33.76277539880255,33.63097234781321,33.49931992202084,33.367823656222846,
	33.236489236010826,33.105322500318245,32.974329443883875,32.8435162196193,32.71288914086737,
	32.58245468353885,32.452219488113,32.32219036148754,32.19237427866283,32.06277838424431,
	31.9334099937468,31.804276594683564,31.675385847422692,31.546745585792426,31.418363817417223,
	31.290248723765597,31.162408659890247,31.03485215384146,30.907587905733713,30.780624786446133,
	30.653971835937178,30.52763826115375,30.401633433516118,30.275966885959466,30.150648309514214,
	30.02568754940755,29.90109460066977,29.776879603229798,29.653052836486122,29.52962471333972,
	29.40660577367855,29.284006677303807,29.161838196290976,29.040111206780253,28.918836680193987,
	28.79802567388077,28.677689321188996,28.55783882097528,28.438485426556554,28.319640434117634,
	28.201315170589464,28.08352098101669,27.966269215436768,27.849571215296194,27.7334382994334,
	27.617881749660967,27.50291279598357,27.388542601491626,27.274782246973743,27.161642715294203,
	27.049134875584834,26.93726946730347,26.82605708421322,26.71550815833962,26.60563294396382,
	26.49644150171219,26.387943682803364,26.2801491135143,26.17306717992774,26.066707013022658,
	25.961077474168718,25.856187141085204,25.752044294322143,25.648656904320564,25.54603261910531,
	25.444178752661436,25.343102274041684,25.242809797248885,25.14330757193307,25.04460147493858,
	24.946697002732215,24.849599264738004,24.753312977599936,24.65784246038825,24.56319163076,
	24.46936400207925,24.376362681497262,24.284190368987744,24.192849357327425,24.102341533007124,
	24.012668378054393,23.923830972743975,23.835829999168524,23.748665745638206,23.66233811187444,
	23.576846614959916,23.49219039600441,23.40836822748338,23.32537852120485,23.243219336858033,
	23.16188839109631,23.0813830671062,23.00170042461371,22.922837210279077,22.844789868431445,
	22.76755455209535,22.691127134261723,22.615503219357343,22.540678154867777,22.466647043070562,
	22.3934047528369,22.32094593146214,22.249265016487264,22.17835624747567,22.10821367771166,
	22.038831185789512,21.970202487064014,21.902321144935758,21.835180581946798,21.768774090664504,
	21.703094844333684,21.638135907279313,21.57389024504408,21.510350734247517,21.44751017215484,
	21.385361285946026,21.323896741677206,21.263109152928212,21.20299108913169,21.143535083580776,
	21.08473364111373,21.026579245474927,20.969064366353415,20.91218146610068,20.855923006130656,
	20.800281453005844,20.745249284214122,20.69081899364161,20.636983096747702,20.583734135448594,
	20.531064682716558,20.47896734690235,20.42743477578837,20.37645966038094,20.32603473844965,
	20.276152797822412,20.226806679444824,20.17798928021222,20.129693555583344,20.08191252198418,
	20.034639259010493,19.98786691143772,19.941588691046558,19.89579787827267,19.850487823688525,
	19.805651949325597,19.761283749844484,19.717376793560824,19.673924723334338,19.630921257328236,
	19.588360189646018,19.546235390852445,19.50454080838523,19.463270466863857,19.422418468301526,
	19.38197899222614,19.341946295716056,19.302314713355877,19.263078657117592,19.22423261617198,
	19.185771156635056,19.147688921254076,19.109980629037423,19.072641074832593,19.035665128856046,
	18.999047736178838,18.962783916171436,18.926868761911205,18.891297439555647,18.85606518768451,
	18.82116731661361,18.78659920767479,18.75235631251527,18.718434152288943,18.684828316919567,
	18.65153446430108,18.61854831949344,18.585865673906074,18.553482384470957,18.521394372806625,
	18.489597624375108,18.45808818763288,18.426862173177422,18.395915752890563,18.36524515907986,
	18.334846683619006,18.30471667708849,18.274851547917223,18.24524776152627,18.21590183947528,
	18.186810358612508,18.157969950229173,18.129377299218568,18.101029143240794,18.072922271893457,
	18.04505352588897,18.01741979623871,17.9900180234447,17.962845196698982,17.93589835309109,
	17.909174576823943,17.882670998438385,17.85638479404664,17.83031318457486,17.804453435014963,
	17.778802853685963,17.75335879150487,17.728118641267223,17.703079836937547,17.67823985294957,
	17.653596203516383,17.629146441950635,17.604888159994616,17.58081898716044,17.556936590080163,
	17.533238671865927,17.509722971480034,17.486387263115002,17.463229355583444,17.44024709171786,
	17.417438347780127,17.39480103288072,17.372333088407583,17.35003248746455,17.327897234319202,
	17.30592536386013,17.284114941063468,17.26246406046861,17.240970845662996,17.219633448775884,
	17.198450049980973,17.177418857007794,17.156538104661756,17.135806054352663,17.115220993631702,
	17.094781235736683,17.074485119145482,17.054331007137513,17.034317287363145,17.014442371420927,
	16.994704694442547,16.97510271468527,16.955634913131945,16.936299793098247,16.91709587984721,
	16.89802172021078,16.8790758822184,16.860256954732424,16.841563547090285,16.822994288753264,
	16.804547828961812,16.78622283639721,16.76801799884957,16.749932022891944,16.731963633560554,
	16.71411157404092,16.69637460535988,16.67875150608329,16.66124107201943,16.643842115927807,
	16.626553467233563,16.60937397174707,16.59230249138876,16.57533790391915,16.558479102673832,
	16.541724996294974,16.525074508510905,16.50852657783187,16.492080157341217,16.475734214444604,
	16.459487730633228,16.443339701251485,16.42728913526889,16.411335055056274,16.39547649616608,
	16.379712507116757,16.364042149181145,16.348464496178714,16.332978634271708,16.317583661764996,
	16.302278688909592,16.287062837709886,16.27193524173427,16.256895045929365,16.24194140643757,
	16.227073490417993,16.21229047587064,16.19759155146377,16.182975916364512,16.16844278007241,
	16.1539913622561,16.139620892592934,16.125330610611456,16.1111197655368,16.096987616138804,
	16.08293343058293,16.068956486283824,16.055056069761534,16.041231476500258,16.027482010809695,
	16.01380698568882,16.000205722692108,15.986677551798113,15.973221811280464,15.959837847581042,
	15.946525015185484,15.933282676500868,15.920110201735536,15.907006968781054,15.893972363096262,
	15.881005777593305,15.868106612525734,15.85527427537852,15.842508180759967,15.829807750295561,
	15.817172412523632,15.804601602792845,15.792094763161419,15.779651342298143,15.767270795385098,
	15.754952584021996,15.742696176132215,15.73050104587043,15.718366673531817,15.706292545462823,
	15.69427815397343,15.682322997250944,15.670426579275196,15.658588409735245,15.646808003947442,
	15.635084882774871,15.623418572548186,15.611808604987722,15.600254517126967,15.588755851237277,
	15.577312154753837,15.565922980202894,15.554587885130177,15.543306432030485,15.53207818827847,
	15.520902726060541,15.509779622307908,15.498708458630702,15.487688821253176,15.476720300950015,
	15.465802492983608,15.45493499704241,15.444117417180225,15.433349361756592,15.422630443378027,
	15.411960278840247,15.40133848907134,15.39076469907585,15.380238537879734,15.369759638476207,
	15.359327637772461,15.348942176537246,15.338602899349219,15.328309454546208,15.318061494175202,
	15.307858673943157,15.29770065316858,15.287587094733878,15.277517665038435,15.267492033952436,
	15.257509874771404,15.24757086417147,15.237674682165286,15.227821012058678,15.218009540407945,
	15.208239956977796,15.198511954699983,15.18882522963251,15.179179480919524,15.169574410751771,
	15.160009724327713,15.150485129815165,15.141000338313567,15.13155506381683,15.122149023176677,
	15.112781936066641,15.103453524946525,15.094163515027423,15.084911634228815,15.07569761317923,
	15.066521185129583,15.057382085956679,15.048280054121374,15.039214830636645,15.030186159036068,
	15.021193785342778,15.012237458038934,15.003316928035545,14.994431948642827,14.98558227554094,
	14.976767666751153,14.967987882607446,14.959242685728514,14.950531840990216,14.941855115498333,
	14.933212278561806,14.924603101666321,14.916027358448275,14.907484824669117,14.898975278190083,
	14.890498498947208,14.88205426892681,14.873642372141243,14.865262594604992,14.85691472431116,
	14.84859855120824,14.840313867177233,14.832060466009061,14.823838143382366,14.815646696841505,
	14.807485925774989,14.799355631394102,14.791255616711876,14.783185686522362,14.775145647380175,
	14.767135307580297,14.759154477138189,14.751202967770181,14.743280592874118,14.735387167510243,
	14.727522508382403,14.719686433819447,14.711878763756928,14.704099319719022,14.696347924800696,
	14.688624403650115,14.680928582451333,14.673260288907112,14.665619352222084,14.658005603086085,
	14.650418873657681,14.642858997547991,14.635325809804659,14.62781914689607,14.620338846695741,
	14.612884748467009,14.605456692847788,14.598054521835632,14.590678078772928,14.583327208332355,
	14.576001756502457,14.56870157057343,14.56142649912314,14.554176392003223,14.546951100325503,
	14.539750476448438,14.532574373963838,14.52542264768374,14.518295153627413,14.511191749008592,
	14.504112292222775,14.497056642834826,14.490024661566581,14.483016210284728,14.476031151988817,
	14.469069350799327,14.462130671946058,14.455214981756496,14.448322147644436,14.441452038098697,
	14.434604522672014,14.427779471970023,14.42097675764042,14.414196252362242,14.407437829835287,
	14.400701364769667,14.393986732875451,14.387293810852519,14.380622476380452,14.373972608108588,
	14.367344085646222,14.360736789552886,14.354150601328765,14.34758540340521,14.341041079135431,
	14.334517512785201,14.328014589523766,14.321532195414814,14.31507021740757,14.30862854332798,
	14.302207061870051,14.29580566258722,14.289424235883878,14.283062673007,14.276720866037842,
	14.270398707883745,14.264096092270075,14.257812913732185,14.251549067607556,14.245304450027952,
	14.239078957911746,14.232872488956255,14.226684941630229,14.220516215166398,14.214366209554118,
	14.208234825532081,14.202121964581147,14.196027528917218,14.189951421484233,14.183893545947218,
	14.177853806685416,14.171832108778588,14.165828358028817,14.159842460909827,14.153874324590731,
	14.147923856921715,14.14199096642765,14.136075562301745,14.130177554399319,14.124296853231563,
	14.118433369959497,14.112587016387852,14.106757704959133,14.100945348747691,14.095149861453883,
	14.08937115739829,14.083609151516008,14.077863759350972,14.072134897050416,14.066422481359297,
	14.060726429614858,14.055046659741219,14.04938309024403,14.043735640205186,14.038104229277604,
	14.032488777680054,14.026889206192038,14.021305436148744,14.015737389436037,14.010184988485518,
	14.004648156269631,13.99912681629683,13.99362089260676,13.988130309765571,13.982654992861208,
	13.977194867498765,13.971749859795926,13.96631989637843,13.96090490437557,13.955504811415766,
	13.950119545622176,13.944749035608359,13.939393210473952,13.934051999800452,13.928725333647007,
	13.923413142546226,13.9181153575001,13.912831909975893,13.90756273190215,13.902307755664673,
	13.8970669141026,13.891840140504485,13.886627368604447,13.881428532578333,13.876243567039952,
	13.871072407037301,13.865914988048903,13.860771245980105,13.855641117159465,13.85052453833515,
	13.845421446671391,13.840331779744968,13.835255475541723,13.830192472453106,13.825142709272788,
	13.820106125193254,13.815082659802487,13.810072253080664,13.805074845396842,13.800090377505784,
	13.795118790544679,13.790160026030032,13.785214025854472,13.780280732283675,13.775360087953258,
	13.770452035865755,13.765556519387564,13.760673482246002,13.755802868526327,13.75094462266879,
	13.74609868946576,13.741265014058852,13.736443541936069,13.73163421891928,13.726836991202406,
	13.72205180528367,13.71727860800889,13.712517346556451,13.70776796843466,13.703030421479102,
	13.698304653849991,13.693590614029576,13.688888250819588,13.684197513338653,13.679518351019805,
	13.674850713607977,13.670194551157497,13.665549814029664,13.660916452890325,13.656294418707443,
	13.65168366274874,13.647084136579329,13.642495792059357,13.637918581341733,13.633352456869805,
	13.628797371375086,13.624253277875036,13.6197201296708,13.615197880345024,13.610686483759668,
	13.606185894053825,13.601696065641592,13.597216953209946,13.59274851171663,13.588290696385016,
	13.583843462716711,13.57940676646202,13.574980563642457,13.570564810620375,13.56615946369163,
	13.561764479895807,13.557379816203097,13.553005429912705,13.548641278583123,13.544287320015641,
	13.539943512260129,13.535609813611604,13.531286182608385,13.526972578030255,13.52266895889664,
	13.518375284464849,13.514091514228234,13.509817607914497,13.505553525483883,13.50129922712748,
	13.49705467326551,13.492819824545597,13.488594641841116,13.484379086249499,13.480173119090592,
	13.475976701905012,13.471789796452539,13.467612364710467,13.463444368872041,13.459285771344877,
	13.455136534749364,13.450996621917138,13.446865995889542,13.442744619916072,13.438632457452904,
	13.434529472161353,13.430435627906435,13.426350888755348,13.422275218976024,13.418208583035714,
	13.414150945611365,13.410102271543515,13.40606252589839,13.402031673926265,13.398009681069665,
	13.393996512962,13.389992135426223,13.385996514473424,13.382009616301556,13.378031407294081,
	13.374061854018661,13.37010092322584,13.36614858184778,13.36220479699697,13.358269535964949,
	13.354342766221057,13.35042445541118,13.346514571356527,13.342613082052392,13.338719955666933,
	13.334835160539988,13.330958665181868,13.327090438272151,13.323230448658565,13.31937866535575,
	13.31553505754416,13.311699594568886,13.307872245938544,13.30405298132413,13.300241770557912,
	13.29643858363231,13.292643390698839,13.288856162066956,13.285076868203035,13.28130547972928,
	13.277541967422643,13.273786302213805,13.270038455186109,13.266298397574532,13.262566100764646,
	13.258841536291634,13.255124675839248,13.251415491238802,13.247713954468209,13.244020037650978,
	13.24033371305524,13.236654953092772,13.232983730318043,13.229320017427268,13.225663787257448,
	13.222015012785434,13.218373667127008,13.21473972353596,13.211113155403154,13.207493936255643,
	13.203882039755742,13.20027743970018,13.196680110019162,13.19309002477552,13.189507158163838,
	13.185931484509602,13.182362978268287,13.17880161402457,13.175247366491464,13.171700210509462,
	13.16816012104573,13.164627073193271,13.16110104217012,13.1575820033185,13.15406993210409,
	13.150564804115113,13.147066595061661,13.14357528077484,13.140090837206007,13.136613240425993,
	13.133142466624355,13.129678492108589,13.126221293303402,13.122770846749923,13.119327129105008,
	13.115890117140465,13.112459787742338,13.109036117910184,13.105619084756334,13.102208665505206,
	13.098804837492567,13.095407578164851,13.09201686507845,13.08863267589902,13.085254988400806,
	13.081883780465937,13.078519030083765,13.075160715350192,13.071808814467005,13.068463305741204,
	13.06512416758435,13.061791378511913,13.058464917142649,13.055144762197902,13.051830892494175,
	13.048523286969232,13.045221924642224,13.041926784638676,13.038637846183608,13.035355088600891,
	13.032078491312667,13.02880803383875,13.025543695796,13.022285456897754,13.019033296953214,
	13.015787195866865,13.012547133637925,13.009313090359711,13.006085046219114,13.002862981496015,
	12.999646876562709,12.996436711883366,12.99323246801345,12.99003412559918,12.986841665377005,
	12.983655068172999,12.980474314902397,12.977299386569001,12.974130264264673,12.970966929168796,
	12.967809362547767,12.964657545754454,12.96151146022771,12.958371087491823,12.95523640915603,
	12.95210740691401,12.948984062543376,12.94586635790519,12.94275427494345,12.939647795684607,
	12.936546902237087,12.93345157679079,12.930361801616627,12.92727755906603,12.924198831570491,
	12.921125601641084,12.91805785186799,12.914995564920051,12.911938723544306,12.908887310565527,
	12.905841308885766,12.902800701483908,12.899765471415243,12.896735601810981,12.89371107587784,
	12.890691876897616,12.887677988226718,12.884669393295772,12.881666075609163,12.878668018744623,
	12.87567520635282,12.872687622156906,12.869705249952148,12.86672807360546,12.863756077055049,
	12.860789244309952,12.857827559449689,12.854871006623801,12.851919570051496,12.84897323402125,
	12.84603198289037,12.843095801084665,12.840164673098005,12.837238583491978,12.83431751689547,
	12.831401458004306,12.828490391580877,12.825584302453755,12.822683175517321,12.81978699573139,
	12.816895748120857,12.814009417775335,12.811127989848776,12.80825144955912,12.805379782187936,
	12.802512973080079,12.799651007643307,12.796793871347983,12.79394154972667,12.791094028373825,
	12.788251292945432,12.785413329158693,12.782580122791652,12.779751659682887,12.77692792573116,
	12.77410890689509,12.771294589192847,12.768484958701766,12.765680001558103,12.76287970395664,
	12.760084052150413,12.757293032450354,12.754506631225016,12.751724834900234,12.748947629958815,
	12.74617500294024,12.743406940440332,12.740643429110984,12.737884455659827,12.735130006849944,
	12.732380069499563,12.729634630481769,12.726893676724185,12.72415719520871,12.721425172971202,
	12.718697597101206,12.715974454741659,12.71325573308859,12.710541419390857,12.70783150094986,
	12.705125965119247,12.702424799304664,12.699727990963428,12.69703552760431,12.694347396787238,
	12.691663586122992,12.688984083272999,12.68630887594901,12.683637951912864,12.68097129897622,
	12.678308905000268,12.675650757895513,12.672996845621476,12.670347156186459,12.667701677647274,
	12.665060398109006,12.662423305724747,12.659790388695344,12.657161635269157,12.654537033741805,
	12.651916572455937,12.649300239800944,12.64668802421278,12.644079914173656,12.641475898211848,
	12.638875964901425,12.63628010286204,12.63368830075867,12.631100547301392,12.628516831245157,
	12.625937141389556,12.623361466578581,12.620789795700404,12.618222117687152,12.615658421514667,
	12.613098696202318,12.610542930812734,12.60799111445161,12.60544323626748,12.602899285451496,
	12.600359251237228,12.597823122900413,12.595290889758784,12.592762541171817,12.59023806654055,
	12.587717455307354,12.585200696955733,12.582687781010117,12.580178697035642,12.577673434637958,
	12.57517198346304,12.572674333196936,12.570180473565625,12.567690394334772,12.565204085309555,
	12.562721536334445,12.560242737293045,12.55776767810785,12.555296348740097,12.552828739189524,
	12.550364839494232,12.547904639730447,12.54544813001236,12.542995300491935,12.5405461413587,
	12.53810064283959,12.535658795198751,12.53322058873735,12.530786013793392,12.52835506074156,
	12.525927719992994,12.523503981995171,12.521083837231657,12.518667276221986,12.516254289521457,
	12.513844867720964,12.511439001446819,12.509036681360586,12.506637898158917,12.50424264257335,
	12.501850905370176,12.49946267735024,12.497077949348796,12.494696712235328,12.492318956905443,
	12.489944674312055,12.48757385541881,12.485206491230484,12.48284257278524,12.480482091154524,
	12.47812503744285,12.475771402787675,12.473421178359231,12.471074355360363,12.468730925026387,
	12.466390878624912,12.464054207455714,12.461720902850551,12.45939095617304,12.457064358818483,
	12.454741102213728,12.452421177817014,12.450104577117827,12.447791291636747,12.445481312925303,
	12.443174632565825,12.440871242171287,12.438571133385201,12.436274297881424,12.433980727364036,
	12.431690413567214,12.42940334825506,12.427119523221492,12.424838930290072,12.422561561313877,
	12.42028740817539,12.41801646278632,12.41574871708749,12.413484163048697,12.411222792668571,
	12.408964597974437,12.406709571022208,12.404457703896217,12.402208988709113,12.399963417601699,
	12.397720982742845,12.39548167632931,12.393245490585658,12.391012417764088,12.388782450144337,
	12.386555580033539,12.384331799766109,12.382111101703597,12.379893478234592,12.377678921774573,
	12.375467424765795,12.373258979677178,12.37105357900416,12.368851215268593,12.366651881018624,
	12.364455568828571,12.362262271298789,12.360071981055592,12.357884690751069,12.355700393063046,
	12.353519080694904,12.351340746375495,12.349165382859024,12.346992982924924,12.34482353937775,
	12.342657045047067,12.340493492787326,12.338332875477773,12.336175186022318,12.33402041734942,
	12.331868562412001,12.32971961418732,12.327573565676857,12.325430409906227,12.323290139925046,
	12.321152748806853,12.319018229648965,12.316886575572406,12.314757779721786,12.312631835265202,
	12.310508735394121,12.30838847332329,12.306271042290627,12.304156435557125,12.30204464640673,
	12.29993566814626,12.297829494105299,12.295726117636097,12.293625532113454,12.29152773093465,
	12.28943270751932,12.287340455309371,12.285250967768881,12.283164238383993,12.281080260662824,
	12.278999028135381,12.276920534353446,12.274844772890482,12.272771737341568,12.270701421323254,
	12.268633818473518,12.266568922451635,12.264506726938105,12.262447225634556,12.260390412263648,
	12.258336280568999,12.256284824315056,12.25423603728705,12.25218991329088,12.250146446153023,
	12.24810562972046,12.246067457860573,12.244031924461071,12.241999023429877,12.239968748695086,
	12.237941094204828,12.235916053927214,12.233893621850248,12.23187379198173,12.229856558349171,
	12.22784191499972,12.225829856000079,12.22382037543641,12.221813467414265,12.219809126058482,
	12.217807345513126,12.215808119941402,12.213811443525572,12.211817310466852,12.209825714985381,
	12.207836651320095,12.20585011372866,12.203866096487419,12.201884593891265,12.19990560025361,
	12.197929109906275,12.195955117199434,12.193983616501521,12.192014602199157,12.190048068697077,
	12.188084010418065,12.186122421802843,12.184163297310043,12.182206631416097,12.18025241861518,
	12.17830065341912,12.176351330357344,12.174404443976803,12.172459988841874,12.17051795953431,
	12.16857835065318,12.166641156814753,12.16470637265248,12.162773992816884,12.160844011975492,
	12.158916424812812,12.15699122603018,12.15506841034577,12.153147972494473,12.15122990722786,
	12.149314209314092,12.147400873537855,12.145489894700315,12.143581267619016,12.141674987127846,
	12.139771048076918,12.137869445332573,12.135970173777281,12.134073228309552,12.132178603843911,
	12.130286295310805,12.12839629765655,12.126508605843268,12.124623214848809,12.122740119666712,
	12.120859315306111,12.118980796791703,12.117104559163652,12.11523059747756,12.113358906804377,
	12.111489482230358,12.109622318856992,12.107757411800934,12.105894756193972,12.10403434718293,
	12.102176179929621,12.100320249610812,12.098466551418113,12.096615080557974,12.094765832251584,
	12.09291880173482,12.091073984258216,12.089231375086861,12.087390969500376,12.085552762792839,
	12.083716750272734,12.081882927262885,12.080051289100416,12.078221831136677,12.076394548737193,
	12.074569437281612,12.072746492163649,12.070925708791025,12.069107082585404,12.06729060898237,
	12.065476283431327
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	137.512728867083,137.39922326360644,137.28569025134374,137.1721298400055,137.05854203924304,
	136.9449268586483,136.83128430775406,136.71761439603364,136.60391713290127,136.49019252771203,
	136.37644058976187,136.2626613282878,136.1488547524676,136.03502087142016,135.92115969420547,
	135.8072712298247,135.6933554872199,135.57941247527458,135.4654422028133,135.351444678602,
	135.2374199113479,135.1233679096995,135.00928868224682,134.89518223752108,134.78104858399524,
	134.66688773008352,134.55269968414183,134.4384844544675,134.3242420492996,134.20997247681888,
	134.09567574514756,133.98135186234975,133.86700083643132,133.75262267533978,133.6382173869645,
	133.5237849791368,133.40932545962983,133.29483883615848,133.1803251163798,133.06578430789278,
	132.95121641823837,132.83662145489953,132.72199942530128,132.60735033681084,132.4926741967374,
	132.3779710123324,132.26324079078944,132.14848353924438,132.03369926477515,131.9188879744022,
	131.80404967508795,131.68918437373736,131.57429207719775,131.45937279225865,131.344426525652,
	131.22945328405228,131.1144530740763,130.99942590228332,130.88437177517525,130.76929069919626,
	130.65418268073321,130.53904772611543,130.42388584161483,130.308697033446,130.19348130776606,
	130.07823867067478,129.9629691282145,129.84767268637046,129.73234935107027,129.61699912818455,
	129.50162202352638,129.38621804285185,129.27078719185957,129.15532947619113,129.03984490143068,
	128.92433347310543,128.80879519668522,128.69323007758283,128.57763812115388,128.46201933269677,
	128.34637371745296,128.2307012806066,128.1150020272849,127.99927596255797,127.88352309143878,
	127.76774341888326,127.65193694979037,127.53610368900193,127.4202436413028,127.30435681142087,
	127.18844320402692,127.07250282373481,126.95653567510138,126.84054176262653,126.72452109075314,
	126.60847366386716,126.49239948629757,126.37629856231642,126.26017089613883,126.14401649192301,
	126.02783535377012,125.91162748572447,125.79539289177353,125.67913157584763,125.56284354182051,
	125.44652879350875,125.33018733467206,125.2138191690134,125.09742430017869,124.98100273175697,
	124.86455446728034,124.7480795102242,124.63157786400687,124.51504953198985,124.39849451747763,
	124.28191282371806,124.16530445390187,124.04866941116296,123.93200769857839,123.81531931916828,
	123.6986042758958,123.58186257166727,123.46509420933215,123.34829919168297,123.23147752145519,
	123.11462920132763,122.99775423392192,122.88085262180302,122.76392436747867,122.64696947339995,
	122.52998794196074,122.41297977549827,122.29594497629253,122.17888354656674,122.06179548848701,
	121.94468080416259,121.82753949564562,121.71037156493136,121.59317701395801,121.47595584460677,
	121.35870805870177,121.24143365801022,121.1241326442421,121.00680501905057,120.88945078403147,
	120.77206994072378,120.65466249060927,120.53722843511264,120.4197677756015,120.30228051338624,
	120.1847666497202,120.06722618579957,119.9496591227633,119.83206546169319,119.71444520361382,
	119.59679834949267,119.47912490023984,119.36142485670824,119.24369821969356,119.12594498993417,
	119.00816516811115,118.89035875484825,118.7725257507119,118.65466615621126,118.53677997179803,
	118.41886719786656,118.30092783475372,118.18296188273919,118.06496934204489,117.9469502128355,
	117.8289044952182,117.71083218924251,117.59273329490063,117.4746078121271,117.35645574079896,
	117.23827708073556,117.1200718316987,117.00183999339255,116.88358156546369,116.76529654750088,
	116.64698493903526,116.52864673954024,116.4102819484315,116.2918905650669,116.17347258874652,
	116.0550280187126,115.93655685414963,115.818059094184,115.69953473788443,115.58098378426165,
	115.46240623226836,115.34380208079935,115.22517132869139,115.10651397472317,114.98783001761541,
	114.86911945603065,114.75038228857333,114.63161851378982,114.51282813016819,114.39401113613842,
	114.27516753007215,114.15629731028285,114.03740047502563,113.91847702249731,113.79952695083635,
	113.68055025812286,113.5615469423784,113.44251700156626,113.32346043359115,113.20437723629928,
	113.08526740747836,112.96613094485744,112.84696784610702,112.72777810883903,112.6085617306066,
	112.4893187089042,112.37004904116755,112.25075272477372,112.1314297570408,112.01208013522809,
	111.89270385653606,111.77330091810627,111.6538713170213,111.53441505030474,111.41493211492127,
	111.29542250777638,111.17588622571655,111.05632326552909,110.93673362394226,110.81711729762506,
	110.69747428318723,110.57780457717931,110.4581081760925,110.33838507635863,110.21863527435028,
	110.09885876638046,109.97905554870282,109.85922561751154,109.73936896894122,109.61948559906692,
	109.49957550390413,109.37963867940866,109.25967512147666,109.13968482594457,109.01966778858908,
	108.89962400512705,108.77955347121564,108.65945618245193,108.53933213437328,108.41918132245704,
	108.29900374212053,108.1787993887211,108.05856825755606,107.9383103438625,107.81802564281755,
	107.69771414953803,107.57737585908052,107.45701076644144,107.33661886655683,107.21620015430247,
	107.09575462449367,106.97528227188538,106.85478309117207,106.73425707698773,106.61370422390578,
	106.49312452643913,106.37251797904,106.25188457609998,106.13122431195,106.01053718086018,
	105.8898231770399,105.76908229463778,105.6483145277415,105.5275198703779,105.40669831651284,
	105.28584986005129,105.16497449483708,105.04407221465311,104.92314301322112,104.80218688420176,
	104.68120382119446,104.56019381773751,104.43915686730793,104.31809296332138,104.19700209913232,
	104.07588426803373,103.95473946325725,103.83356767797316,103.71236890529009,103.59114313825528,
	103.46989036985443,103.34861059301159,103.22730380058913,103.1059699853879,102.98460914014701,
	102.86322125754376,102.74180633019373,102.62036435065072,102.4988953114066,102.3773992048915,
	102.25587602347352,102.13432575945885,102.01274840509167,101.89114395255422,101.7695123939666,
	101.64785372138691,101.52616792681107,101.40445500217292,101.28271493934402,101.16094773013378,
	101.03915336628943,100.91733183949577,100.79548314137543,100.67360726348863,100.55170419733327,
	100.42977393434485,100.30781646589641,100.18583178329861,100.06381987779955,99.94178074058486,
	99.81971436277769,99.69762073543856,99.57549984956543,99.45335169609368,99.33117626589603,
	99.20897354978254,99.08674353850068,98.96448622273508,98.84220159310773,98.71988964017788,
	98.59755035444202,98.47518372633387,98.35278974622433,98.23036840442144,98.10791969117054,
	97.98544359665397,97.86294011099133,97.74040922423923,97.6178509263915,97.49526520737902,
	97.37265205706971,97.25001146526867,97.12734342171794,97.00464791609674,96.88192493802123,
	96.75917447704467,96.63639652265739,96.51359106428666,96.39075809129686,96.26789759298934,
	96.14500955860257,96.0220939773119,95.8991508382298,95.77618013040578,95.65318184282637,
	95.5301559644151,95.40710248403262,95.28402139047652,95.16091267248159,95.03777631871957,
	94.91461231779934,94.7914206582669,94.66820132860533,94.54495431723483,94.42167961251276,
	94.2983772027337,94.1750470761293,94.05168922086854,93.92830362505752,93.80489027673973,
	93.68144916389583,93.55798027444386,93.43448359623922,93.31095911707463,93.18740682468031,
	93.06382670672384,92.9402187508104,92.81658294448263,92.69291927522075,92.56922773044263,
	92.4455082975038,92.32176096369753,92.1979857162548,92.0741825423445,91.9503514290733,
	91.82649236348591,91.70260533256497,91.57869032323119,91.45474732234345,91.33077631669877,
	91.2067772930325,91.08275023801828,90.95869513826817,90.83461198033271,90.71050075070107,
	90.58636143580102,90.46219402199917,90.33799849560079,90.21377484285027,90.08952304993088,
	89.96524310296515,89.84093498801464,89.71659869108049,89.59223419810306,89.46784149496233,
	89.34342056747799,89.21897140140949,89.09449398245614,88.96998829625736,88.84545432839263,
	88.7208920643818,88.59630148968509,88.47168258970333,88.34703534977808,88.22235975519169,
	88.09765579116754,87.97292344287024,87.84816269540568,87.72337353382119,87.59855594310582,
	87.47370990819054,87.34883541394811,87.22393244519368,87.0990009866847,86.9740410231212,
	86.84905253914596,86.72403551934475,86.59898994824655,86.47391581032365,86.34881308999198,
	86.22368177161128,86.09852183948537,85.97333327786235,85.8481160709348,85.72287020284008,
	85.59759565766059,85.47229241942398,85.34696047210346,85.22159979961798,85.09621038583255,
	84.97079221455861,84.8453452695542,84.71986953452428,84.594364993121,84.46883162894412,
	84.34326942554117,84.21767836640791,84.09205843498856,83.96640961467612,83.84073188881287,
	83.71502524069051,83.58928965355065,83.46352511058514,83.33773159493641,83.2119090896979,
	83.08605757791445,82.9601770425826,82.83426746665118,82.70832883302157,82.58236112454811,
	82.45636432403865,82.33033841425492,82.204283377913,82.07819919768374,81.95208585619332,
	81.82594333602358,81.69977161971269,81.57357068975553,81.4473405286042,81.3210811186686,
	81.19479244231694,81.06847448187628,80.94212721963304,80.81575063783364,80.68934471868508,
	80.56290944435537,80.43644479697438,80.30995075863427,80.18342731139022,80.05687443726092,
	79.93029211822942,79.80368033624364,79.67703907321719,79.55036831102984,79.42366803152852,
	79.29693821652774,79.17017884781063,79.04338990712938,78.91657137620629,78.78972323673433,
	78.66284547037803,78.53593805877436,78.40900098353347,78.28203422623949,78.15503776845148,
	78.02801159170438,77.90095567750971,77.77387000735665,77.64675456271291,77.51960932502568,
	77.39243427572269,77.26522939621297,77.13799466788818,77.01073007212345,76.88343559027841,
	76.75611120369842,76.62875689371545,76.50137264164945,76.37395842880929,76.24651423649398,
	76.11904004599396,75.99153583859216,75.86400159556531,75.73643729818527,75.60884292772012,
	75.48121846543569,75.35356389259684,75.22587919046866,75.09816434031816,74.97041932341543,
	74.84264412103524,74.7148387144585,74.5870030849737,74.45913721387852,74.33124108248148,
	74.20331467210336,74.07535796407896,73.9473709397588,73.81935358051075,73.69130586772184,
	73.56322778279994,73.43511930717574,73.30698042230449,73.17881110966788,73.05061135077605,
	72.9223811271695,72.79412042042114,72.66582921213836,72.53750748396507,72.40915521758392,
	72.28077239471838,72.15235899713517,72.02391500664632,71.8954404051117,71.76693517444119,
	71.63839929659736,71.50983275359773,71.38123552751746,71.2526076004919,71.12394895471918,
	70.99525957246307,70.86653943605552,70.73778852789967,70.60900683047271,70.48019432632879,
	70.35135099810202,70.2224768285096,70.09357180035497,69.96463589653101,69.83566910002332,
	69.70667139391362,69.57764276138323,69.44858318571647,69.31949265030433,69.19037113864825,
	69.06121863436366,68.93203512118406,68.80282058296483,68.67357500368725,68.54429836746269,
	68.41499065853682,68.28565186129393,68.15628196026121,68.02688094011354,67.89744878567785,
	67.76798548193804,67.63849101403972,67.50896536729519,67.37940852718863,67.24982047938116,
	67.12020120971624,66.99055070422513,66.86086894913248,66.731155930862,66.60141163604247,
	66.47163605151358,66.34182916433221,66.21199096177868,66.0821214313633,65.95222056083284,
	65.82228833817754,65.69232475163791,65.56232978971201,65.43230344116265,65.30224569502491,
	65.17215654061407,65.04203596753317,64.91188396568137,64.78170052526221,64.65148563679212,
	64.5212392911092,64.39096147938217,64.26065219311967,64.13031142417971,63.99993916477933,
	63.86953540750468,63.73910014532122,63.60863337158427,63.47813508004981,63.34760526488564,
	63.217043920682656,63.086451042466784,62.95582662571086,62.825170666347105,62.694483160779775,
	62.56376410589833,62.433013499090876,62.30223133825788,62.171417621826535,62.040572348765274,
	61.909695518598916,61.778787131424004,61.647847187924825,61.51687568938972,61.38587263772799,
	61.25483803548716,61.123771885870866,60.99267419275722,60.86154496071773,60.7303841950367,
	60.599191901731324,60.467968087572324,60.33671276010519,60.20542592767211,60.07410759943439,
	59.94275778539587,59.811376496426774,59.6799637442883,59.548519541658216,59.41704390215684,
	59.285536840374306,59.15399837189813,59.02242851334213,58.890827282375895,58.75919469775534,
	58.62753077935423,58.495835548196546,58.36410902649004,58.23235123766079,58.10056220638875,
	57.968741958644685,57.83689052172796,57.70500792430579,57.573094196453674,57.4411493696971,
	57.309173477054586,57.17716655308225,57.045128633919646,56.91305975733721,56.780959962785246,
	56.64882929144446,56.516667786278276,56.38447549208673,56.25225245556222,56.11999872534713,
	55.987714352093384,55.85539938852382,55.72305388949584,55.59067791206707,55.4582715155632,
	55.325834761648224,55.1933677143969,55.06087044036978,54.92834300869073,54.79578549112716,
	54.663197962172774,54.530580499133364,54.39793318221553,54.26525609461825,54.13254932262778,
	53.99981295571572,53.867047086640476,53.73425181155231,53.60142723010179,53.468573445552366,
	53.33569056489638,53.20277869897563,53.06983796260564,52.936868474704625,52.80387035842678,
	52.67084374130022,52.537788755370016,52.404705537345464,52.2715942287538,52.13845497609817,
	52.0052879310217,51.87209325047726,51.73887109690309,51.60562163840485,51.47234504894389,
	51.33904150853237,51.205711203435,51.07235432637835,50.93897107676715,50.80556166090852,
	50.67212629224412,50.53866519159043,50.405178587387844,50.271666715958155,50.138129821771706,
	50.004568157723675,49.87098198542045,49.7373715754759,49.60373720781849,49.47007917200914,
	49.33639776757053,49.20269330432787,49.06896610276213,48.9352164943756,48.80144482207048,
	48.667651440541036,48.53383671667947,48.40000102999648,48.2661447730564,48.13226835192812,
	47.9983721866516,47.86445671172115,47.73052237658569,47.5965696461667,47.462599001394246,
	47.328610939762086,47.19460597590215,47.060584642179194,46.926547489306216,46.792495086981404,
	46.658428024547305,46.524346911672815,46.39025237905898,46.25614507916895,46.12202568698346,
	45.98789490078197,45.85375344295074,45.71960206081855,45.58544152752077,45.45127264289278,
	45.317096234393624,45.18291315806066,45.04872429949625,44.91453057488723,44.780332932058464,
	44.64613235156076,44.51192984779489,44.377726470171986,44.24352330431173,44.10932147327903,
	43.97512213886037,43.84092650288052,43.70673580856097,43.57255134192057,43.43837443321973,
	43.304206458448895,43.17004884086238,43.035903052558155,42.901770616104855,42.767653106216535,
	42.633552151476295,42.499469436109045,42.365406701804744,42.23136574959231,42.09734844176497,
	41.963356703857656,41.82939252667672,41.69545796838253,41.56155515662502,41.427686290732645,
	41.29385364395434,41.160059565754956,41.026306484163385,40.892596908173495,40.75893343019694,
	40.62531872856733,40.491755570094774,40.35824681266963,40.22479540791414,40.09140440388134,
	39.95807694779287,39.8248162888295,39.69162578095115,39.558508885758556,39.42546917538782,
	39.292510335435026,39.15963616790707,39.02685059419441,38.894157658060934,38.7615615286457,
	38.62906650347077,38.496677011448995,38.36439761588507,38.23223301746228,38.10018805720735,
	37.968267719424674,37.83647713459108,37.70482158220116,37.57330649355305,37.441937454463286,
	37.31072020789957,37.17966065651832,37.04876486509472,36.91803906283091,36.78748964552825,
	36.65712317760833,36.52694639396701,36.396966201645114,36.2671896812988,36.13762408845167,
	36.00827685451088,35.8791555875283,35.75026807268771,35.6216222724986,35.49322632667662,
	35.36508855169096,35.237217439958265,35.10962165866319,34.98231004818525,34.855291620112595,
	34.72857555482275,34.602171198611785,34.47608806035336,34.35033580767022,34.22492426260174,
	34.099863396752205,33.97516332590567,33.850834304095294,33.72688671711635,33.60333107547417,
	33.48017800676057,33.35743824745434,33.23512263414432,33.11324209417593,32.99180763572481,
	32.87083033730487,32.750321336720596,32.63029181947705,32.51075300666423,32.39171614233641,
	32.27319248040999,32.15519327110747,32.03772974697857,31.920813108532865,31.804454509522195,
	31.68866504191401,31.57345572060044,31.4588374678905,31.34482109783604,31.231417300444264,
	31.1186366258323,31.006489468380686,30.894986050944848,30.784136409184406,30.673950376071048,
	30.564437566636187,30.45560736301943,30.347468899878333,30.240031050219162,30.13330241170648,
	30.02729129350802,29.922005703728626,29.817453337484316,29.713641565664517,29.61057742442675,
	29.50826760546451,29.406718447084597,29.30593592612565,29.205925650745662,29.106692854100373,
	29.00824238893036,28.910578723069214,28.81370593588017,28.71762771562352,28.622347357752368,
	28.527867764129056,28.43419144315012,28.341320510763357,28.24925669235571,28.158001325487312,
	28.067555363442825,27.97791937956826,27.88909357235791,27.801077771253997,27.713871443118276,
	27.62747369933418,27.5418833034953,27.457098679635422,27.37311792095424,27.28993879899227,
	27.20755877320858,27.125975000914593,27.045184347517946,26.96518339703114,26.885968462800243,
	26.807535598410546,26.72988060872706,26.652999061029583,26.57688629620344,26.50153743994926,
	26.426947413976688,26.35311094714907,26.280022586548586,26.207676708432835,26.136067529056437,
	26.06518911533339,25.99503539531783,25.9256001684831,25.856877115781142,25.788859809466192,
	25.721541722668746,25.654916238707653,25.588976660130008,25.52371621747026,25.459128077721623,
	25.3952053525143,25.331941105996773,25.269328362417284,25.207360113404555,25.14602932494739,
	25.085328944074128,25.02525190523399,24.965791136382997,24.906939564778263,24.8486901224848,
	24.791035751600226,24.73396940920237,24.67748407202646,24.621572740878015,24.566228444788344,
	24.511444244919918,24.45721323822902,24.403528560893058,24.350383391510686,24.297770954082115,
	24.245684520777857,24.194117414503772,24.14306301127018,24.092514742373115,24.04246609639538,
	23.992910621035264,23.9438419247704,23.895253678364362,23.84713961622319,23.799493537609234,
	23.75230930771907,23.705580858632505,23.659302190139165,23.613467370449253,23.568070536794455,
	23.5231058959254,23.478567724511077,23.434450369446193,23.3907482480716,23.3474558483132,
	23.304567728744193,23.26207851856586,23.21998291757064,23.178275695940656,23.13695169409219,
	23.096005822411787,23.055433060952566,23.015228459083506,22.975387135095023,22.935904275764212,
	22.896775135882915,22.857995037751575,22.81955937064166,22.781463590229468,22.743703218003702,
	22.706273840649366,22.6691711094101,22.632390739431298,22.595928509085784,22.559780259284196,
	22.523941892771784,22.488409373413166,22.453178725466945,22.418246032851357,22.383607438402617,
	22.349259143127092,22.31519740544858,22.28141854045195,22.24791891912404,22.214694967592962,
	22.181743166366633,22.149060049571585,22.116642204192562,22.08448626931399,22.052588935363758,
	22.0209469433601,21.989557084162094,21.958416197724347,21.927521172356446,21.89686894398743,
	21.866456495436005,21.8362808556866,21.806339099171797,21.776628345061397,21.74714575655838,
	21.717888540202086,21.6888539451788,21.660039262639916,21.63144182502802,21.603059005410795,
	21.57488821682314,21.546926911617458,21.519172580822307,21.491622753509468,21.464274996169447,
	21.437126912095543,21.410176140776525,21.38342035729786,21.356857271751572,21.330484628654773,
	21.304300206376723,21.27830181657461,21.252487303637782,21.22685454414062,21.201401446303883,
	21.176125949464506,21.151026023553822,21.126099668584125,21.101344914143517,21.076759818898974,
	21.052342470107547,21.02809098313564,21.004003500986297,20.980078193834295,20.9563132585692,
	20.932706918346025,20.909257422143572,20.885963044330317,20.86282208423775,20.83983286574104,
	20.81699373684694,20.794303069288922,20.77175925812925,20.74936072136815,20.727105899559653,
	20.704993255434402,20.683021273528926,20.661188459821556,20.63949334137478,20.617934465983936,
	20.596510401832127,20.575219737151397,20.55406107988975,20.53303305738434,20.512134316040335,
	20.491363521015675,20.470719355911363,20.450200522467405,20.429805740264158,20.409533746429076,
	20.389383295348768,20.36935315838614,20.349442123602742,20.329648995486036,20.30997259468165,
	20.290411757730368,20.270965336809986,20.25163219948169,20.232411228441105,20.21330132127375,
	20.19430139020546,20.175410361905634,20.156627177195706,20.13795079086278,20.119380171425902,
	20.100914300916745,20.082552174664322,20.06429280108353,20.04613520146751,20.028078409783713,
	20.0101214724736,19.99226344825598,19.974503407933824,19.956840434204544,19.939273621473674,
	19.921802075671792,19.904424914074863,19.887141265127575,19.869950268270024,19.852851073767273,
	19.83584284254211,19.818924746010616,19.802095965920753,19.78535569419376,19.7687031327683,
	19.75213749344745,19.735657997748273,19.71926387675411,19.70295437096943,19.6867287301772,
	19.67058621329882,19.65452608825639,19.63854763183746,19.622650129562157,19.606832875552477,
	19.591095172404025,19.57543633105981,19.55985567068637,19.544352518551907,19.52892620990656,
	19.513576087864813,19.49830150328978,19.48310181467956,19.467976388055575,19.452924596852686,
	19.437945821811258,19.4230394508711,19.408204879067117,19.393441508426758,19.378748747869228,
	19.364126013106368,19.349572726545237,19.335088317192252,19.320672220559032,19.30632387856979,
	19.292042739470197,19.277828257737887,19.26367989399436,19.249597114918377,19.23557939316078,
	19.221626207260766,19.207737041563462,19.19391138613894,19.180148736702478,19.16644859453623,
	19.152810466412078,19.139233864515802,19.12571830637249,19.11226331477311,19.098868417702338,
	19.085533148267494,19.072257044628675,19.05903964992999,19.04588051223191,19.032779184444692,
	19.019735224262885,19.00674819410086,18.99381766102943,18.980943196713365,18.968124377350033,
	18.95536078360891,18.942652000572096,18.92999761767576,18.917397228652497,18.904850431474628,
	18.892356828298322,18.879916025408658,18.86752763316551,18.85519126595027,18.84290654211344,
	18.83067308392296,18.818490517513464,18.80635847283614,18.794276583609534,18.782244487270994,
	18.770261824928948,18.758328241315823,18.746443384741738,18.73460690704891,18.7228184635667,
	18.711077713067418,18.699384317722714,18.68773794306067,18.67613825792359,18.66458493442629,
	18.653077647915133,18.641616076927665,18.63019990315277,18.61882881139153,18.607502489518556,
	18.596220628444,18.58498292207607,18.57378906728406,18.562638763862033,18.551531714492935,
	18.540467624713305,18.529446202878454,18.51846716012817,18.50753021035295,18.496635070160664,
	18.48578145884376,18.47496909834693,18.464197713235194,18.45346703066251,18.442776780340818,
	18.43212669450949,18.421516507905277,18.41094595773263,18.40041478363447,18.389922727663404,
	18.37946953425325,18.36905495019113,18.358678724589748,18.348340608860273,18.33804035668543,
	18.327777723993076,18.31755246893009,18.307364351836657,18.2972131352209,18.28709858373387,
	18.277020464144858,18.2669785453171,18.256972598183772,18.247002395724312,18.237067712941133,
	18.227168326836566,18.217304016390184,18.20747456253641,18.19767974814243,18.187919357986424,
	18.178193178736063,18.16850099892733,18.158842608943594,18.149217800995014,18.139626369098153,
	18.130068109055923,18.120542818437777,18.111050296560162,18.10159034446725,18.092162764911915,
	18.08276736233691,18.07340394285644,18.06407231423779,18.05477228588337,18.045503668812838,
	18.036266275645584,18.02705992058341,18.017884419393365,18.008739589380664,17.999625249413608,
	17.99054121984377,17.98148732253269,17.97246338082489,17.963469219532158,17.954504664917838,
	17.945569544681465,17.936663687943557,17.92778692523057,17.918939088460082,17.91012001092616,
	17.9013295272849,17.892567473540176,17.883833687029504,17.875128006410204,17.866450271645608,
	17.857800323991516,17.849178005982832,17.840583161420295,17.832015635357457,17.823475274087784,
	17.814961925131904,17.806475437225053,17.798015660304642,17.789582445498002,17.781175645110267,
	17.772795112612414,17.76444070262943,17.756112270928654,17.747809674408263,17.739532771085862,
	17.731281420087218,17.72305548163519,17.714854817038745,17.7066792886821,17.69852876001399,
	17.690403095537135,17.682302160797768,17.674225822375263,17.66617394787199,17.658146405903206,
	17.65014306608709,17.642163799034893,17.63420847634123,17.626276970574473,17.618369155267217,
	17.61048490490695,17.602624094926725,17.594786601696043,17.58697230251177,17.57918107558918,
	17.571412800053153,17.563667355929372,17.55594462413574,17.54824448647381,17.540566825620346,
	17.532911525118998,17.525278469372047,17.51766754363225,17.510078633994784,17.502511627389307,
	17.494966411572058,17.48744287511809,17.479940907413567,17.47246039864817,17.4650012398076,
	17.45756332266607,17.45014653977905,17.442750784475955,17.43537595085297,17.428021933765933,
	17.420688628823346,17.413375932379413,17.406083741527162,17.3988119540917,17.391560468623442,
	17.38432918439154,17.377118001377266,17.369926820267537,17.36275554244852,17.355604069999266,
	17.34847230568542,17.34136015295304,17.33426751592244,17.327194299382118,17.320140408782763,
	17.313105750231312,17.306090230485058,17.299093756945865,17.292116237654405,17.28515758128448,
	17.27821769713738,17.27129649513634,17.264393885821036,17.257509780342154,17.250644090455943,
	17.24379672851898,17.236967607482832,17.230156640888865,17.22336374286309,17.21658882811106,
	17.209831811912803,17.203092610117853,17.1963711391403,17.189667315953876,17.18298105808715,
	17.17631228361873,17.169660911172528,17.163026859913053,17.156410049540796,17.149810400287638,
	17.143227832912302,17.13666226869585,17.130113629437265,17.12358183744901,17.11706681555271,
	17.11056848707481,17.10408677584234,17.097621606178656,17.091172902899284,17.084740591307806,
	17.078324597191717,17.071924846818394,17.065541266931113,17.059173784745056,17.05282232794335,
	17.04648682467324,17.040167203542225,17.033863393614194,17.027575324405714,17.02130292588227,
	17.015046128454582,17.008804862974944,17.00257906073357,16.996368653455047,16.990173573294776,
	16.983993752835442,16.97782912508355,16.971679623465963,16.96554518182651,16.95942573442261,
	16.95332121592189,16.94723156139892,16.941156706331913,16.93509658659948,16.92905113847742,
	16.923020298635542,16.9170040041345,16.911002192422675,16.905014801333095,16.89904176908037,
	16.893083034257657,16.887138535833657,16.88120821314966,16.87529200591659,16.86938985421207,
	16.863501698477585,16.857627479515564,16.851767138486604,16.84592061690663,16.840087856644114,
	16.834268799917353,16.828463389291727,16.822671567676988,16.816893278324617,16.81112846482515,
	16.805377071105575,16.799639041426705,16.79391432038063,16.788202852888173,16.78250458419634,
	16.77681945987584,16.77114742581859,16.765488428235276,16.7598424136529,16.75420932891242,
	16.748589121166283,16.74298173787613,16.737387126810415,16.731805236042113,16.726236013946398,
	16.720679409198368,16.715135370770813,16.709603847931923,16.704084790243126,16.69857814755687,
	16.693083870014455,16.687601908043874,16.682132212357654,16.676674733950794,16.671229424098627,
	16.665796234354733,16.660375116548906,16.654966022785107,16.649568905439455,16.644183717158178,
	16.63881041085568,16.633448939712533,16.628099257173563,16.62276131694588,16.617435072996987,
	16.61212047955288,16.606817491096155,16.601526062364144,16.59624614834709,16.59097770428629,
	16.585720685672275,16.58047504824304,16.57524074798225,16.57001774111744,16.564805984118298,
	16.55960543369494,16.554416046796142,16.549237780607672,16.544070592550575,16.538914440279527,
	16.533769281681124,16.528635074872305,16.523511778198635,16.518399350232738,16.51329774977271,
	16.508206935840466,16.503126867680212,16.49805750475686,16.492998806754496,16.487950733574824,
	16.482913245335634,16.477886302369324,16.47286986522138,16.467863894648897,16.4628683516191,
	16.457883197307893,16.452908393098404,16.447943900579567,16.442989681544663,16.43804569798996,
	16.433111912113258,16.428188286312558,16.42327478318464,16.418371365523743,16.413477996320143,
	16.4085946387589,16.40372125621848,16.398857812269416,16.394004270673047,16.389160595380204,
	16.38432675052991,16.379502700448125,16.374688409646456,16.369883842820947,16.36508896485077,
	16.360303740797068,16.355528135901665,16.350762115585887,16.34600564544937,16.341258691268823,
	16.33652121899687,16.331793194760916,16.327074584861897,16.322365355773197,16.31766547413947,
	16.312974906775516,16.30829362066514,16.303621582960062,16.298958760978763,16.294305122205444,
	16.28966063428889,16.28502526503223,16.28039898242891,16.27578175460551,16.271173549858485,
	16.26657433664355,16.261984083574664,16.257402759422998,16.252830333115913,16.248266773735907,
	16.24371205051967,16.239166132857044,16.23462899029005,16.230100592511906,16.225580909366027,
	16.221069910845088,16.216567567090067,16.21207384838926,16.207588725177374,16.203112168034558,
	16.198644147685496,16.194184634998486,16.189733600984493,16.18529101679628,16.18085685372751,
	16.17643108321179,16.172013676821862,16.167604606268675,16.163203843400538,16.158811360202222,
	16.15442712879415,16.15005112143147,16.145683310503287,16.141323668531786,16.136972168171393,
	16.132628782207952,16.128293483557908,16.12396624526751,16.119647040511964,16.115335842594675,
	16.111032624946407,16.10673736112453,16.10245002481222,16.09817058981768,16.093899030073363,
	16.089635319635228,16.085379432681954,16.08113134351421,16.07689102655387,16.072658456343312,
	16.06843360754466,16.06421645493905,16.060006973425896,16.05580513802219,16.051610923861787,
	16.04742430619466,16.04324526038622,16.03907376191664,16.0349097863801,16.03075330948417,
	16.02660430704904,16.02246275500694,16.018328629401374,16.014201906386514,16.010082562226504,
	16.005970573294807,16.001865916073562,15.997768567152912,15.993678503230392,15.989595701110236,
	15.985520137702814,15.981451790023927,15.977390635194237,15.973336650438604,15.969289813085512,
	15.965250100566404,15.961217490415136,15.957191960267302,15.953173487859697,15.949162051029683,
	15.945157627714622,15.94116019595127,15.93716973387521,15.933186219720255,15.929209631817912,
	15.925239948596753,15.921277148581902,15.91732121039446,15.913372112750915,15.909429834462651,
	15.905494354435321,15.90156565166837,15.897643705254456,15.893728494378914,15.889819998319243,
	15.885918196444539,15.882023068215007,15.87813459318141,15.874252750984573,15.870377521354833,
	15.86650888411156,15.862646819162647,15.858791306503965,15.854942326218925,15.851099858477921,
	15.847263883537876,15.843434381741721,15.83961133351793,15.835794719380038,15.831984519926122,
	15.82818071583839,15.824383287882629,15.8205922169078,15.816807483845533,15.813029069709684,
	15.809256955595847,15.80549112268092,15.801731552222652,15.797978225559172,15.79423112410854,
	15.790490229368332,15.786755522915161,15.783026986404268,15.77930460156906,15.77558835022069,
	15.771878214247636,15.768174175615238,15.764476216365319,15.760784318615721,15.75709846455993,
	15.753418636466611,15.749744816679238,15.74607698761566,15.742415131767697,15.738759231700733,
	15.735109270053329,15.731465229536786,15.727827092934813,15.724194843103058,15.720568462968773,
	15.716947935530387,15.713333243857152,15.70972437108874,15.706121300434859,15.702524015174895,
	15.698932498657499,15.69534673430025,15.691766705589274,15.688192396078867,15.684623789391125,
	15.681060869215598,15.677503619308919,15.673952023494424,15.67040606566185,15.666865729766911,
	15.663330999831015,15.659801859940849,15.65627829424808,15.65276028696899,15.64924782238413,
	15.645740884837988,15.642239458738658,15.638743528557477,15.635253078828713,15.631768094149226,
	15.628288559178156,15.624814458636546,15.621345777307077,15.6178825000337,15.614424611721342,
	15.610972097335566,15.607524941902277,15.604083130507387,15.600646648296507,15.597215480474633,
	15.593789612305857,15.590369029113031,15.586953716277467,15.583543659238668,15.58013884349398,
	15.576739254598317,15.573344878163871,15.569955699859772,15.566571705411876,15.563192880602385,
	15.559819211269613,15.556450683307672,15.553087282666205,15.549728995350096,15.546375807419158,
	15.5430277049879,15.53968467422522,15.536346701354125,15.53301377265146,15.52968587444765,
	15.526362993126403,15.523045115124448,15.519732226931273,15.516424315088862,15.513121366191411,
	15.50982336688507,15.506530303867684,15.503242163888551,15.499958933748122,15.49668060029779,
	15.493407150439579,15.490138571125957,15.48687484935952,15.483615972192785,15.480361926727921,
	15.47711270011649,15.473868279559237,15.470628652305809,15.467393805654536,15.464163726952155,
	15.460938403593625,15.457717823021826,15.454501972727368,15.451290840248342,15.448084413170061,
	15.44488267912487,15.441685625791873,15.438493240896731,15.435305512211416,15.432122427554,
	15.428943974788414,15.42577014182421,15.422600916616389,15.419436287165123,15.416276241515556,
	15.413120767757588,15.409969854025665,15.406823488498526,15.403681659399039,15.400544354993931,
	15.397411563593632,15.394283273552011,15.391159473266205,15.388040151176387,15.38492529576556,
	15.381814895559373,15.378708939125875,15.375607415075349,15.372510312060076,15.369417618774179,
	15.366329323953371,15.363245416374774,15.360165884856741,15.357090718258629,15.354019905480637,
	15.350953435463564,15.347891297188655,15.344833479677389,15.341779971991315,15.338730763231805,
	15.335685842539927,15.33264519909622,15.329608822120523,15.326576700871769,15.323548824647832,
	15.320525182785316,15.317505764659376,15.314490559683556,15.31147955730959,15.308472747027214,
	15.30547011836402,15.302471660885246,15.2994773641936,15.296487217929135,15.29350121176901,
	15.290519335427337,15.287541578655034,15.284567931239618,15.281598383005061,15.278632923811614,
	15.275671543555607,15.272714232169356,15.269760979620905,15.266811775913931,15.263866611087549,
	15.260925475216139,15.257988358409225,15.255055250811248,15.252126142601476,15.249201023993788,
	15.246279885236541,15.243362716612415,15.240449508438239,15.237540251064853,15.23463493487693,
	15.231733550292844,15.22883608776451,15.225942537777216,15.223052890849484,15.220167137532924,
	15.217285268412073,15.214407274104245,15.211533145259402,15.208662872559968,15.205796446720715,
	15.202933858488606,15.200075098642657,15.197220157993765,15.194369027384603,15.191521697689447,
	15.188678159814046,15.185838404695497,15.183002423302055,15.18017020663304,15.177341745718696,
	15.174517031620018,15.171696055428647,15.168878808266712,15.166065281286714,15.163255465671382,
	15.160449352633528,15.157646933415927,15.154848199291166,15.152053141561542,15.149261751558914,
	15.146474020644549,15.143689940209033,15.140909501672109,15.138132696482575,15.13535951611813,
	15.132589952085265,15.129823995919125,15.127061639183394,15.124302873470155,15.121547690399778,
	15.11879608162079,15.116048038809758,15.113303553671162,15.110562617937264,15.107825223367996,
	15.105091361750846,15.10236102490073,15.099634204659866,15.096910892897663,15.094191081510605,
	15.091474762422138,15.088761927582528,15.086052568968778,15.083346678584492,15.08064424845976,
	15.07794527065105,15.0752497372411,15.07255764033879,15.069868972079032,15.067183724622673,
	15.064501890156372,15.061823460892489,15.059148429068962,15.056476786949236,15.05380852682212,
	15.051143641001678,15.04848212182714,15.045823961662787,15.043169152897843,15.04051768794636,
	15.037869559247124,15.035224759263556,15.032583280483594,15.029945115419595,15.027310256608219,
	15.024678696610342,15.022050428010958,15.019425443419054,15.016803735467525,15.014185296813098,
	15.011570120136145,15.008958198140698,15.006349523554274,15.003744089118518,15.001141887626495,
	14.998542911866078,14.99594715465782,14.99335460884529,14.99076526729499,14.988179122896227,
	14.985596168561043,14.983016397224132,14.980439801842696,14.977866375396419,14.975296110887307,
	14.972729001339646,14.970165039799886,14.967604219336552,14.965046533040159,14.962491974023102,
	14.959940535419584,14.957392210385544,14.954846992098506,14.952304873757562,14.949765848583228,
	14.9472299098174,14.944697050723223,14.942167264585029,14.939640544708256,14.937116884419348,
	14.934596277065676,14.932078716015432,14.929564194657583,14.927052706401744,14.924544244678128,
	14.922038802937449,14.91953637465083,14.917036953309733,14.91454053242586,14.912047105531101,
	14.909556666177423,14.907069207936795,14.904584724401111,14.90210320918213,14.899624655911332,
	14.897149058239934,14.894676409838716,14.892206704398001,14.889739935627574,14.887276097256557,
	14.884815183033387,14.882357186725708,14.879902102120308,14.877449923023017,14.875000643258677,
	14.872554256671012,14.870110757122598,14.867670138494756,14.865232394687496,14.862797519619434,
	14.860365507227735,14.857936351468004,14.855510046314228,14.853086585758737,14.850665963812078,
	14.848248174502997,14.845833211878295,14.84342107000284,14.841011742959434,14.838605224848758,
	14.836201509789328,14.833800591917383,14.831402465386846,14.829007124369248,14.826614563053642,
	14.824224775646567,14.821837756371927,14.819453499470999,14.81707199920228,14.8146932498415,
	14.812317245681479,14.809943981032124,14.807573450220328,14.805205647589903,14.802840567501542,
	14.800478204332713,14.798118552477625,14.795761606347158,14.793407360368787,14.791055808986519,
	14.788706946660847,14.78636076786866,14.7840172671032,14.781676438873996,14.779338277706783,
	14.777002778143471,14.774669934742052,14.77233974207655,14.770012194736982,14.767687287329245,
	14.765365014475101,14.763045370812113,14.760728350993539,14.758413949688341,14.756102161581065,
	14.753792981371813,14.751486403776187,14.749182423525198,14.746881035365234,14.744582234058017,
	14.742286014380488,14.739992371124822,14.737701299098303,14.735412793123306,14.73312684803724,
	14.730843458692467,14.728562619956278,14.726284326710793,14.724008573852952,14.72173535629443,
	14.71946466896159,14.717196506795428,14.714930864751503,14.712667737799922,14.710407120925233,
	14.708149009126426
	}}
};
table1d_imp<2001> tubetable2_6DJ8[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	10721.035383640725,10707.851918965107,10694.691631754054,10681.55446858672,10668.440376226128,
	10655.349301620694,10642.281191902457,10629.235994386736,10616.21365657107,10603.214126135512,
	10590.2373509412,10577.283279030033,10564.351858624104,10551.443038124873,10538.556766112762,
	10525.692991346743,10512.851662762394,10500.032729473918,10487.236140770505,10474.461846118302,
	10461.709795158169,10448.979937705464,10436.27222375045,10423.586603455864,10410.923027158198,
	10398.281445365774,10385.66180875885,10373.06406818909,10360.48817467852,10347.934079418877,
	10335.401733772369,10322.891089269291,10310.402097608736,10297.934710657526,10285.48888044931,
	10273.064559185497,10260.661699232514,10248.280253123228,10235.92017355532,10223.581413391215,
	10211.263925656944,10198.967663542338,10186.692580400404,10174.43862974616,10162.205765256898,
	10149.993940770957,10137.80311028789,10125.633227967532,10113.484248129906,10101.356125253582,
	10089.248813976534,10077.162269095415,10065.09644556375,10053.05129849345,10041.02678315286,
	10029.022854966568,10017.039469515305,10005.076582534844,9993.134149916239,9981.212127704968,
	9969.310472100025,9957.429139454665,9945.568086274343,9933.727269217812,9921.906645095269,
	9910.106170868767,9898.325803651822,9886.56550070804,9874.825219451628,9863.104917446955,
	9851.404552406975,9839.724082193763,9828.063464818319,9816.422658439014,9804.80162136247,
	9793.200312041505,9781.618689076608,9770.05671121367,9758.514337345308,9746.991526508587,
	9735.488237886444,9724.004430805706,9712.54006473775,9701.09509929706,9689.669494242555,
	9678.26320947506,9666.876205037966,9655.508441117474,9644.159878040555,9632.830476276145,
	9621.520196433701,9610.228999263256,9598.956845654815,9587.703696638198,9576.469513382584,
	9565.254257195938,9554.057889524644,9542.880371953628,9531.721666205403,9520.58173413943,
	9509.460537752908,9498.358039179291,9487.274200688295,9476.208984685634,9465.162353712522,
	9454.134270445453,9443.124697695608,9432.133598408527,9421.16093566435,9410.206672676148,
	9399.270772791366,9388.353199489573,9377.453916383693,9366.57288721868,9355.710075871759,
	9344.865446351496,9334.03896279822,9323.230589482628,9312.440290806886,9301.668031302934,
	9290.913775633064,9280.177488588903,9269.459135091627,9258.758680191706,9248.076089067996,
	9237.411327027916,9226.764359506773,9216.135152068075,9205.523670402446,9194.929880327856,
	9184.353747789093,9173.795238857323,9163.254319730384,9152.730956731777,9142.225116310663,
	9131.73676504165,9121.265869624604,9110.812396883694,9100.37631376828,9089.957587351317,
	9079.556184830104,9069.17207352527,9058.805220881173,9048.455594464958,9038.123161967018,
	9027.80789119987,9017.50975009831,9007.228706719734,8996.964729242534,8986.717785967143,
	8976.487845315081,8966.274875828734,8956.078846171475,8945.899725126732,8935.73748159835,
	8925.592084610502,8915.463503306473,8905.351706949334,8895.2566649216,8885.178346724293,
	8875.11672197745,8865.071760419733,8855.043431907818,8845.031706416807,8835.036554039198,
	8825.057944985427,8815.095849583044,8805.150238277012,8795.22108162884,8785.308350317226,
	8775.412015136937,8765.532046999297,8755.66841693157,8745.8210960769,8735.99005569396,
	8726.175267157056,8716.376701955818,8706.594331694454,8696.82812809241,8687.078062983854,
	8677.344108317016,8667.626236154574,8657.924418673416,8648.238628164036,8638.568837030796,
	8628.915017791569,8619.277143077394,8609.65518563263,8600.049118314537,8590.458914093073,
	8580.884546051042,8571.32598738354,8561.783211397878,8552.25619151374,8542.744901262377,
	8533.249314287319,8523.769404343146,8514.30514529642,8504.856511124875,8495.42347591725,
	8486.00601387338,8476.604099304064,8467.217706630625,8457.846810385277,8448.491385210316,
	8439.151405858544,8429.826847192766,8420.517684186061,8411.223891921167,8401.945445590665,
	8392.682320496679,8383.434492050988,8374.201935774607,8364.984627297872,8355.782542360248,
	8346.595656810321,8337.423946605328,8328.267387811502,8319.12595660386,8309.999629265565,
	8300.888382188756,8291.792191873537,8282.711034928545,8273.64488807039,8264.593728123966,
	8255.557532021774,8246.536276804718,8237.529939620894,8228.538497726648,8219.561928485567,
	8210.600209368919,8201.653317955488,8192.721231931278,8183.8039290897195,8174.901387331343,
	8166.013584663947,8157.140499202499,8148.2821091687465,8139.438392891408,8130.609328806355,
	8121.7948954561525,8112.9950714900415,8104.209835664063,8095.43916684112,8086.68304399035,
	8077.941446187766,8069.21435261573,8060.5017425632195,8051.803595425608,8043.119890704719,
	8034.450608008684,8025.795727051979,8017.155227655526,8008.529089746227,7999.917293357655,
	7991.319818629218,7982.736645806806,7974.167755242338,7965.613127394173,7957.072742826409,
	7948.546582209793,7940.034626320912,7931.536856042518,7923.053252363518,7914.583796379299,
	7906.128469290782,7897.687252405531,7889.260127137179,7880.847075005189,7872.448077635829,
	7864.063116760943,7855.692174219019,7847.335231954613,7838.992272018599,7830.663276567972,
	7822.348227866422,7814.047108283624,7805.759900295671,7797.486586485446,7789.227149541774,
	7780.9815722604535,7772.7498375435525,7764.531928399821,7756.327827944662,7748.137519400102,
	7739.960986095205,7731.798211465601,7723.649179053717,7715.513872509369,7707.392275588875,
	7699.284372156013,7691.190146181398,7683.1095817434125,7675.042663027183,7666.9893743256125,
	7658.949700038905,7650.92362467491,7642.911132849248,7634.912209285124,7626.92683881373,
	7618.9550063741,7610.996697013578,7603.051895887394,7595.120588259199,7587.202759501122,
	7579.298395093635,7571.407480625994,7563.530001796138,7555.665944410869,7547.815294386018,
	7539.978037746738,7532.154160627019,7524.34364927075,7516.5464900310435,7508.7626693710035,
	7500.992173863251,7493.2349901906755,7485.491105146207,7477.7605056330385,7470.043178665042,
	7462.339111366573,7454.648290972779,7446.97070482988,7439.306340395227,7431.65518523746,
	7424.01722703687,7416.392453585167,7408.780852786313,7401.182412656133,7393.597121322745,
	7386.024967026892,7378.465938121863,7370.920023073802,7363.387210462115,7355.867488979354,
	7348.360847431881,7340.867274739526,7333.3867599361265,7325.919292169934,7318.464860703512,
	7311.023454914028,7303.595064293815,7296.1796784501375,7288.777287105709,7281.387880099176,
	7274.011447384728,7266.647979033035,7259.2974652310095,7251.959896282338,7244.635262607885,
	7237.32355474556,7230.024763350855,7222.738879197201,7215.465893176099,7208.205796297459,
	7200.95857968981,7193.72423460075,7186.502752397441,7179.2941245662705,7172.09834271383,
	7164.915398566975,7157.7452839729585,7150.5879909001405,7143.443511438091,7136.311837797755,
	7129.192962312409,7122.086877437143,7114.993575750049,7107.913049951939,7100.845292867137,
	7093.79029744348,7086.748056752903,7079.718563991895,7072.701812481863,7065.6977956689825,
	7058.706507125359,7051.727940549164,7044.762089764745,7037.808948723069,7030.868511502657,
	7023.940772309398,7017.02572547728,7010.1233654687985,7003.233686875048,6996.356684416734,
	6989.492352944128,6982.640687437706,6975.801683008612,6968.975334898988,6962.161638482597,
	6955.360589265151,6948.572182885018,6941.796415113165,6935.033281854326,6928.282779146913,
	6921.544903163938,6914.819650213221,6908.107016737881,6901.406999317231,6894.719594666807,
	6888.044799639101,6881.382611224198,6874.733026550049,6868.096042883384,6861.471657629675,
	6854.8598683344,6848.260672682905,6841.674068501628,6835.100053758091,6828.538626561744,
	6821.989785164673,6815.453527961829,6808.929853491986,6802.418760438162,6795.920247628075,
	6789.434314035113,6782.960958778654,6776.500181124888,6770.051980487379,6763.616356427457,
	6757.193308655264,6750.782837030342,6744.384941561971,6737.999622410119,6731.626879886174,
	6725.266714453216,6718.919126727229,6712.584117477403,6706.261687627036,6699.951838254214,
	6693.6545705923345,6687.369886031217,6681.09778611742,6674.838272555207,6668.591347207284,
	6662.357012095461,6656.1352694015695,6649.926121467902,6643.72957079846,6637.54562005933,
	6631.374272079639,6625.215529852336,6619.069396535174,6612.935875451022,6606.814970089226,
	6600.706684106361,6594.611021326491,6588.5279857431005,6582.457581518587,6576.39981298647,
	6570.354684651213,6564.322201189696,6558.30236745203,6552.295188462158,6546.300669419044,
	6540.318815697555,6534.349632849205,6528.393126603357,6522.44930286779,6516.5181677302235,
	6510.599727458492,6504.693988502361,6498.800957493787,6492.920641248342,6487.053046766055,
	6481.198181232258,6475.356052019147,6469.52666668594,6463.710032980802,6457.906158841223,
	6452.115052395426,6446.336721963368,6440.571176057626,6434.818423384676,6429.078472846071,
	6423.351333539104,6417.637014758434,6411.935525996852,6406.246876946697,6400.571077500587,
	6394.908137753045,6389.258068001229,6383.620878746476,6377.996580695282,6372.3851847604565,
	6366.786702062391,6361.201143930294,6355.6285219035035,6350.068847732334,6344.522133379871,
	6338.988391022871,6333.467633053105,6327.9598720784725,6322.465120924813,6316.983392636544,
	6311.514700478463,6306.059057936696,6300.61647872052,6295.186976763097,6289.770566223303,
	6284.367261487061,6278.977077168316,6273.600028110876,6268.23612938978,6262.885396312213,
	6257.547844419693,6252.223489488876,6246.912347533272,6241.614434804816,6236.329767795016,
	6231.058363236824,6225.800238105869,6220.555409621926,6215.323895250705,6210.10571270522,
	6204.900879947219,6199.70941518907,6194.531336894967,6189.366663782794,6184.215414825638,
	6179.077609253192,6173.9532665538045,6168.8424064756055,6163.745049028696,6158.661214486317,
	6153.5909233868015,6148.534196535229,6143.49105500505,6138.46152013982,6133.445613554908,
	6128.443357139383,6123.454773057432,6118.479883750617,6113.518711939089,6108.571280623749,
	6103.637613088006,6098.717732899443,6093.811663911801,6088.91943026665,6084.041056395393,
	6079.176567021141,6074.325987160411,6069.489342125214,6064.666657524692,6059.85795926756,
	6055.063273563316,6050.282626924759,6045.5160461696405,6040.763558422819,6036.025191118137,
	6031.300972000212,6026.590929126944,6021.895090870944,6017.213485922047,6012.54614328912,
	6007.8930923021135,6003.254362614027,5998.629984203353,5994.019987375724,5989.424402766374,
	5984.84326134191,5980.276594402778,5975.724433585055,5971.186810862926,5966.663758550554,
	5962.155309304377,5957.661496125328,5953.1823523609455,5948.717911707563,5944.268208212554,
	5939.8332762766195,5935.413150655686,5931.0078664637085,5926.61745917433,5922.2419646235385,
	5917.881419011706,5913.535858906035,5909.20532124257,5904.889843328883,5900.58946284582,
	5896.304217850487,5892.034146777878,5887.779288443664,5883.539682046175,5879.3153671691,
	5875.106383783471,5870.912772250148,5866.734573322075,5862.5718281468735,5858.424578268808,
	5854.292865631365,5850.176732579615,5846.076221862434,5841.991376635021,5837.922240461036,
	5833.868857315211,5829.831271585406,5825.809528075186,5821.8036720061245,5817.8137490201425,
	5813.839805181699,5809.881886980316,5805.940041332877,5802.014315585873,5798.104757517791,
	5794.211415341264,5790.334337705749,5786.473573699361,5782.629172851392,5778.801185134526,
	5774.989660967213,5771.194651215701,5767.416207196386,5763.654380677905,5759.909223883557,
	5756.180789493202,5752.469130645602,5748.774300940425,5745.096354440473,5741.435345673511,
	5737.791329634623,5734.164361788131,5730.55449806946,5726.961794887207,5723.386309125076,
	5719.828098143755,5716.287219782713,5712.7637323620875,5709.257694684494,5705.769166036592,
	5702.298206190892,5698.844875407448,5695.40923443525,5691.991344514,5688.591267375325,
	5685.20906524445,5681.844800841382,5678.498537382258,5675.170338580554,5671.860268648375,
	5668.568392297325,5665.294774739637,5662.039481689148,5658.8025793620745,5655.584134477768,
	5652.384214259426,5649.2028864346685,5646.04021923606,5642.896281401378,5639.77114217394,
	5636.664871302832,5633.577539042908,5630.509216154692,5627.459973904234,5624.429884062764,
	5621.419018906219,5618.427451214685,5615.455254271683,5612.502501863166,5609.5692682765475,
	5606.655628299513,5603.761657218639,5600.887430817746,5598.033025376242,5595.198517667209,
	5592.383984955245,5589.589504994134,5586.815156024371,5584.061016770284,5581.32716643722,
	5578.613684708169,5575.920651740376,5573.248148161665,5570.596255066382,5567.965054011127,
	5565.3546270103925,5562.765056531516,5560.196425489653,5557.648817242364,5555.122315583852,
	5552.617004738647,5550.132969355539,5547.670294500341,5545.229065649033,5542.809368679928,
	5540.411289865825,5538.034915865612,5535.680333715308,5533.347630818945,5531.036894938645,
	5528.748214184608,5526.481677004164,5524.237372170684,5522.015388771744,5519.815816196864,
	5517.638744124531,5515.484262508838,5513.3524615652905,5511.2434317561165,5509.157263774866,
	5507.094048530429,5505.053877130199,5503.036840862588,5501.043031178871,5499.072539674138,
	5497.125458067439,5495.201878181186,5493.3018919196265,5491.425591246517,5489.573068161682,
	5487.744414676845,5485.9397227903755,5484.1590844609345,5482.40259158029,5480.670335944752,
	5478.962409225752,5477.278902939093,5475.619908413024,5473.985516755045,5472.375818817628,
	5470.790905162233,5469.2308660222925,5467.69579126459,5466.185770349163,5464.700892287858,
	5463.241245601029,5461.806918272856,5460.397997704961,5459.014570668065,5457.656723252116,
	5456.324540814429,5455.01810792597,5453.737508315603,5452.482824812288,5451.254139285239,
	5450.0515325819115,5448.875084463577,5447.7248735388,5446.600977194381,5445.503471523734,
	5444.4324312530125,5443.387929664214,5442.370038515862,5441.37882796077,5440.414366460773,
	5439.47672069879,5438.565955487473,5437.682133674823,5436.825316046617,5435.99556122518,
	5435.192925565139,5434.417463044995,5433.669225155505,5432.94826078401,5432.254616094954,
	5431.588334406275,5430.949456061653,5430.338018298648,5429.754055112282,5429.197597114147,
	5428.668671386925,5428.16730133414,5427.693506524919,5427.247302533965,5426.828700776132,
	5426.437708335809,5426.074327790989,5425.738557031686,5425.430389072668,5425.149811860559,
	5424.89680807465,5424.67135492202,5424.4734239262,5424.302980709695,5424.1599847698835,
	5424.044389248366,5423.956140693836,5423.895178817835,5423.861436243835,5423.8548382490935,
	5423.875302499641,5423.922738777842,5423.997048702794,5424.098125443321,5424.225853423586,
	5424.380108021298,5424.560755258248,5424.767651483545,5425.00064304934,5425.259565978701,
	5425.544245626582,5425.854496333037,5426.190121069253,5426.550911076214,5426.936645496579,
	5427.347090999506,5427.782001398744,5428.2411172643515,5428.7241655282705,5429.230859083976,
	5429.760896380544,5430.313961011897,5430.889721301092,5431.487829880782,5432.107923269932,
	5432.749621447646,5433.412527424921,5434.096226814744,5434.800287401642,5435.524258711586,
	5436.267671582986,5437.030037740256,5437.8108493705695,5438.609578705657,5439.4256776094535,
	5440.258577173288,5441.107687320155,5441.972396419533,5442.852070914794,5443.746054964555,
	5444.653670100378,5445.574214902626,5446.506964696879,5447.4511712725725,5448.406062627137,
	5449.37084273732,5450.344691360674,5451.326763869868,5452.316191122352,5453.312079368605,
	5454.313510201575,5455.319540550407,5456.329202721634,5457.341504490851,5458.355429247997,
	5459.3699361995405,5460.383960630452,5461.396414229542,5462.406185480919,5463.41214012473,
	5464.413121690282,5465.407952104311,5466.395432376969,5467.3743433684585,5468.3434466384115,
	5469.301485380096,5470.24718544182,5471.179256436204,5472.096392939887,5472.9972757830965,
	5473.880573430908,5474.744943455395,5475.589034098642,5476.41148592572,5477.210933566327,
	5477.986007542691,5478.735336181903,5479.457547609003,5480.151271817334,5480.815142811647,
	5481.447800819362,5482.047894563718,5482.614083593197,5483.145040659848,5483.639454139326,
	5484.096030484503,5484.513496703785,5484.890602855353,5485.2261245475165,5485.518865434964,
	5485.767659700856,5485.971374513682,5486.128912448221,5486.23921385922,5486.301259196761,
	5486.3140712521545,5486.27671732316,5486.18831128756,5486.048015574686,5485.8550430244095,
	5485.608658623808,5485.308181112259,5484.952984446264,5484.542499116096,5484.076213307016,
	5483.553673898784,5482.974487297962,5482.338320098716,5481.644899568283,5480.894013955194,
	5480.085512618388,5479.219305977202,5478.295365282985,5477.313722214022,5476.274468296817,
	5475.177754157484,5474.023788608375,5472.812837575344,5471.545222872853,5470.221320833714,
	5468.841560802539,5467.406423500902,5465.916439274408,5464.3721862308485,5462.774288280787,
	5461.123413089959,5459.420269955582,5457.665607616625,5455.860212009687,5454.004903981139,
	5452.100536966414,5450.147994647381,5448.1481885978765,5446.102055927673,5444.0105569342295,
	5441.874672771924,5439.695403146982,5437.473764046506,5435.210785509222,5432.907509444805,
	5430.564987508354,5428.184279035537,5425.766449043849,5423.312566304219,5420.8237014869865,
	5418.300925385433,5415.745307219865,5413.157913023643,5410.539804113624,5407.892035645284,
	5405.2156552534825,5402.511701778733,5399.781204078806,5397.025179924679,5394.244634979885,
	5391.440561861674,5388.613939282509,5385.765731269275,5382.896886458912,5380.008337467102,
	5377.1010003278425,5374.175774001466,5371.233539947602,5368.275161760554,5365.301484864226,
	5362.313336263214,5359.311524347334,5356.296838746389,5353.270050232361,5350.231910665505,
	5347.183152982473,5344.124491222495,5341.05662058925,5337.980217546248,5334.895939942035,
	5331.804427163816,5328.706300316054,5325.602162422377,5322.492598648452,5319.3781765435,
	5316.259446298677,5313.136941020083,5310.011177014905,5306.882654089084,5303.751855854433,
	5300.619250044101,5297.485288835016,5294.350409175642,5291.215033118227,5288.079568154214,
	5284.944407551818,5281.809930694735,5278.676503421419,5275.544478363673,5272.414195284016,
	5269.285981411418,5266.160151774293,5263.037009530687,5259.916846294815,5256.7999424596,
	5253.686567515177,5250.576980362381,5247.471429621433,5244.370153935375,5241.2733822679875,
	5238.18133419617,5235.094220197154,5232.012241925977,5228.935592494927,5225.864456738611,
	5222.799011477046,5219.739425771907,5216.685861176204,5213.638471978168,5210.597405438583,
	5207.562802022077,5204.534795622608,5201.51351378227,5198.499077904659,5195.491603462109,
	5192.4912001970115,5189.497972317405,5186.512018687234,5183.533433010293,5180.5623040097435,
	5177.598715601256,5174.642747060454,5171.694473191238,5168.753964475705,5165.821287233536,
	5162.89650376863,5159.97967251315,5157.070848166748,5154.170081831707,5151.27742114289,
	5148.392910394864,5145.516590663339,5142.64849992398,5139.788673166524,5136.937142505403,
	5134.093937286882,5131.2590841922365,5128.432607337725,5125.614528371571,5122.804866566773,
	5120.003638911796,5117.210860197593,5114.426543101869,5111.65069827034,5108.883334395687,
	5106.12445829283,5103.374074972934,5100.632187713944,5097.898798128617,5095.173906231295,
	5092.457510500769,5089.749607942371,5087.050194147333,5084.359263349849,5081.6768084823825,
	5079.002821229764,5076.337292079663,5073.680210373127,5071.031564352184,5068.391341206369,
	5065.759527117304,5063.1361073016815,5060.521066053222,5057.91438678221,5055.316052054726,
	5052.726043629994,5050.1443424956615,5047.570928903695,5045.005782402728,5042.448881870944,
	5039.900205547451,5037.359731061615,5034.827435462832,5032.30329524774,5029.787286387583,
	5027.279384354079,5024.77956414445,5022.287800305438,5019.804066956667,5017.328337812984,
	5014.8605862062195,5012.400785105914,5009.948907139204,5007.504924610619,5005.068809520034,
	5002.640533581365,5000.220068239294,4997.8073846862535,4995.402453878347,4993.005246550773,
	4990.615733232601,4988.2338842618055,4985.859669797872,4983.4930598363235,4981.1340242205015,
	4978.782532655307,4976.438554715926,4974.102059863491,4971.773017453157,4969.451396745763,
	4967.137166917339,4964.830297069706,4962.5307562391345,4960.2385134057085,4957.953537502103,
	4955.675797422001,4953.405262027524,4951.141900157984,4948.885680636399,4946.636572276955,
	4944.394543892152,4942.159564298845,4939.931602324853,4937.710626815032,4935.496606637055,
	4933.289510685316,4931.089307893182,4928.895967227327,4926.709457700297,4924.529748373109,
	4922.35680835976,4920.190606831828,4918.031113021999,4915.8782962289115,4913.732125820174,
	4911.592571236353,4909.459601994591,4907.333187691601,4905.213298006854,4903.099902705939,
	4900.992971643188,4898.892474764272,4896.798382109301,4894.710663814713,4892.629290116438,
	4890.554231351331,4888.485457959854,4886.42294048791,4884.366649588965,4882.316556025725,
	4880.272630671685,4878.234844513481,4876.203168651353,4874.177574301942,4872.158032798422,
	4870.144515592717,4868.1369942563415,4866.135440481362,4864.139826081806,4862.150122994788,
	4860.1663032811475,4858.188339126266,4856.216202841385,4854.249866863606,4852.289303757417,
	4850.334486214671,4848.385387055631,4846.441979229276,4844.504235813526,4842.572130016592,
	4840.645635176317,4838.724724760944,4836.809372369865,4834.899551732883,4832.995236711752,
	4831.0964012988725,4829.203019619085,4827.315065927937,4825.432514613626,4823.555340195461,
	4821.683517325055,4819.817020785627,4817.95582549217,4816.099906491523,4814.249238961809,
	4812.40379821324,4810.5635596865095,4808.728498954297,4806.898591719625,4805.073813816732,
	4803.254141209934,4801.439549994258,4799.630016394303,4797.82551676486,4796.0260275893515,
	4794.2315254807345,4792.441987180871,4790.657389559314,4788.877709614316,4787.102924470998,
	4785.333011381986,4783.567947726877,4781.807711011153,4780.052278866481,4778.301629049731,
	4776.555739443035,4774.814588052763,4773.078153009407,4771.346412566839,4769.619345102247,
	4767.896929115267,4766.179143227158,4764.465966181253,4762.757376841289,4761.053354191672,
	4759.353877336978,4757.6589255006165,4755.968478024769,4754.282514370328,4752.601014115276,
	4750.923956955173,4749.2513227016925,4747.583091282624,4745.919242741878,4744.259757235748,
	4742.604615037321,4740.953796532259,4739.307282218951,4737.665052709178,4736.0270887252145,
	4734.393371101621,4732.7638807829835,4731.138598824531,4729.517506390043,4727.900584752906,
	4726.287815294375,4724.6791795035515,4723.074658975831,4721.474235414194,4719.87789062661,
	4718.285606526374,4716.6973651314875,4715.113148563817,4713.532939046655,4711.9567189125855,
	4710.384470589552,4708.816176609311,4707.25181960475,4705.691382309258,4704.134847555662,
	4702.582198276151,4701.03341750181,4699.48848836084,4697.947394079714,4696.4101179814215,
	4694.876643484733,4693.346954104946,4691.8210334513915,4690.298865228323,4688.780433234103,
	4687.265721359876,4685.75471358976,4684.247393999934,4682.743746758122,4681.243756122963,
	4679.747406443639,4678.254682158844,4676.76556779721,4675.280047975035,4673.798107397632,
	4672.3197308576755,4670.844903234546,4669.373609494517,4667.905834689319,4666.441563956602,
	4664.980782518313,4663.523475680951,4662.069628834604,4660.61922745269,4659.172257091301,
	4657.7287033884095,4656.288552063842,4654.851788918454,4653.418399833459,4651.988370770293,
	4650.561687770057,4649.138336951977,4647.718304514673,4646.301576734607,4644.888139965323,
	4643.47798063725,4642.071085257785,4640.667440410188,4639.267032752487,4637.8698490183815,
	4636.47587601588,4635.08510062668,4633.6975098065495,4632.3130905833705,4630.93183005832,
	4629.55371540459,4628.178733866622,4626.806872759954,4625.4381194715515,4624.072461457141,
	4622.709886243754,4621.350381426218,4619.993934669362,4618.640533705785,4617.2901663360635,
	4615.942820428382,4614.598483917656,4613.2571448057815,4611.918791160272,4610.583411115111,
	4609.250992868867,4607.921524684962,4606.594994891942,4605.271391881529,4603.950704109382,
	4602.63292009466,4601.318028418281,4600.006017724523,4598.696876719093,4597.390594169528,
	4596.0871589039225,4594.786559811399,4593.488785841224,4592.193826003392,4590.90166936623,
	4589.612305057574,4588.325722264684,4587.041910232264,4585.760858263505,4584.48255571912,
	4583.206992016912,4581.934156631471,4580.66403909426,4579.396628992078,4578.131915968726,
	4576.86988972163,4575.610540005022,4574.353856626554,4573.099829448631,4571.848448387525,
	4570.599703413389,4569.35358454917,4568.110081870387,4566.86918550595,4565.630885636743,
	4564.395172495126,4563.162036365199,4561.931467582787,4560.703456533713,4559.4779936546465,
	4558.255069432856,4557.0346744048165,4555.816799157323,4554.6014343255565,4553.388570594159,
	4552.178198696497,4550.9703094137185,4549.764893575315,4548.561942058618,4547.36144578756,
	4546.163395734036,4544.9677829144475,4543.77459839721,4542.5838332908415,4541.395478752506,
	4540.20952598425,4539.025966233781,4537.844790793372,4536.665991000882,4535.48955823707,
	4534.315483928177,4533.143759543733,4531.974376597041,4530.807326644501,4529.642601285209,
	4528.480192161984,4527.320090959219,4526.162289403319,4525.006779264172,4523.853552351446,
	4522.702600516962,4521.553915654155,4520.4074896965785,4519.263314619003,4518.121382436109,
	4516.981685202756,4515.844215014106,4514.708964004229,4513.575924347499,4512.4450882558585,
	4511.316447982016,4510.189995815963,4509.065724086424,4507.943625160168,4506.82369144253,
	4505.705915375337,4504.590289438789,4503.476806150209,4502.3654580632565,4501.2562377688755,
	4500.14913789437,4499.044151103281,4497.941270095454,4496.840487605594,4495.74179640553,
	4494.6451893014355,4493.550659134991,4492.458198782644,4491.367801155624,4490.279459200072,
	4489.193165895928,4488.108914257275,4487.026697332502,4485.946508203123,4484.868339984862,
	4483.792185825509,4482.718038907572,4481.645892444861,4480.575739684614,4479.507573906591,
	4478.4413884226915,4477.377176576823,4476.314931744626,4475.254647334012,4474.196316783484,
	4473.139933563109,4472.085491174968,4471.032983150962,4469.982403054154,4468.933744478134,
	4467.887001046898,4466.842166414787,4465.799234265397,4464.758198313465,4463.719052301924,
	4462.681790004124,4461.6464052221945,4460.612891787756,4459.581243561277,4458.551454431709,
	4457.52351831665,4456.497429162878,4455.473180944052,4454.450767660768,4453.430183348481,
	4452.411422062762,4451.394477889102,4450.379344940473,4449.366017357649,4448.354489308135,
	4447.344754986245,4446.336808613792,4445.330644438049,4444.326256733686,4443.323639801175,
	4442.3227879674,4441.323695585416,4440.32635703385,4439.330766713144,4438.33691906486,
	4437.344808532822,4436.3544296009495,4435.365776775663,4434.378844587565,4433.393627591837,
	4432.41012036851,4431.428317522781,4430.4482136830975,4429.469803503244,4428.493081660471,
	4427.518042856192,4426.54468181543,4425.572993287537,4424.602972044349,4423.634612881297,
	4422.667910619906,4421.702860100157,4420.739456188077,4419.777693793395,4418.817567762474,
	4417.859073093913,4416.90220472158,4415.946957623905,4414.993326802115,4414.041307279024,
	4413.090894099291,4412.142082329482,4411.194867057978,4410.2492433947,4409.305206471629,
	4408.362751441411,4407.421873478091,4406.482567777331,4405.544829554962,4404.608654048464,
	4403.674036515183,4402.740972234559,4401.809456505579,4400.879484648091,4399.951052001614,
	4399.0241539261315,4398.098785802543,4397.174943030397,4396.252621030156,4395.33181524149,
	4394.412521124154,4393.494734157048,4392.578449838124,4391.663663686341,4390.750371237712,
	4389.838568048319,4388.928249693924,4388.019411768092,4387.1120498837545,4386.206159672349,
	4385.301736787145,4384.398776891377,4383.497275674369,4382.59722884136,4381.698632115626,
	4380.801481239199,4379.905771971528,4379.011500089368,4378.118661389114,4377.227251682826,
	4376.337266801386,4375.4487025923545,4374.561554921775,4373.675819672252,4372.791492743705,
	4371.908570053112,4371.027047534912,4370.146921139831,4369.268186836072,4368.390840608513,
	4367.514878458474,4366.640296403701,4365.76709047876,4364.895256734772,4364.024791238741,
	4363.155690074144,4362.28794934059,4361.421565153776,4360.556533645288,4359.692850962767,
	4358.830513269229,4357.969516743696,4357.10985758148,4356.251531992647,4355.394536202317,
	4354.5388664519305,4353.684518998162,4352.831490112597,4351.979776081491,4351.129373207702,
	4350.280277807198,4349.432486212631,4348.585994769569,4347.740799840163,4346.896897800383,
	4346.054285040437,4345.212957966207,4344.372912996793,4343.534146566538,4342.696655123664,
	4341.8604351305785,4341.02548306395,4340.191795415149,4339.359368688279,4338.52819940232,
	4337.698284090118,4336.869619297844,4336.042201585414,4335.216027526972,4334.391093709458,
	4333.567396734123,4332.744933215282,4331.923699780199,4331.103693069989,4330.284909738835,
	4329.4673464543575,4328.650999897359,4327.835866760306,4327.021943750685,4326.209227587284,
	4325.3977150023375,4324.587402741467,4323.7782875615785,4322.970366233462,4322.163635540164,
	4321.358092276726,4320.553733250859,4319.750555284294,4318.948555207949,4318.147729868039,
	4317.348076119829,4316.549590834575,4315.752270892035,4314.95611318659,4314.161114623037,
	4313.367272118438,4312.574582602155,4311.783043015196,4310.992650309622,4310.20340144957,
	4309.415293411374,4308.628323182234,4307.842487760412,4307.057784157481,4306.274209393804,
	4305.491760503294,4304.710434529409,4303.930228528304,4303.151139566603,4302.373164719532,
	4301.596301080169,4300.82054574621,4300.045895828624,4299.272348448765,4298.499900738835,
	4297.728549842971,4296.958292913908,4296.189127117334,4295.421049627946,4294.654057631042,
	4293.888148324391,4293.1233189135355,4292.35956661641,4291.596888660109,4290.83528228234,
	4290.074744732451,4289.315273267775,4288.556865157139,4287.799517679123,4287.043228122683,
	4286.287993786539,4285.533811979289,4284.780680019831,4284.028595236556,4283.277554967499,
	4282.5275565617485,4281.77859737617,4281.030674779309,4280.28378614745,4279.537928868073,
	4278.793100337617,4278.049297961739,4277.306519155321,4276.56476134414,4275.824021961647,
	4275.084298451819,4274.345588266875,4273.607888868819,4272.871197729445,4272.1355123287285,
	4271.400830155903,4270.667148709841,4269.9344654982315,4269.202778037163,4268.472083852554,
	4267.742380478623,4267.013665458372,4266.28593634399,4265.55919069665,4264.83342608516,
	4264.108640088756,4263.384830293535,4262.661994295678,4261.940129698357,4261.219234115102,
	4260.499305166238,4259.780340482451,4259.062337700621,4258.345294467482,4257.629208437888,
	4256.914077274743,4256.199898649305,4255.486670241192,4254.774389737674,4254.06305483468,
	4253.352663236557,4252.643212654678,4251.934700809826,4251.227125429259,4250.52048424892,
	4249.814775013716,4249.109995474565,4248.406143391122,4247.703216531404,4247.001212670364,
	4246.300129591112,4245.599965084005,4244.900716947613,4244.202382988415,4243.5049610194765,
	4242.8084488623,4242.112844345683,4241.418145305347,4240.724349585782,4240.031455037438,
	4239.339459519776,4238.648360898282,4237.958157045819,4237.268845843304,4236.580425178425,
	4235.892892947377,4235.206247050526,4234.520485399253,4233.83560590895,4233.151606503539,
	4232.468485114397,4231.786239679137,4231.104868142049,4230.424368455687,4229.7447385786745,
	4229.065976477166,4228.388080122813,4227.7110474959745,4227.034876582534,4226.359565375816,
	4225.685111875859,4225.011514088936,4224.338770028971,4223.666877715446,4222.995835175297,
	4222.32564044248,4221.656291555571,4220.98778656216,4220.320123514504,4219.653300473338,
	4218.987315503282,4218.32216667814,4217.657852075709,4216.994369781952,4216.331717887775,
	4215.669894492233,4215.008897699229,4214.348725618932,4213.689376369097,4213.03084807181,
	4212.373138857191,4211.716246860432,4211.0601702231315,4210.404907093493,4209.750455624571,
	4209.096813977162,4208.443980316304,4207.791952815138,4207.14072965141,4206.490309007977,
	4205.840689076214,4205.191868050987,4204.543844134732,4203.896615534608,4203.250180464133,
	4202.604537142542,4201.959683795121,4201.315618653288,4200.672339952196,4200.029845935023,
	4199.388134849687,4198.747204949605,4198.10705449426,4197.467681748865,4196.829084983973,
	4196.1912624749575,4195.554212504281,4194.91793335918,4194.282423331781,4193.647680720379,
	4193.013703829123,4192.380490966811,4191.748040447473,4191.116350592205,4190.485419724756,
	4189.855246177254,4189.225828284787,4188.597164388779,4187.969252835702,4187.342091977605,
	4186.715680171311,4186.09001577934,4185.465097168904,4184.840922711905,4184.2174907875005,
	4183.594799777587,4182.972848070571,4182.351634059543,4181.731156142911,4181.111412722847,
	4180.492402208749,4179.8741230131845,4179.256573554919,4178.639752256601,4178.023657546548,
	4177.408287858127,4176.793641628483,4176.179717301194,4175.566513323516,4174.9540281480095,
	4174.342260232801,4173.731208039212,4173.120870034569,4172.511244690016,4171.90233048295,
	4171.294125893406,4170.686629408917,4170.079839517975,4169.473754717909,4168.86837350762,
	4168.263694390907,4167.659715878644,4167.056436482842,4166.453854722959,4165.851969118683,
	4165.250778202728,4164.650280504939,4164.050474560491,4163.451358911471,4162.852932103331,
	4162.255192684805,4161.658139211382,4161.061770240549,4160.466084336583,4159.871080066027,
	4159.276756001176,4158.683110718164,4158.090142797224,4157.497850823113,4156.906233384642,
	4156.315289076268,4155.725016494366,4155.135414241584,4154.546480923751,4153.958215150959,
	4153.370615538258,4152.783680702783,4152.197409269676,4151.611799863646,4151.0268511173645,
	4150.442561664963,4149.858930146171,4149.275955204397,4148.693635486927,4148.111969645838,
	4147.530956335273,4146.950594215439,4146.3708819498415,4145.791818206275,4145.213401655754,
	4144.635630973632,4144.058504839519,4143.482021936263,4142.906180951507,4142.330980576033,
	4141.756419504938,4141.182496436475,4140.609210074622,4140.036559123658,4139.464542295651,
	4138.893158304157,4138.3224058663145,4137.752283705011,4137.1827905450255,4136.613925115515,
	4136.045686148919,4135.478072382199,4134.911082555781,4134.344715413247,4133.778969702637,
	4133.21384417481,4132.6493375850505,4132.085448691769,4131.522176256958,4130.959519046892,
	4130.397475829997,4129.836045380184,4129.275226473453,4128.715017890232,4128.155418413673,
	4127.596426830947,4127.03804193296,4126.480262513358,4125.923087370319,4125.366515303678,
	4124.810545119815,4124.2551756253,4123.700405631452,4123.146233954036,4122.592659410366,
	4122.039680822296,4121.487297014716,4120.935506816268,4120.384309058363,4119.833702575897,
	4119.28368620749,4118.734258794625,4118.185419182753,4117.637166219027,4117.089498756227,
	4116.542415648193,4115.995915753214,4115.449997932819,4114.9046610509295,4114.359903975989,
	4113.8157255796,4113.272124733683,4112.729100317791,4112.186651211129,4111.644776296851,
	4111.10347446349,4110.562744599819,4110.0225855986055,4109.482996357163,4108.943975773613,
	4108.405522750827,4107.86763619448,4107.330315012507,4106.7935581163765,4106.257364421274,
	4105.7217328443085,4105.186662306865,4104.652151731535,4104.118200045725,4103.584806178418,
	4103.051969063056,4102.519687634828,4101.9879608319325,4101.456787596668,4100.92616687233,
	4100.396097607217,4099.86657875152,4099.337609258232,4098.809188083129,4098.281314185314,
	4097.753986526655,4097.227204071589,4096.700965788023,4096.175270646034,4095.6501176187744,
	4095.1255056828177,4094.6014338157497,4094.077901000936,4093.5549062214222,4093.0324484647026,
	4092.510526720853,4091.989139982323,4091.4682872452076,4090.947967506993,4090.4281797695025,
	4089.908923035704,4089.390196311922,4088.871998607422,4088.3543289342037,4087.8371863062166,
	4087.320569740822,4086.80447825801,4086.288910880178,4085.7738666317186,4085.2593445414172,
	4084.7453436382943,4084.231862956621,4083.7189015315694,4083.206458401047,4082.694532606024,
	4082.1831231893784,4081.672229197331,4081.161849678488,4080.6519836837733,4080.1426302665695,
	4079.6337884834547,4079.12545739202,4078.617636054286,4078.1103235343317,4077.6035188969427,
	4077.09722121134,4076.5914295490406,4076.0861429838187,4075.5813605906606,4075.0770814486086,
	4074.5733046383766,4074.0700292444217,4073.567254350489,4073.0649790475527,4072.563202424228,
	4072.0619235741437,4071.561141593211,4071.0608555782233,4070.5610646300406,4070.0617678516246,
	4069.5629643475577,4069.064653225166,4068.5668335936402,4068.069504566129,4067.5726652561743,
	4067.0763147807297,4066.580452258745,4066.0850768108826,4065.590187561428,4065.09578363563,
	4064.601864162974,4064.108428272634,4063.615475097635,4063.123003772891,4062.6310134362593,
	4062.139503225712,4061.648472284972,4061.1579197561614,4060.667844786584,4060.178246524326,
	4059.6891241197536,4059.200476725222,4058.7123034967703,4058.2246035904886,4057.737376166565,
	4057.250620385671,4056.7643354125967,4056.278520412231,4055.7931745526207,4055.308297003909,
	4054.8238869388374
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	10721.035383640725,10707.851918965107,10694.691631754065,10681.554468586672,10668.440376226146,
	10655.349301620794,10642.281191902435,10629.235994386736,10616.213656571004,10603.214126135512,
	10590.237350941117,10577.283279030033,10564.351858624128,10551.443038124868,10538.556766112782,
	10525.69299134676,10512.851662762472,10500.032729473918,10487.236140770483,10474.461846118344,
	10461.709795158169,10448.979937705448,10436.27222375045,10423.586603455868,10410.923027158187,
	10398.281445365796,10385.661808758956,10373.06406818909,10360.48817467852,10347.934079418877,
	10335.401733772364,10322.891089269291,10310.402097608725,10297.9347106575,10285.488880449395,
	10273.064559185354,10260.661699232392,10248.28025312317,10235.92017355532,10223.581413391215,
	10211.263925656944,10198.96766354239,10186.692580400404,10174.43862974615,10162.205765256895,
	10149.99394077092,10137.803110287925,10125.633227967493,10113.484248129838,10101.35612525355,
	10089.248813976534,10077.162269095426,10065.096445563759,10053.05129849355,10041.026783152925,
	10029.02285496679,10017.039469515332,10005.076582534839,9993.134149916195,9981.212127704952,
	9969.3104721,9957.429139454724,9945.5680862744,9933.72726921776,9921.906645095109,
	9910.10617086882,9898.325803651842,9886.565500707979,9874.825219451712,9863.104917446917,
	9851.404552406857,9839.724082193674,9828.063464818275,9816.422658439005,9804.80162136231,
	9793.200312041547,9781.618689076457,9770.056711213707,9758.514337345345,9746.991526508571,
	9735.488237886442,9724.004430805695,9712.540064737592,9701.095099297167,9689.669494242631,
	9678.263209474933,9666.876205038085,9655.5084411175,9644.159878040584,9632.830476276185,
	9621.520196433787,9610.228999263247,9598.956845654699,9587.703696638197,9576.469513382548,
	9565.254257195851,9554.05788952465,9542.880371953639,9531.72166620522,9520.581734139525,
	9509.460537752899,9498.35803917924,9487.274200688267,9476.20898468566,9465.162353712427,
	9454.134270445442,9443.12469769554,9432.133598408467,9421.160935664171,9410.206672676142,
	9399.270772791286,9388.353199489575,9377.453916383703,9366.572887218712,9355.710075871735,
	9344.86544635155,9334.03896279809,9323.230589482648,9312.440290806913,9301.66803130296,
	9290.913775632936,9280.177488588806,9269.45913509172,9258.758680191631,9248.076089067968,
	9237.411327027836,9226.764359506667,9216.135152068047,9205.523670402348,9194.929880327769,
	9184.353747788882,9173.795238857183,9163.254319730271,9152.73095673158,9142.225116310625,
	9131.736765041562,9121.265869624405,9110.812396883592,9100.376313768176,9089.95758735122,
	9079.556184829873,9069.172073525093,9058.805220881031,9048.455594464986,9038.12316196696,
	9027.807891199694,9017.509750098174,9007.22870671951,8996.96472924243,8986.717785966994,
	8976.487845314965,8966.274875828602,8956.078846171164,8945.899725126445,8935.737481598142,
	8925.592084610209,8915.46350330618,8905.351706949203,8895.2566649214,8885.178346723986,
	8875.1167219772,8865.07176041947,8855.043431907603,8845.03170641657,8835.036554038938,
	8825.057944985192,8815.095849582738,8805.150238276616,8795.221081628462,8785.30835031693,
	8775.412015136557,8765.53204699891,8755.668416931136,8745.821096076415,8735.990055693514,
	8726.175267156616,8716.37670195533,8706.594331693992,8696.828128092035,8687.078062983453,
	8677.344108316462,8667.626236154127,8657.924418672845,8648.238628163404,8638.568837030221,
	8628.915017790843,8619.277143076772,8609.655185631993,8600.04911831382,8590.458914092338,
	8580.884546050269,8571.325987382774,8561.783211397029,8552.256191512859,8542.744901261474,
	8533.24931428632,8523.769404342193,8514.305145295486,8504.85651112382,8495.423475916123,
	8486.006013872231,8476.604099302911,8467.21770662945,8457.84681038406,8448.491385209052,
	8439.151405857208,8429.82684719138,8420.517684184637,8411.223891919657,8401.945445589106,
	8392.682320495047,8383.434492049239,8374.201935772893,8364.984627296033,8355.78254235842,
	8346.595656808264,8337.423946603274,8328.26738780945,8319.125956601649,8309.999629263324,
	8300.888382186322,8291.79219187103,8282.71103492601,8273.644888067754,8264.593728121194,
	8255.557532018935,8246.536276801793,8237.529939617836,8228.538497723544,8219.561928482284,
	8210.600209365453,8201.65331795195,8192.721231927584,8183.803929085834,8174.901387327359,
	8166.013584659795,8157.140499198156,8148.2821091641645,8139.43839288673,8130.609328801518,
	8121.7948954511085,8112.9950714848055,8104.209835658701,8095.439166835447,8086.683043984396,
	8077.941446181622,8069.214352609342,8060.501742556602,8051.803595418824,8043.119890697709,
	8034.450608001376,8025.795727044463,8017.1552276475695,8008.529089738046,7999.917293349081,
	7991.319818620323,7982.7366457975695,7974.167755232837,7965.613127384217,7957.072742816149,
	7948.546582199087,7940.034626309714,7931.536856030914,7923.0532523515785,7914.583796366809,
	7906.128469277815,7897.687252392031,7889.260127123105,7880.847074990713,7872.448077620776,
	7864.063116745243,7855.692174202736,7847.335231937806,7838.992272001031,7830.663276549855,
	7822.348227847537,7814.047108263956,7805.759900275359,7797.486586464258,7789.227149519857,
	7780.981572237585,7772.749837519852,7764.531928375177,7756.327827918994,7748.137519373607,
	7739.960986067625,7731.798211436858,7723.649179023993,7715.513872478385,7707.392275556741,
	7699.28437212262,7691.190146146915,7683.109581707465,7675.042662989916,7666.98937428688,
	7658.949699998727,7650.923624633251,7642.911132805856,7634.912209240099,7626.926838766936,
	7618.955006325658,7610.996696963152,7603.051895835017,7595.1205882048625,7587.202759444618,
	7579.298395034996,7571.407480565157,7563.530001732991,7555.665944345288,7547.815294317871,
	7539.978037675957,7532.154160553603,7524.343649194446,7516.546489951923,7508.7626692887425,
	7500.992173777821,7493.234990101957,7485.491105054078,7477.760505537408,7470.0431785657875,
	7462.339111263405,7454.648290865709,7446.9707047187485,7439.306340279744,7431.655185117555,
	7424.017226912266,7416.392453455875,7408.780852652048,7401.182412516712,7393.597121177996,
	7386.02496687655,7378.465937965697,7370.920022911658,7363.387210293776,7355.867488804609,
	7348.360847250384,7340.867274550963,7333.386759740387,7325.919291966728,7318.4648604924105,
	7311.023454694924,7303.595064066236,7296.179678213799,7288.777286860391,7281.387879844459,
	7274.011447120191,7266.647978758299,7259.297464945753,7251.959895986165,7244.635262300393,
	7237.323554426255,7230.024763019286,7222.738878852937,7215.465892818587,7208.205795926165,
	7200.958579304256,7193.724234200515,7186.502751981802,7179.294124134673,7172.098342265684,
	7164.9153981016825,7157.7452834897695,7150.587990398418,7143.44351091713,7136.311837256853,
	7129.1929617507685,7122.086876853921,7114.993575144498,7107.9130493231905,7100.845292214209,
	7093.790296765504,7086.748056048942,7079.718563260998,7072.701811722875,7065.6977948809135,
	7058.7065063071805,7051.7279396995755,7044.762088882469,7037.808947807015,7030.868510551504,
	7023.94077132175,7017.025724451855,7010.123364403971,7003.233685769408,6996.356683268751,
	6989.49235175214,6982.640686200029,6975.801681723462,6968.975333564575,6962.161637097037,
	6955.360587826546,6948.572181391196,6941.796413562071,6935.033280243783,6928.282777474668,
	6921.544901427642,6914.819648410342,6908.10701486597,6901.406997373582,6894.7195926486675,
	6888.0447975436855,6881.382609048446,6874.733024290973,6868.096040537684,6861.471655194134,
	6854.859865805555,6848.260670057207,6841.674065775332,6835.100050927316,6828.538623622567,
	6821.989782112899,6815.4535247931735,6808.929850201965,6802.418757022103,6795.920244081173,
	6789.434310352398,6782.960954954903,6776.50017715468,6770.051976365028,6763.6163521472645,
	6757.193304211217,6750.782832416081,6744.384936770985,6737.999617435767,6731.626874721262,
	6725.266709090513,6718.919121159203,6712.584111696218,6706.261681624506,6699.951832021839,
	6693.654564121389,6687.369879312551,6681.097779141479,6674.838265312204,6668.591339686973,
	6662.357004287316,6656.135261294426,6649.926113050501,6643.729562058896,6637.545610985172,
	6631.374262658162,6625.215520070277,6619.06938637863,6612.935864905799,6606.81495914046,
	6600.706672738471,6594.611009523706,6588.527973488477,6582.457568795033,6576.3997997759525,
	6570.354670935185,6564.322186948828,6558.302352666223,6552.2951731105295,6546.300653480076,
	6540.318799148705,6534.349615667127,6528.3931087638275,6522.449284345735,6516.518148499542,
	6510.59970749208,6504.693967772053,6498.800935970406,6492.920618901551,6487.053023564289,
	6481.198157143013,6475.3560270082835,6469.526640718383,6463.7100060199045,6457.906130849084,
	6452.115023332524,6446.33669178882,6440.571144728868,6434.8183908577,6429.078439074938,
	6423.351298476282,6417.636978354607,6411.935488200735,6406.246837704987,6400.571036758094,
	6394.908095452374,6389.258024082882,6383.620833148596,6377.996533353576,6372.385135608349,
	6366.786651030609,6361.201090947043,6355.6284668941435,6350.068790619499,6344.522074083121,
	6338.988329458741,6333.467569134756,6327.959805716126,6322.465052024974,6316.983321102218,
	6311.514626208932,6306.05898082749,6300.616398662973,6295.186893644589,6289.770479926844,
	6284.36717189112,6278.976984146844,6273.599931532989,6268.236029119358,6262.885292208238,
	6257.5477363356,6252.223377272493,6246.912231026676,6241.61431384401,6236.329642209817,
	6231.058232850381,6225.800102734609,6220.5552690753875,6215.323749331046,6210.105561206989,
	6204.900722657228,6199.709251885886,6194.5311673488195,6189.36648775493,6184.21523206826,
	6179.0774195091035,6173.953069555842,6168.842201946431,6163.744836680487,6158.660994020061,
	6153.590694492181,6148.533958889995,6143.49080827457,6138.461263976751,6133.445347598657,
	6128.443081015474,6123.454486377162,6118.479586110189,6113.518402919491,6108.570959789853,
	6103.637279988001,6098.7173870642755,6093.811304854374,6088.919057481357,6084.040669357186,
	6079.176165184933,6074.325569960211,6069.488908973318,6064.66620781102,6059.857492358565,
	6055.0627888012295,6050.282123626611,6045.515523626388,6040.7630158981765,6036.024627847557,
	6031.300387190038,6026.590321952895,6021.894460477425,6017.212831420514,6012.545463757002,
	6007.892386781458,6003.25363011032,5998.629223683775,5994.019197768047,5989.423582957149,
	5984.842410175007,5980.275710677783,5975.723516055519,5971.185858234583,5966.662769479553,
	5962.1542823952495,5957.660429929209,5953.181245373259,5948.716762366046,5944.267014895034,
	5939.832037298589,5935.41186426818,5931.006530850399,5926.616072449298,5922.240524828449,
	5917.879924113034,5913.534306792142,5909.203709720729,5904.888170122103,5900.58772558979,
	5896.302414089849,5892.032273963067,5887.777343927088,5883.537663078532,5879.313270895324,
	5875.104207238775,5870.910512355682,5866.732226880719,5862.569391838434,5858.42204864531,
	5854.290239112286,5850.174005446647,5846.073390254121,5841.9884365412345,5837.919187717305,
	5833.8656875966535,5829.827980400644,5825.806110759847,5821.800123716093,5817.8100647246,
	5813.835979656025,5809.877914798484,5805.935916859651,5802.0100329686975,5798.100310678383,
	5794.206797966965,5790.329543240201,5786.468595333271,5782.624003512557,5778.795817477857,
	5774.9840873638805,5771.188863742192,5767.410197623172,5763.648140457503,5759.902744138102,
	5756.174061001669,5752.462143830404,5748.767045853617,5745.088820749194,5741.4275226452655,
	5737.783206121549,5734.155926210737,5730.545738399932,5726.952698631983,5723.376863306616,
	5719.818289281626,5716.277033874074,5712.753154861234,5709.246710481668,5705.757759436003,
	5702.2863608877915,5698.832574464351,5695.396460257225,5691.978078822866,5688.577491183092,
	5685.194758825379,5681.8299437032,5678.483108236136,5675.154315309966,5671.843628276529,
	5668.551110953531,5665.276827624313,5662.020843037252,5658.783222405353,5655.564031405266,
	5652.363336176667,5649.181203321034,5646.017699900441,5642.872893436339,5639.746851907824,
	5636.639643750023,5633.551337852095,5630.482003555157,5627.431710649936,5624.400529374231,
	5621.388530410109,5618.395784880971,5615.422364348259,5612.468340807992,5609.533786686988,
	5606.618774838854,5603.723378539663,5600.847671483418,5597.991727777052,5595.155621935248,
	5592.339428874967,5589.543223909381,5586.767082741841,5584.011081459132,5581.275296524422,
	5578.559804770104,5575.864683389734,5573.190009930006,5570.53586228185,5567.902318671564,
	5565.289457650986,5562.697358087485,5560.126099153327,5557.575760314482,5555.046421318924,
	5552.538162184295,5550.05106318516,5547.585204839295,5545.1406678936955,5542.717533309698,
	5540.315882247401,5537.935796049562,5535.577356224578,5533.24064442863,5530.9257424474035,
	5528.632732176353,5526.361695600822,5524.112714774643,5521.885871798275,5519.681248795668,
	5517.498927890368,5515.338991180376,5513.201520712146,5511.086598453359,5508.994306264555,
	5506.924725869592,5504.877938824961,5502.854026487659,5500.8530699819175,5498.875150164444,
	5496.920347588333,5494.988742465491,5493.080414627454,5491.195443484835,5489.3339079849875,
	5487.495886568026,5485.6814571211335,5483.890696931168,5482.123682635189,5480.380490169278,
	5478.661194715249,5476.965870645393,5475.294591465118,5473.647429753171,5472.024457100012,
	5470.425744043504,5468.85136000226,5467.301373206774,5465.77585062747,5464.2748579007475,
	5462.798459251708,5461.3467174144325,5459.919693549253,5458.517447156996,5457.14003599024,
	5455.787515961389,5454.459941047423,5453.15736319136,5451.879832200249,5450.627395639708,
	5449.400098724628,5448.197984206523,5447.021092256541,5445.8694603450485,5444.743123116939,
	5443.642112262763,5442.566456386045,5441.516180865673,5440.491307714513,5439.491855433297,
	5438.517838859699,5437.569269013258,5436.646152935103,5435.748493523168,5434.876289362425,
	5434.0295345501045,5433.208218516013,5432.412325837643,5431.641836050434,5430.896723452525,
	5430.176956904698,5429.482499624775,5428.813308977157,5428.169336256843,5427.550526468575,
	5426.956818100692,5426.388142893902,5425.844425605156,5425.325583766485,5424.831527439034,
	5424.362158962982,5423.9173727018715,5423.4970547837465,5423.101082837614,5422.729325726245,
	5422.381643275546,5422.057886000561,5421.757894828736,5421.481500820657,5421.228524888917,
	5420.998777515364,5420.7920584673875,5420.608156513902,5420.4468491415,5420.307902271507,
	5420.19106997896,5420.096094213649,5420.022704525116,5419.970617791346,5419.939537953295,
	5419.929155754985,5419.939148492251,5419.969179769035,5420.018899264127,5420.087942509107,
	5420.175930678863,5420.282470396179,5420.407153552092,5420.549557143278,5420.7092431284345,
	5420.885758305121,5421.078634208998,5421.287387037122,5421.511517597203,5421.7505112846575,
	5422.0038380895185,5422.270952634765,5422.551294248472,5422.844287071118,5423.14934020063,
	5423.465847876403,5423.793189704396,5424.130730925162,5424.477822726405,5424.833802601348,
	5425.197994754945,5425.5697105588915,5425.948249056608,5426.33289751947,5426.72293205476,
	5427.117618266266,5427.516211967754,5427.9179599492045,5428.322100796138,5428.727865761158,
	5429.134479687085,5429.541161980566,5429.947127634898,5430.351588299824,5430.753753396853,
	5431.152831276723,5431.548030417021,5431.9385606559545,5432.323634459021,5432.7024682145675,
	5433.074283553798,5433.438308690616,5433.793779776145,5434.139942263156,5434.4760522740535,
	5434.801377967497,5435.115200897017,5435.4168173559965,5435.705539702528,5435.980697657821,
	5436.241639572287,5436.487733652371,5436.718369142467,5436.932957455962,5437.130933248925,
	5437.311755431714,5437.474908112445,5437.619901468031,5437.74627253781,5437.853585935858,
	5437.941434478361,5438.009439722889,5438.057252416977,5438.084552854424,5438.091051137089,
	5438.07648734232,5438.040631595052,5437.983284045709,5437.904274754061,5437.803463481582,
	5437.680739393727,5437.536020675167,5437.369254061335,5437.1804142896335,5436.9695034747565,
	5436.736550412526,5436.481609817086,5436.2047614967905,5435.906109474134,5435.585781055234,
	5435.2439258549575,5434.880714783265,5434.496338998641,5434.091008835008,5433.664952707285,
	5433.218416001937,5432.751659957501,5432.26496054131,5431.7586073268,5431.232902376915,
	5430.688159138028,5430.124701348883,5429.542861968549,5428.9429821272015,5428.325410103052,
	5427.690500328632,5427.038612428816,5426.370110293394,5425.685361185913,5424.984734890378,
	5424.268602897677,5423.537337631897,5422.791311718441,5422.030897293138,5421.256465353693,
	5420.468385152528,5419.667023631438,5418.85274489689,5418.025909735964,5417.1868751715465,
	5416.335994056261,5415.473614703534,5414.600080554916,5413.715729882098,5412.820895522605,
	5411.91590464701,5411.001078556979,5410.076732512026,5409.143175583643,5408.200710535145,
	5407.249633725741,5406.2902350375825,5405.322797823462,5404.3475988745295,5403.364908406124,
	5402.374990060433,5401.3781009244485,5400.374491562291,5399.364406060064,5398.348082082592,
	5397.325750940752,5396.29763766773,5395.26396110421,5394.224933990601,5393.180763065867,
	5392.131649171983,5391.077787363149,5390.01936701928,5388.956571962405,5387.889580576371,
	5386.818565928367,5385.743695892013,5384.665133271807,5383.583035927802,5382.497556901056,
	5381.40884453829,5380.317042616719,5379.222290467516,5378.124723098611,5377.024471315995,
	5375.92166184345,5374.816417441698,5373.7088570207225,5372.599095759915,5371.48724521608,
	5370.373413434482,5369.257705055905,5368.140221422427,5367.021060679528,5365.900317876626,
	5364.778085064718,5363.654451391463,5362.52950319388,5361.403324088535,5360.275995058955,
	5359.147594540925,5358.018198504916,5356.887880536302,5355.756711913101,5354.624761681458,
	5353.492096728267,5352.358781851464,5351.224879832027,5350.0904514942995,5348.955555774134,
	5347.820249780127,5346.684588853361,5345.548626625283,5344.412415073861,5343.276004577851,
	5342.139443968751,5341.002780581399,5339.866060303183,5338.729327620439,5337.592625664511,
	5336.455996255337,5335.319479943955,5334.183116053428,5333.046942718372,5331.910996922812,
	5330.775314537267,5329.639930354223,5328.5048781220785,5327.370190578415,5326.235899482138,
	5325.1020356436875,5323.968628955331,5322.835708419345,5321.703302176215,5320.57143753067,
	5319.440140978273,5318.309438229412,5317.179354234074,5316.049913204558,5314.921138638262,
	5313.793053338737,5312.665679437202,5311.53903841224,5310.413151109493,5309.288037760355,
	5308.1637180000425,5307.040210885645,5305.917534912388,5304.795708030533,5303.674747660911,
	5302.554670710556,5301.435493587083,5300.317232213384,5299.199902041284,5298.0835180648355,
	5296.968094833629,5295.853646464593,5294.740186655194,5293.627728694035,5292.516285472884,
	5291.405869497658,5290.296492898388,5289.188167440602,5288.08090453419,5286.974715243836,
	5285.869610297936,5284.765600098056,5283.662694727124,5282.560903958482,5281.460237263949,
	5280.360703821682,5279.262312524083,5278.165071985404,5277.068990548657,5275.97407629308,
	5274.880337040772,5273.787780363516,5272.696413589209,5271.606243807771,5270.517277877668,
	5269.429522431788,5268.342983883084,5267.257668429849,5266.173582061648,5265.09073056426,
	5264.009119524932,5262.928754337109,5261.849640205548,5260.771782150719,5259.695185013916,
	5258.619853460766,5257.545791986359,5256.473004919256,5255.401496425083,5254.331270511257,
	5253.2623310312,5252.19468168444,5251.12832602638,5250.0632674673625,5248.999509277541,
	5247.937054590133,5246.875906404696,5245.8160675904455,5244.757540888919,5243.700328917791,
	5242.644434173102,5241.589859032506,5240.536605757929,5239.484676498505,5238.434073292857,
	5237.384798072214,5236.336852662426,5235.290238786955,5234.2449580686,5233.2010120325685,
	5232.158402106999,5231.117129630572,5230.077195846926,5229.038601911715,5228.001348893532,
	5226.965437776325,5225.9308694606325,5224.897644766275,5223.8657644335335,5222.835229125388,
	5221.80603942935,5220.778195858946,5219.751698855581,5218.726548790468,5217.702745965702,
	5216.680290615977,5215.659182910793,5214.639422955195,5213.621010791419,5212.603946400679,
	5211.5882297043845,5210.5738605652705,5209.560838789246,5208.549164126222,5207.538836271895,
	5206.52985486849,5205.522219506547,5204.515929725374,5203.5109850150975,5202.507384817455,
	5201.505128526454,5200.5042154901075,5199.504645011437,5198.506416349207,5197.509528719221,
	5196.51398129496,5195.519773209353,5194.526903554902,5193.535371384798,5192.545175714597,
	5191.5563155219,5190.568789748098,5189.582597299147,5188.597737046217,5187.6142078263165,
	5186.632008443675,5185.651137670066,5184.671594245878,5183.693376880506,5182.7164842535285,
	5181.7409150150825,5180.766667786757,5179.793741162333,5178.822133708354,5177.851843964707,
	5176.8828704455955,5175.91521163971,5174.9488660114175,5173.983832001061,5173.020108025316,
	5172.057692478118,5171.096583731322,5170.136780134999,5169.178280018297,5168.221081689371,
	5167.265183436636,5166.310583528939,5165.357280216105,5164.4052717293225,5163.454556281982,
	5162.505132069288,5161.556997270221,5160.610150046624,5159.6645885442085,5158.720310893108,
	5157.777315207545,5156.83559958787,5155.8951621190745,5154.956000872378,5154.018113905378,
	5153.081499262257,5152.1461549746455,5151.212079061162,5150.279269528266,5149.347724371019,
	5148.41744157266,5147.488419105563,5146.560654931053,5145.634147000177,5144.708893253852,
	5143.784891623291,5142.86214002957,5141.940636385706,5141.020378594667,5140.101364551618,
	5139.183592142968,5138.26705924714,5137.351763735301,5136.437703470021,5135.524876307829,
	5134.6132800976575,5133.702912681876,5132.793771896108,5131.885855570188,5130.979161527729,
	5130.073687586604,5129.169431559164,5128.26639125236,5127.364564468324,5126.463949004042,
	5125.564542652008,5124.666343200119,5123.769348432375,5122.873556128371,5121.978964063954,
	5121.0855700113025,5120.193371739067,5119.302367012775,5118.41255359478,5117.523929244339,
	5116.63649171804,5115.750238770185,5114.865168152148,5113.98127761309,5113.098564900614,
	5112.217027759589,5111.336663933789,5110.457471164919,5109.57944719307,5108.702589757524,
	5107.826896595813,5106.95236544457,5106.078994039349,5105.206780115513,5104.335721406421,
	5103.465815646665,5102.597060568534,5101.729453905406,5100.862993389638,5099.99767675399,
	5099.133501731249,5098.2704660538375,5097.408567454674,5096.547803667496,5095.688172425938,
	5094.829671464402,5093.972298517952,5093.116051322435,5092.260927615577,5091.406925132929,
	5090.554041614334,5089.702274799818,5088.851622429786,5088.002082247324,5087.153651995945,
	5086.306329420771,5085.460112268952,5084.614998289033,5083.770985230552,5082.928070846153,
	5082.086252889552,5081.245529116494,5080.405897284794,5079.567355154245,5078.729900487209,
	5077.893531047711,5077.05824460255,5076.224038920341,5075.390911770855,5074.558860931601,
	5073.727884176905,5072.897979285427,5072.069144039409,5071.241376222355,5070.414673621613,
	5069.589034027334,5068.76445523159,5067.940935030251,5067.118471222086,5066.2970616082,
	5065.476703993855,5064.657396186207,5063.839135996328,5063.0219212383745,5062.205749729313,
	5061.390619290041,5060.576527744393,5059.763472919438,5058.951452645987,5058.140464757852,
	5057.330507092992,5056.521577491862,5055.713673799489,5054.906793863852,5054.100935536936,
	5053.296096673538,5052.4922751334525,5051.689468778977,5050.887675476545,5050.086893096815,
	5049.287119513669,5048.488352604734,5047.69059025201,5046.893830340877,5046.098070760856,
	5045.303309405553,5044.509544171917,5043.716772961492,5042.924993679571,5042.134204235473,
	5041.344402542051,5040.555586517316,5039.767754082578,5038.980903163443,5038.19503168918,
	5037.410137593663,5036.626218815227,5035.843273295777,5035.061298981356,5034.280293822743,
	5033.5002557745065,5032.721182795467,5031.943072848972,5031.165923902241,5030.389733927045,
	5029.614500899401,5028.840222799477,5028.066897611801,5027.294523325285,5026.523097933283,
	5025.752619433014,5024.983085826611,5024.21449512039,5023.446845324883,5022.6801344547575,
	5021.9143605295985,5021.149521573326,5020.385615613945,5019.622640684157,5018.860594820855,
	5018.099476065391,5017.339282463742,5016.580012066097,5015.821662927078,5015.064233106207,
	5014.307720666236,5013.552123676258,5012.797440208118,5012.043668338658,5011.290806149625,
	5010.53885172734,5009.787803161113,5009.0376585465165,5008.28841598295,5007.540073573722,
	5006.7926294274275,5006.04608165655,5005.30042837854,5004.555667715063,5003.81179779224,
	5003.0688167406715,5002.326722695861,5001.5855137969265,5000.8451881879955,5000.1057440183895,
	4999.3671794405545,4998.629492612389,4997.892681695316,4997.15674485671,4996.421680266806,
	4995.6874861017295,4994.954160541084,4994.2217017691,4993.490107975076,4992.759377352094,
	4992.029508097736,4991.300498414691,4990.572346509792,4989.845050593636,4989.118608882158,
	4988.393019595666,4987.668280958298,4986.944391199174,4986.221348551484,4985.499151253503,
	4984.777797546874,4984.05728567865,4983.337613899599,4982.618780465854,4981.90078363656,
	4981.183621676188,4980.467292853714,4979.751795441993,4979.0371277184195,4978.323287965047,
	4977.61027446791,4976.898085517651,4976.186719409173,4975.476174441932,4974.766448919408,
	4974.057541149439,4973.349449444669,4972.642172121814,4971.935707501124,4971.23005390878,
	4970.5252096736285,4969.821173130379,4969.1179426165445,4968.415516474788,4967.713893052079,
	4967.013070699268,4966.313047771689,4965.61382262889,4964.915393634577,4964.217759156823,
	4963.520917568361,4962.824867245179,4962.1296065680235,4961.435133922552,4960.741447696964,
	4960.048546285281,4959.356428084843,4958.665091497177,4957.974534928336,4957.284756788179,
	4956.595755491205,4955.907529455977,4955.220077104274,4954.53339686368,4953.847487163797,
	4953.162346440361,4952.477973132178,4951.794365681923,4951.111522537165,4950.429442148858,
	4949.74812297279,4949.067563467372,4948.387762096745,4947.708717328244,4947.0304276331935,
	4946.352891487164,4945.67610736959,4945.000073764207,4944.324789158495,4943.650252043397,
	4942.976460915295,4942.303414272967,4941.631110620267,4940.959548464305,4940.288726316147,
	4939.6186426918,4938.94929610961,4938.280685093075,4937.612808169027,4936.945663868562,
	4936.279250725772,4935.613567280136,4934.948612074018,4934.284383652973,4933.620880568037,
	4932.958101372957,4932.296044625438,4931.634708887747,4930.974092724581,4930.314194705796,
	4929.655013404004,4928.996547396781,4928.338795263848,4927.68175559012,4927.025426963736,
	4926.369807976415,4925.714897224015,4925.060693305641,4924.407194824439,4923.754400386783,
	4923.102308603786,4922.450918089023,4921.800227460458,4921.150235339775,4920.500940351885,
	4919.852341125559,4919.204436292909,4918.5572244900595,4917.910704357331,4917.26487453719,
	4916.619733676714,4915.975280426068,4915.33151343915,4914.688431374572,4914.046032892138,
	4913.404316657142,4912.7632813379,4912.1229256056995,4911.483248136358,4910.8442476078335,
	4910.205922703412,4909.568272107744,4908.931294510536,4908.294988604503,4907.659353085831,
	4907.024386654107,4906.3900880121255,4905.7564558663325,4905.123488927073,4904.49118590744,
	4903.85954552378,4903.228566496783,4902.598247549203,4901.968587408691,4901.339584804322,
	4900.711238470838,4900.083547144977,4899.45650956633,4898.830124478385,4898.204390628979,
	4897.579306767329,4896.95487164861,4896.3310840274435,4895.707942664648,4895.085446323608,
	4894.463593771005,4893.842383776351,4893.221815113283,4892.601886557677,4891.982596889475,
	4891.3639448905615,4890.745929347541,4890.128549049511,4889.511802788671,4888.895689360171,
	4888.280207563207,4887.665356199295,4887.051134073626,4886.437539993762,4885.824572771703,
	4885.212231221014,4884.600514157507,4883.989420405686,4883.378948787274,4882.769098129288,
	4882.159867260512,4881.551255014432,4880.943260227544,4880.335881737716,4879.729118387559,
	4879.122969021979,4878.517432489096,4877.912507639826,4877.30819332853,4876.704488411885,
	4876.101391750051,4875.498902205672,4874.897018645455,4874.295739937907,4873.695064955274,
	4873.094992571794,4872.495521665403,4871.896651116727,4871.298379809677,4870.70070663044,
	4870.103630468492,4869.507150216163,4868.911264768508,4868.315973023514,4867.721273882212,
	4867.127166247898,4866.533649027725,4865.940721130567,4865.34838146883,4864.756628957994,
	4864.165462515538,4863.574881061869,4862.984883520749,4862.395468818199,4861.806635883584,
	4861.218383648882,4860.630711047488,4860.043617017964,4859.457100499714,4858.871160435663,
	4858.2857957709375,4857.701005454298,4857.116788436309,4856.533143670442,4855.950070113221,
	4855.367566723798,4854.785632463719,4854.204266297357,4853.62346719138,4853.043234115524,
	4852.4635660428485,4851.884461946961,4851.305920806527,4850.7279416011515,4850.15052331364,
	4849.573664929511,4848.997365437337,4848.4216238263725,4847.8464390906765,4847.2718102256995,
	4846.697736230056,4846.124216104052,4845.551248851545,4844.978833478148,4844.406968992744,
	4843.835654405742,4843.264888730959,4842.694670984394,4842.125000184513,4841.555875352671,
	4840.9872955120445,4840.419259688419,4839.851766910691,4839.284816209511,4838.718406618086,
	4838.15253717222,4837.587206911092,4837.022414874494,4836.458160105559,4835.89444165025,
	4835.33125855658,4834.768609874067,4834.206494656523,4833.644911958407,4833.083860837372,
	4832.5233403538505,4831.963349569286,4831.403887549005,4830.844953359221,4830.2865460701205,
	4829.728664752871,4829.171308481656,4828.614476332889,4828.058167384869,4827.502380718804,
	4826.947115418406,4826.392370568285,4825.838145256888,4825.28443857428,4824.731249612684,
	4824.178577466859,4823.626421233987,4823.07478001265,4822.52365290511,4821.9730390144905,
	4821.422937447344,4820.873347310464,4820.324267715328,4819.775697774402,4819.22763660265,
	4818.680083316123,4818.133037034828,4817.586496879587,4817.040461974853,4816.494931445314,
	4815.94990441944,4815.405380027221,4814.861357400807,4814.317835674345,4813.774813984139,
	4813.232291469252,4812.690267270589,4812.14874053055,4811.6077103945,4811.06717600915,
	4810.527136523687,4809.987591089806,4809.4485388608555,4808.909978991889,4808.371910640214,
	4807.834332966556,4807.297245131955,4806.760646299828,4806.224535636024,4805.688912308739,
	4805.153775487275,4804.61912434421,4804.08495805318,4803.551275790098,4803.018076732787,
	4802.4853600614115,4801.953124957394,4801.421370605346,4800.890096191081,4800.359300902448,
	4799.828983929367,4799.299144463652,4798.7697816992395,4798.240894832042,4797.712483059238,
	4797.184545581262,4796.657081599203,4796.130090317112,4795.603570939742,4795.0775226757705,
	4794.551944733269,4794.026836324405,4793.5021966616705,4792.9780249605665,4792.454320437929,
	4791.931082313054,4791.408309806042,4790.886002139777,4790.364158538434,4789.842778228941,
	4789.32186043885,4788.801404398946,4788.281409340894,4787.761874498394,4787.242799106885,
	4786.724182404085,4786.206023629302,4785.688322023187,4785.1710768291805,4784.654287291795,
	4784.137952657039,4783.622072174243,4783.106645092335,4782.591670664695,4782.077148143722,
	4781.5630767856455,4781.049455847333,4780.536284587428,4780.023562267879,4779.511288149929,
	4778.999461498781,4778.488081580008,4777.977147661848,4777.466659012686,4776.956614905186,
	4776.447014611698,4775.937857406598,4775.429142566884,4774.9208693701385,4774.413037096432,
	4773.905645027188,4773.39869244588,4772.892178637339,4772.386102887879,4771.8804644863085,
	4771.375262721492,4770.870496886307,4770.36616627346,4769.862270177926,4769.35880789595,
	4768.855778726571,4768.353181969017,4767.8510169255505,4767.34928289831,4766.847979192738,
	4766.347105115688,4765.846659973727,4765.346643078497,4764.847053740116,4764.347891271249,
	4763.8491549873015,4763.350844202921,4762.85295823745,4762.35549640903,4761.858458039013,
	4761.361842449992,4760.865648965043,4760.369876910788,4759.874525613674,4759.379594402698,
	4758.885082608327,4758.390989561539,4757.897314596796,4757.404057048446,4756.911216252999,
	4756.418791547746,4755.926782273279,4755.435187769483,4754.944007380277,4754.453240448065,
	4753.962886319907,4753.472944341894,4752.983413862938,4752.4942942333455,4752.005584804228,
	4751.517284928525,4751.029393960954,4750.541911258068,4750.054836176674,4749.568168075704,
	4749.081906316379,4748.596050259589,4748.110599269004,4747.625552709346,4747.1409099468265,
	4746.656670349602,4746.172833286704,4745.689398128381,4745.2063642464345,4744.723731014447,
	4744.241497807388,4743.759664001836,4743.278228975045,4742.797192106212,4742.316552775689,
	4741.836310366523,4741.356464260236,4740.877013841682,4740.3979584990975,4739.919297617451,
	4739.441030587185,4738.963156797229,4738.485675640554,4738.0085865095725,4737.531888798848,
	4737.055581903392,4736.579665221339,4736.104138150101,4735.629000090384,4735.154250442362,
	4734.679888609482,4734.205913995042,4733.732326004286,4733.259124044141,4732.786307521513,
	4732.313875845814,4731.841828428055,4731.370164680032,4730.89888401395,4730.427985845076,
	4729.957469588736,4729.487334662539,4729.017580483529,4728.5482064722555,4728.079212049246,
	4727.610596637533,4727.142359659123,4726.67450054075,4726.207018706255,4725.739913583897,
	4725.27318460253,4724.806831192296,4724.340852782671,4723.875248807945,4723.410018700021,
	4722.9451618948115,4722.4806778289485,4722.016565938677,4721.552825662861,4721.089456441153,
	4720.626457715114,4720.163828926793,4719.701569519507,4719.239678938828,4718.778156629263,
	4718.317002039181,4717.856214616771,4717.395793810905,4716.935739072916,4716.476049855566,
	4716.016725610631,4715.557765793286,4715.099169859264,4714.640937265284,4714.183067468844,
	4713.725559929101,4713.268414106813,4712.811629463503,4712.355205461938,4711.899141565409,
	4711.443437238983,4710.988091949579,4710.533105163648,4710.07847634956,4709.624204978411,
	4709.170290518679,4708.716732444737,4708.263530228223,4707.810683343478,4707.358191266164,
	4706.90605347296,4706.454269440466,4706.002838648465,4705.551760576735,4705.101034704989,
	4704.650660517603,4704.200637495707,4703.750965124291,4703.301642889866,4702.852670277695,
	4702.40404677531,4701.955771872754,4701.507845058119,4701.060265824438,4700.61303366137,
	4700.166148063729,4699.719608524879,4699.273414540595,4698.827565607312,4698.382061222146,
	4697.936900882799,4697.49208409012,4697.0476103448045,4696.603479147516,4696.159690001085,
	4695.716242410232,4695.273135879768,4694.830369914472,4694.387944022463,4693.945857711094,
	4693.5041104898855,4693.062701869064,4692.621631358538,4692.180898469348,4691.740502719388,
	4691.300443620104,4690.860720685951,4690.421333434787,4689.9822813828905,4689.543564049424,
	4689.105180952493,4688.667131613494,4688.229415553483,4687.792032294388,4687.354981359837,
	4686.918262274276,4686.481874562909,4686.045817752543,4685.610091369598,4685.174694943461,
	4684.739628003251,4684.304890078318,4683.870480700977,4683.436399402685,4683.002645717669,
	4682.569219179176,4682.136119323194,4681.703345685121,4681.27089780238,4680.838775213359,
	4680.40697745682,4679.975504072807,4679.544354602203,4679.11352858697,4678.683025570098,
	4678.25284509567,4677.822986707676,4677.393449951844,4676.9642343755895,4676.5353395258835,
	4676.1067649515535,4675.678510202157,4675.250574827038,4674.822958378166,4674.395660408718,
	4673.968680470414,4673.542018117381,4673.115672906171,4672.689644390873,4672.263932129395,
	4671.838535679153,4671.4134545983925,4670.988688447719,4670.564236785916,4670.140099175462,
	4669.716275178062,4669.292764357493,4668.869566277543,4668.446680502729,4668.024106599395,
	4667.60184413428,4667.17989267408,4666.758251787268,4666.336921044467,4665.915900015409,
	4665.4951882705645,4665.074785381944,4664.6546909230365,4664.234904467293,4663.815425588855,
	4663.396253864006,4662.977388867502,4662.558830178315,4662.140577373108,4661.722630031907,
	4661.304987733035,4660.887650058157,4660.470616588058,4660.053886904963,4659.637460592432,
	4659.221337233851,4658.8055164145035,4658.389997719681,4657.974780735803,4657.55986505047,
	4657.145250251706,4656.730935927594,4656.316921669212,4655.903207066101,4655.489791710706,
	4655.07667519357,4654.663857109414,4654.251337051515,4653.83911461395,4653.427189393035,
	4653.015560984584,4652.604228985475,4652.193192993996,4651.782452608948,4651.37200742973,
	4650.9618570557,4650.552001089203,4650.142439131262,4649.73317078564,4649.324195653776,
	4648.915513342415,4648.507123454874,4648.099025597279,4647.691219376779,4647.283704400153,
	4646.876480275095,4646.469546611905,4646.06290301924,4645.656549107805,4645.250484489339,
	4644.844708774399,4644.439221577726,4644.0340225112395,4643.629111189883,4643.224487228579,
	4642.820150243664,4642.416099850754,4642.012335668202,4641.608857313435,4641.205664405157,
	4640.802756563283
	}}
};
